/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.bucket.BucketRequest;
import com.tencent.cos.xml.model.tag.ReplicationConfiguration;
import com.tencent.cos.xml.transfer.XmlBuilder;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public class PutBucketReplicationRequest
extends BucketRequest {
    private ReplicationConfiguration replicationConfiguration = new ReplicationConfiguration();

    public PutBucketReplicationRequest(String bucket) {
        super(bucket);
        this.replicationConfiguration.rules = new ArrayList<ReplicationConfiguration.Rule>();
    }

    public void setReplicationConfigurationWithRole(String ownerUin, String subUin) {
        if (ownerUin != null && subUin != null) {
            String role;
            this.replicationConfiguration.role = role = "qcs::cam::uin/" + ownerUin + ":uin/" + subUin;
        }
    }

    public void setReplicationConfigurationWithRule(RuleStruct ruleStruct) {
        if (ruleStruct != null) {
            ReplicationConfiguration.Rule rule = new ReplicationConfiguration.Rule();
            rule.id = ruleStruct.id;
            rule.status = ruleStruct.isEnable ? "Enabled" : "Disabled";
            rule.prefix = ruleStruct.prefix;
            ReplicationConfiguration.Destination destination = new ReplicationConfiguration.Destination();
            destination.storageClass = ruleStruct.storageClass;
            StringBuilder bucket = new StringBuilder();
            bucket.append("qcs::cos:").append(ruleStruct.region).append("::").append(ruleStruct.bucket);
            destination.bucket = bucket.toString();
            rule.destination = destination;
            this.replicationConfiguration.rules.add(rule);
        }
    }

    @Override
    public String getMethod() {
        return "PUT";
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("replication", null);
        return super.getQueryString();
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        try {
            return RequestBodySerializer.string((String)"application/xml", (String)XmlBuilder.buildReplicationConfiguration(this.replicationConfiguration));
        }
        catch (XmlPullParserException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
        }
        catch (IOException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
        }
    }

    @Override
    public boolean isNeedMD5() {
        return true;
    }

    public static class RuleStruct {
        public String appid;
        public String region;
        public String bucket;
        public String storageClass;
        public String id;
        public String prefix;
        public boolean isEnable;
    }
}

