/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model;

import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.qcloud.core.http.RequestBodySerializer;

public class PresignedUrlRequest
extends CosXmlRequest {
    private String requestMethod = "GET";
    private String cosPath = "/";

    public PresignedUrlRequest(String bucket, String cosPath) {
        this.bucket = bucket;
        this.cosPath = cosPath;
    }

    public void setRequestMethod(String method) {
        this.requestMethod = method;
    }

    public void setCosPath(String cosPath) {
        if (cosPath != null) {
            this.cosPath = !cosPath.startsWith("/") ? "/" + cosPath : cosPath;
        }
    }

    @Override
    public String getMethod() {
        return this.requestMethod;
    }

    @Override
    public String getPath(CosXmlServiceConfig config) {
        return config.getUrlPath(this.bucket, this.cosPath);
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        return null;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        if (this.bucket == null || this.bucket.length() < 1) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "bucket must not be null ");
        }
        if (this.cosPath == null || this.cosPath.length() < 1) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "cosPath must not be null ");
        }
    }
}

