/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.Context;
import android.net.Uri;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.model.object.CopyObjectRequest;
import com.tencent.cos.xml.model.object.GetObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.transfer.COSXMLCopyTask;
import com.tencent.cos.xml.transfer.COSXMLDownloadTask;
import com.tencent.cos.xml.transfer.COSXMLTask;
import com.tencent.cos.xml.transfer.COSXMLUploadTask;
import com.tencent.cos.xml.transfer.TransferConfig;
import java.io.InputStream;

public class TransferManager {
    protected CosXmlSimpleService cosXmlService;
    protected TransferConfig transferConfig;

    public TransferManager(CosXmlSimpleService cosXmlService, TransferConfig transferConfig) {
        if (cosXmlService == null) {
            throw new IllegalArgumentException("CosXmlService is null");
        }
        if (transferConfig == null) {
            throw new IllegalArgumentException("TransferConfig is null");
        }
        this.cosXmlService = cosXmlService;
        this.transferConfig = transferConfig;
    }

    public COSXMLUploadTask upload(String bucket, String cosPath, String srcPath, String uploadId) {
        COSXMLUploadTask cosxmlUploadTask = new COSXMLUploadTask(this.cosXmlService, null, bucket, cosPath, srcPath, uploadId);
        cosxmlUploadTask.multiUploadSizeDivision = this.transferConfig.divisionForUpload;
        cosxmlUploadTask.sliceSize = this.transferConfig.sliceSizeForUpload;
        cosxmlUploadTask.upload();
        return cosxmlUploadTask;
    }

    public COSXMLUploadTask upload(String bucket, String cosPath, Uri uri, String uploadId) {
        COSXMLUploadTask cosxmlUploadTask = new COSXMLUploadTask(this.cosXmlService, null, bucket, cosPath, uri, uploadId);
        cosxmlUploadTask.multiUploadSizeDivision = this.transferConfig.divisionForUpload;
        cosxmlUploadTask.sliceSize = this.transferConfig.sliceSizeForUpload;
        cosxmlUploadTask.upload();
        return cosxmlUploadTask;
    }

    public COSXMLUploadTask upload(String bucket, String cosPath, byte[] bytes) {
        COSXMLUploadTask cosxmlUploadTask = new COSXMLUploadTask(this.cosXmlService, null, bucket, cosPath, bytes);
        cosxmlUploadTask.multiUploadSizeDivision = this.transferConfig.divisionForUpload;
        cosxmlUploadTask.sliceSize = this.transferConfig.sliceSizeForUpload;
        cosxmlUploadTask.upload();
        return cosxmlUploadTask;
    }

    public COSXMLUploadTask upload(String bucket, String cosPath, InputStream inputStream) {
        COSXMLUploadTask cosxmlUploadTask = new COSXMLUploadTask(this.cosXmlService, null, bucket, cosPath, inputStream);
        cosxmlUploadTask.multiUploadSizeDivision = this.transferConfig.divisionForUpload;
        cosxmlUploadTask.sliceSize = this.transferConfig.sliceSizeForUpload;
        cosxmlUploadTask.upload();
        return cosxmlUploadTask;
    }

    public COSXMLUploadTask upload(PutObjectRequest putObjectRequest, String uploadId) {
        COSXMLUploadTask cosxmlUploadTask = new COSXMLUploadTask(this.cosXmlService, putObjectRequest, uploadId);
        cosxmlUploadTask.multiUploadSizeDivision = this.transferConfig.divisionForUpload;
        cosxmlUploadTask.sliceSize = this.transferConfig.sliceSizeForUpload;
        cosxmlUploadTask.upload();
        return cosxmlUploadTask;
    }

    public COSXMLUploadTask upload(String bucket, String cosPath, String srcPath, String uploadId, COSXMLTask.OnSignatureListener onSignatureListener) {
        COSXMLUploadTask cosxmlUploadTask = new COSXMLUploadTask(this.cosXmlService, null, bucket, cosPath, srcPath, uploadId);
        cosxmlUploadTask.multiUploadSizeDivision = this.transferConfig.divisionForUpload;
        cosxmlUploadTask.sliceSize = this.transferConfig.sliceSizeForUpload;
        cosxmlUploadTask.setOnSignatureListener(onSignatureListener);
        cosxmlUploadTask.upload();
        return cosxmlUploadTask;
    }

    public COSXMLDownloadTask download(Context context, String bucket, String cosPath, String savedDirPath) {
        return this.download(context, bucket, cosPath, savedDirPath, null);
    }

    public COSXMLDownloadTask download(Context context, String bucket, String cosPath, String savedDirPath, String savedFileName) {
        COSXMLDownloadTask cosxmlDownloadTask = new COSXMLDownloadTask(context, this.cosXmlService, null, bucket, cosPath, savedDirPath, savedFileName);
        cosxmlDownloadTask.download();
        return cosxmlDownloadTask;
    }

    public COSXMLDownloadTask download(Context context, GetObjectRequest getObjectRequest) {
        COSXMLDownloadTask cosxmlDownloadTask = new COSXMLDownloadTask(context, this.cosXmlService, getObjectRequest);
        cosxmlDownloadTask.download();
        return cosxmlDownloadTask;
    }

    public COSXMLDownloadTask download(Context context, String bucket, String cosPath, String savedDirPath, String savedFileName, COSXMLTask.OnSignatureListener onSignatureListener) {
        COSXMLDownloadTask cosxmlDownloadTask = new COSXMLDownloadTask(context, this.cosXmlService, null, bucket, cosPath, savedDirPath, savedFileName);
        cosxmlDownloadTask.setOnSignatureListener(onSignatureListener);
        cosxmlDownloadTask.download();
        return cosxmlDownloadTask;
    }

    public COSXMLCopyTask copy(String bucket, String cosPath, CopyObjectRequest.CopySourceStruct copySourceStruct) {
        COSXMLCopyTask cosxmlCopyTask = new COSXMLCopyTask(this.cosXmlService, null, bucket, cosPath, copySourceStruct);
        cosxmlCopyTask.multiCopySizeDivision = this.transferConfig.divisionForCopy;
        cosxmlCopyTask.sliceSize = this.transferConfig.sliceSizeForCopy;
        cosxmlCopyTask.copy();
        return cosxmlCopyTask;
    }

    public COSXMLCopyTask copy(CopyObjectRequest copyObjectRequest) {
        COSXMLCopyTask cosxmlCopyTask = new COSXMLCopyTask(this.cosXmlService, copyObjectRequest);
        cosxmlCopyTask.multiCopySizeDivision = this.transferConfig.divisionForCopy;
        cosxmlCopyTask.sliceSize = this.transferConfig.sliceSizeForCopy;
        cosxmlCopyTask.copy();
        return cosxmlCopyTask;
    }

    public COSXMLCopyTask copy(String bucket, String cosPath, CopyObjectRequest.CopySourceStruct copySourceStruct, COSXMLTask.OnSignatureListener onSignatureListener) {
        COSXMLCopyTask cosxmlCopyTask = new COSXMLCopyTask(this.cosXmlService, null, bucket, cosPath, copySourceStruct);
        cosxmlCopyTask.multiCopySizeDivision = this.transferConfig.divisionForCopy;
        cosxmlCopyTask.sliceSize = this.transferConfig.sliceSizeForCopy;
        cosxmlCopyTask.setOnSignatureListener(onSignatureListener);
        cosxmlCopyTask.copy();
        return cosxmlCopyTask;
    }

    public CosXmlSimpleService getCosXmlService() {
        return this.cosXmlService;
    }
}

