/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.BaseMultipartUploadRequest;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.Map;

public final class ListPartsRequest
extends BaseMultipartUploadRequest {
    private String uploadId;
    private String maxParts;
    private String partNumberMarker;
    private String encodingType;

    public ListPartsRequest(String bucket, String cosPath, String uploadId) {
        super(bucket, cosPath);
        this.uploadId = uploadId;
    }

    public ListPartsRequest() {
        super(null, null);
    }

    @Override
    public String getMethod() {
        return "GET";
    }

    @Override
    public Map<String, String> getQueryString() {
        if (this.uploadId != null) {
            this.queryParameters.put("uploadId", this.uploadId);
        }
        if (this.maxParts != null) {
            this.queryParameters.put("max-parts", this.maxParts);
        }
        if (this.partNumberMarker != null) {
            this.queryParameters.put("part-number-marker", this.maxParts);
        }
        if (this.encodingType != null) {
            this.queryParameters.put("Encoding-type", this.encodingType);
        }
        return this.queryParameters;
    }

    @Override
    public RequestBodySerializer getRequestBody() {
        return null;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        super.checkParameters();
        if (this.requestURL != null) {
            return;
        }
        if (this.uploadId == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "uploadID must not be null");
        }
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public void setMaxParts(int maxParts) {
        maxParts = maxParts <= 0 ? 1 : maxParts;
        this.maxParts = String.valueOf(maxParts);
    }

    public int getMaxParts() {
        return Integer.parseInt(this.maxParts);
    }

    public void setPartNumberMarker(int partNumberMarker) {
        this.partNumberMarker = String.valueOf(partNumberMarker);
    }

    public int getPartNumberMarker() {
        return Integer.parseInt(this.partNumberMarker);
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    @Override
    public int getPriority() {
        return 3;
    }
}

