package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.tag.AccessControlPolicy;
import com.tencent.cos.xml.transfer.XmlParser;
import com.tencent.qcloud.core.http.HttpResponse;

import org.xmlpull.v1.XmlPullParserException;

import java.io.IOException;

final public class GetObjectACLResult extends CosXmlResult {
    /**
     * <a href="https://www.qcloud.com/document/product/436/7744"></a>
     */
    public AccessControlPolicy accessControlPolicy;

    @Override
    public void parseResponseBody(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        super.parseResponseBody(response);
        accessControlPolicy = new AccessControlPolicy();
        try {
            XmlParser.parseAccessControlPolicy(response.byteStream(), accessControlPolicy);
        } catch (XmlPullParserException e) {
            throw new CosXmlClientException(e);
        } catch (IOException e) {
            throw new CosXmlClientException(e);
        }
    }

    @Override
    public String printResult() {
        return accessControlPolicy != null ? accessControlPolicy.toString() : super.printResult();
    }
}
