package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.tag.DeleteResult;
import com.tencent.cos.xml.transfer.XmlParser;
import com.tencent.qcloud.core.http.HttpResponse;

import org.xmlpull.v1.XmlPullParserException;

import java.io.IOException;

final public class DeleteMultiObjectResult extends CosXmlResult {
    /**
     * <a href="https://www.qcloud.com/document/api/436/8289"></a>
     */
    public DeleteResult deleteResult;

    @Override
    public void parseResponseBody(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        super.parseResponseBody(response);
        deleteResult = new DeleteResult();
        try {
            XmlParser.parseDeleteResult(response.byteStream(), deleteResult);
        } catch (XmlPullParserException e) {
            throw new CosXmlClientException(e);
        } catch (IOException e) {
            throw new CosXmlClientException(e);
        }
    }

    @Override
    public String printResult() {
        return deleteResult != null ? deleteResult.toString() : super.printResult();
    }
}
