/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.tag.ListParts;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class UploadService {
    private CosXmlSimpleService cosXmlService;
    private String bucket;
    private String cosPath;
    private String srcPath;
    private long sliceSize = 0x200000L;
    private String uploadId;
    private long fileLength;
    private static final long SIZE_LIMIT = 0x200000L;
    private CosXmlProgressListener cosXmlProgressListener;
    private Map<Integer, SlicePartStruct> partStructMap;
    private AtomicInteger UPLOAD_PART_COUNT;
    private AtomicLong ALREADY_SEND_DATA_LEN;
    private volatile int ERROR_EXIT_FLAG;
    private byte[] objectSync = new byte[0];
    private Exception mException;
    private Map<UploadPartRequest, Long> uploadPartRequestLongMap;
    private InitMultipartUploadRequest initMultipartUploadRequest;
    private ListPartsRequest listPartsRequest;
    private CompleteMultiUploadRequest completeMultiUploadRequest;
    private PutObjectRequest putObjectRequest;
    private UploadServiceResult uploadServiceResult;
    private long startTime = -1L;
    private long endTime = -1L;
    private List<String> headers = new ArrayList<String>();

    public UploadService(CosXmlSimpleService cosXmlService, ResumeData resumeData) {
        this.cosXmlService = cosXmlService;
        this.init(resumeData);
    }

    private void init(ResumeData resumeData) {
        this.bucket = resumeData.bucket;
        this.cosPath = resumeData.cosPath;
        this.srcPath = resumeData.srcPath;
        this.sliceSize = resumeData.sliceSize;
        this.uploadId = resumeData.uploadId;
        this.UPLOAD_PART_COUNT = new AtomicInteger(0);
        this.ALREADY_SEND_DATA_LEN = new AtomicLong(0L);
        this.ERROR_EXIT_FLAG = 0;
        this.partStructMap = new LinkedHashMap<Integer, SlicePartStruct>();
        this.uploadPartRequestLongMap = new LinkedHashMap<UploadPartRequest, Long>();
    }

    private void checkParameter() throws CosXmlClientException {
        File file;
        if (this.srcPath != null && (file = new File(this.srcPath)).exists()) {
            this.fileLength = file.length();
            return;
        }
        throw new CosXmlClientException("srcPath :" + this.srcPath + " is invalid or is not exist");
    }

    public void setSign(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    private void setSignTime(CosXmlRequest cosXmlRequest) {
        if (cosXmlRequest != null && this.startTime > 0L && this.endTime >= this.startTime) {
            cosXmlRequest.setSign(this.startTime, this.endTime);
        }
    }

    public void setRequestHeaders(String key, String value) {
        if (key != null && value != null) {
            this.headers.add(key);
            this.headers.add(value);
        }
    }

    private void setRequestHeaders(CosXmlRequest cosXmlRequest) throws CosXmlClientException {
        if (cosXmlRequest != null) {
            int size = this.headers.size();
            for (int i = 0; i < size - 2; i += 2) {
                cosXmlRequest.setRequestHeaders(this.headers.get(i), this.headers.get(i + 1));
            }
        }
    }

    public UploadServiceResult upload() throws CosXmlClientException, CosXmlServiceException {
        this.checkParameter();
        if (this.fileLength < 0x200000L) {
            return this.putObject(this.bucket, this.cosPath, this.srcPath);
        }
        return this.multiUploadParts();
    }

    public CosXmlResult resume(ResumeData resumeData) throws CosXmlServiceException, CosXmlClientException {
        this.init(resumeData);
        return this.upload();
    }

    public ResumeData pause() {
        this.ERROR_EXIT_FLAG = 2;
        ResumeData resumeData = new ResumeData();
        resumeData.bucket = this.bucket;
        resumeData.cosPath = this.cosPath;
        resumeData.sliceSize = this.sliceSize;
        resumeData.srcPath = this.srcPath;
        resumeData.uploadId = this.uploadId;
        return resumeData;
    }

    public void abort(CosXmlResultListener cosXmlResultListener) {
        this.ERROR_EXIT_FLAG = 3;
        this.abortMultiUpload(cosXmlResultListener);
    }

    private void clear() {
        this.putObjectRequest = null;
        this.initMultipartUploadRequest = null;
        this.listPartsRequest = null;
        this.completeMultiUploadRequest = null;
        this.partStructMap.clear();
        this.uploadPartRequestLongMap.clear();
    }

    public void setProgressListener(CosXmlProgressListener cosXmlProgressListener) {
        this.cosXmlProgressListener = cosXmlProgressListener;
    }

    private UploadServiceResult putObject(String bucket, String cosPath, String srcPath) throws CosXmlClientException, CosXmlServiceException {
        this.UPLOAD_PART_COUNT.set(1);
        this.putObjectRequest = new PutObjectRequest(bucket, cosPath, srcPath);
        this.putObjectRequest.setProgressListener(this.cosXmlProgressListener);
        this.setSignTime(this.putObjectRequest);
        this.setRequestHeaders(this.putObjectRequest);
        this.cosXmlService.putObjectAsync(this.putObjectRequest, new CosXmlResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                byte[] byArray = UploadService.this.objectSync;
                synchronized (byArray) {
                    PutObjectResult putObjectResult = (PutObjectResult)result;
                    if (UploadService.this.uploadServiceResult == null) {
                        UploadService.this.uploadServiceResult = new UploadServiceResult();
                    }
                    ((UploadService)UploadService.this).uploadServiceResult.httpCode = putObjectResult.httpCode;
                    ((UploadService)UploadService.this).uploadServiceResult.httpMessage = putObjectResult.httpMessage;
                    ((UploadService)UploadService.this).uploadServiceResult.headers = putObjectResult.headers;
                    ((UploadService)UploadService.this).uploadServiceResult.eTag = putObjectResult.eTag;
                }
                UploadService.this.UPLOAD_PART_COUNT.decrementAndGet();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                byte[] byArray = UploadService.this.objectSync;
                synchronized (byArray) {
                    if (exception != null) {
                        UploadService.this.mException = (Exception)((Object)exception);
                    } else {
                        UploadService.this.mException = (Exception)((Object)serviceException);
                    }
                    UploadService.this.ERROR_EXIT_FLAG = 1;
                }
            }
        });
        while (this.UPLOAD_PART_COUNT.get() > 0 && this.ERROR_EXIT_FLAG == 0) {
        }
        if (this.ERROR_EXIT_FLAG > 0) {
            switch (this.ERROR_EXIT_FLAG) {
                case 2: {
                    this.realCancel();
                    this.clear();
                    throw new CosXmlClientException("request is cancelled by manual pause");
                }
                case 3: {
                    throw new CosXmlClientException("request is cancelled by abort request");
                }
                case 1: {
                    this.realCancel();
                    if (this.mException != null) {
                        if (this.mException instanceof CosXmlClientException) {
                            throw (CosXmlClientException)((Object)this.mException);
                        }
                        if (!(this.mException instanceof CosXmlServiceException)) break;
                        throw (CosXmlServiceException)((Object)this.mException);
                    }
                    throw new CosXmlClientException("unknown exception");
                }
            }
        }
        this.uploadServiceResult.accessUrl = this.cosXmlService.getAccessUrl(this.putObjectRequest);
        return this.uploadServiceResult;
    }

    private UploadServiceResult multiUploadParts() throws CosXmlClientException, CosXmlServiceException {
        this.initSlicePart();
        if (this.uploadId != null) {
            ListPartsResult listPartsResult = this.listPart();
            this.updateSlicePart(listPartsResult);
        } else {
            InitMultipartUploadResult initMultipartUploadResult = this.initMultiUpload();
            this.uploadId = initMultipartUploadResult.initMultipartUpload.uploadId;
        }
        for (Map.Entry entry : this.partStructMap.entrySet()) {
            final SlicePartStruct slicePartStruct = (SlicePartStruct)entry.getValue();
            if (slicePartStruct.isAlreadyUpload) continue;
            this.uploadPart(slicePartStruct.partNumber, slicePartStruct.offset, slicePartStruct.sliceSize, new CosXmlResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    byte[] byArray = UploadService.this.objectSync;
                    synchronized (byArray) {
                        slicePartStruct.eTag = ((UploadPartResult)result).eTag;
                        slicePartStruct.isAlreadyUpload = true;
                    }
                    UploadService.this.UPLOAD_PART_COUNT.decrementAndGet();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                    byte[] byArray = UploadService.this.objectSync;
                    synchronized (byArray) {
                        if (exception != null) {
                            UploadService.this.mException = (Exception)((Object)exception);
                        } else {
                            UploadService.this.mException = (Exception)((Object)serviceException);
                        }
                        UploadService.this.ERROR_EXIT_FLAG = 1;
                    }
                }
            });
        }
        while (this.UPLOAD_PART_COUNT.get() > 0 && this.ERROR_EXIT_FLAG == 0) {
        }
        if (this.ERROR_EXIT_FLAG > 0) {
            switch (this.ERROR_EXIT_FLAG) {
                case 2: {
                    this.realCancel();
                    this.clear();
                    throw new CosXmlClientException("request is cancelled by manual pause");
                }
                case 3: {
                    throw new CosXmlClientException("request is cancelled by abort request");
                }
                case 1: {
                    this.realCancel();
                    if (this.mException != null) {
                        if (this.mException instanceof CosXmlClientException) {
                            throw (CosXmlClientException)((Object)this.mException);
                        }
                        if (!(this.mException instanceof CosXmlServiceException)) break;
                        throw (CosXmlServiceException)((Object)this.mException);
                    }
                    throw new CosXmlClientException("unknown exception");
                }
            }
        }
        CompleteMultiUploadResult completeMultiUploadResult = this.completeMultiUpload();
        if (this.uploadServiceResult == null) {
            this.uploadServiceResult = new UploadServiceResult();
        }
        this.uploadServiceResult.httpCode = completeMultiUploadResult.httpCode;
        this.uploadServiceResult.httpMessage = completeMultiUploadResult.httpMessage;
        this.uploadServiceResult.headers = completeMultiUploadResult.headers;
        this.uploadServiceResult.eTag = completeMultiUploadResult.completeMultipartUpload.eTag;
        this.uploadServiceResult.accessUrl = this.cosXmlService.getAccessUrl(this.completeMultiUploadRequest);
        return this.uploadServiceResult;
    }

    private InitMultipartUploadResult initMultiUpload() throws CosXmlServiceException, CosXmlClientException {
        this.initMultipartUploadRequest = new InitMultipartUploadRequest(this.bucket, this.cosPath);
        this.setSignTime(this.initMultipartUploadRequest);
        this.setRequestHeaders(this.initMultipartUploadRequest);
        return this.cosXmlService.initMultipartUpload(this.initMultipartUploadRequest);
    }

    private ListPartsResult listPart() throws CosXmlServiceException, CosXmlClientException {
        this.listPartsRequest = new ListPartsRequest(this.bucket, this.cosPath, this.uploadId);
        this.setSignTime(this.listPartsRequest);
        this.setRequestHeaders(this.listPartsRequest);
        return this.cosXmlService.listParts(this.listPartsRequest);
    }

    private void uploadPart(int partNumber, long offset, long contentLength, CosXmlResultListener cosXmlResultListener) {
        final UploadPartRequest uploadPartRequest = new UploadPartRequest(this.bucket, this.cosPath, partNumber, this.srcPath, offset, contentLength, this.uploadId);
        this.uploadPartRequestLongMap.put(uploadPartRequest, 0L);
        this.setSignTime(uploadPartRequest);
        try {
            this.setRequestHeaders(uploadPartRequest);
        }
        catch (CosXmlClientException e) {
            cosXmlResultListener.onFail(this.putObjectRequest, e, null);
            return;
        }
        uploadPartRequest.setProgressListener(new CosXmlProgressListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProgress(long complete, long target) {
                byte[] byArray = UploadService.this.objectSync;
                synchronized (byArray) {
                    long dataLen = UploadService.this.ALREADY_SEND_DATA_LEN.addAndGet(complete - (Long)UploadService.this.uploadPartRequestLongMap.get(uploadPartRequest));
                    UploadService.this.uploadPartRequestLongMap.put(uploadPartRequest, complete);
                    if (UploadService.this.cosXmlProgressListener != null) {
                        UploadService.this.cosXmlProgressListener.onProgress(dataLen, UploadService.this.fileLength);
                    }
                }
            }
        });
        this.cosXmlService.uploadPartAsync(uploadPartRequest, cosXmlResultListener);
    }

    private CompleteMultiUploadResult completeMultiUpload() throws CosXmlServiceException, CosXmlClientException {
        this.completeMultiUploadRequest = new CompleteMultiUploadRequest(this.bucket, this.cosPath, this.uploadId, null);
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            SlicePartStruct slicePartStruct = entry.getValue();
            this.completeMultiUploadRequest.setPartNumberAndETag(slicePartStruct.partNumber, slicePartStruct.eTag);
        }
        this.setSignTime(this.completeMultiUploadRequest);
        this.setRequestHeaders(this.completeMultiUploadRequest);
        return this.cosXmlService.completeMultiUpload(this.completeMultiUploadRequest);
    }

    private void abortMultiUpload(final CosXmlResultListener cosXmlResultListener) {
        if (this.uploadId == null) {
            return;
        }
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest(this.bucket, this.cosPath, this.uploadId);
        this.setSignTime(abortMultiUploadRequest);
        try {
            this.setRequestHeaders(abortMultiUploadRequest);
        }
        catch (CosXmlClientException e) {
            cosXmlResultListener.onFail(abortMultiUploadRequest, e, null);
            return;
        }
        this.cosXmlService.abortMultiUploadAsync(abortMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                cosXmlResultListener.onSuccess(request, result);
                UploadService.this.realCancel();
                UploadService.this.clear();
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                cosXmlResultListener.onFail(request, exception, serviceException);
                UploadService.this.realCancel();
                UploadService.this.clear();
            }
        });
    }

    private void realCancel() {
        this.cosXmlService.cancel(this.putObjectRequest);
        this.cosXmlService.cancel(this.initMultipartUploadRequest);
        this.cosXmlService.cancel(this.listPartsRequest);
        this.cosXmlService.cancel(this.completeMultiUploadRequest);
        if (this.uploadPartRequestLongMap != null) {
            Set<UploadPartRequest> set = this.uploadPartRequestLongMap.keySet();
            Iterator<UploadPartRequest> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.cosXmlService.cancel(iterator.next());
            }
        }
    }

    private void initSlicePart() throws CosXmlClientException {
        if (this.srcPath != null) {
            File file = new File(this.srcPath);
            if (!file.exists()) {
                throw new CosXmlClientException("upload file does not exist");
            }
            this.fileLength = file.length();
        }
        if (this.fileLength > 0L && this.sliceSize > 0L) {
            SlicePartStruct slicePartStruct;
            int i;
            int count = (int)(this.fileLength / this.sliceSize);
            for (i = 1; i < count; ++i) {
                slicePartStruct = new SlicePartStruct();
                slicePartStruct.isAlreadyUpload = false;
                slicePartStruct.partNumber = i;
                slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
                slicePartStruct.sliceSize = this.sliceSize;
                this.partStructMap.put(i, slicePartStruct);
            }
            slicePartStruct = new SlicePartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = i;
            slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
            slicePartStruct.sliceSize = this.fileLength - slicePartStruct.offset;
            this.partStructMap.put(i, slicePartStruct);
            this.UPLOAD_PART_COUNT.set(i);
            return;
        }
        throw new CosXmlClientException("file size or slice size less than 0");
    }

    private void updateSlicePart(ListPartsResult listPartsResult) {
        List<ListParts.Part> parts;
        if (listPartsResult != null && listPartsResult.listParts != null && (parts = listPartsResult.listParts.parts) != null) {
            for (ListParts.Part part : parts) {
                if (!this.partStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
                SlicePartStruct slicePartStruct = this.partStructMap.get(Integer.valueOf(part.partNumber));
                slicePartStruct.isAlreadyUpload = true;
                slicePartStruct.eTag = part.eTag;
                this.UPLOAD_PART_COUNT.decrementAndGet();
                this.ALREADY_SEND_DATA_LEN.addAndGet(Long.parseLong(part.size));
            }
        }
    }

    public static class UploadServiceResult
    extends CosXmlResult {
        public String eTag;

        @Override
        public String printResult() {
            return super.printResult() + "\n" + "eTag:" + this.eTag + "\n" + "accessUrl:" + this.accessUrl;
        }
    }

    private static class SlicePartStruct {
        public int partNumber;
        public boolean isAlreadyUpload;
        public long offset;
        public long sliceSize;
        public String eTag;

        private SlicePartStruct() {
        }
    }

    public static class ResumeData {
        public String bucket;
        public String cosPath;
        public String srcPath;
        public String uploadId;
        public long sliceSize;
    }
}

