/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.ACLAccount;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.File;
import java.io.InputStream;
import java.util.Map;

public final class AppendObjectRequest
extends ObjectRequest {
    private long position = 0L;
    private String srcPath;
    private byte[] data;
    public InputStream inputStream;
    private long fileLength;
    private CosXmlProgressListener progressListener;

    private AppendObjectRequest(String bucket, String cosPath) {
        super(bucket, cosPath);
    }

    public AppendObjectRequest(String bucket, String cosPath, String srcPath, long position) {
        this(bucket, cosPath);
        this.srcPath = srcPath;
        this.position = position;
    }

    public AppendObjectRequest(String bucket, String cosPath, byte[] data, long position) {
        this(bucket, cosPath);
        this.data = data;
        this.position = position;
    }

    public AppendObjectRequest(String bucket, String cosPath, InputStream inputStream, long position) throws CosXmlClientException {
        this(bucket, cosPath);
        this.inputStream = inputStream;
        this.position = position;
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("append", null);
        this.queryParameters.put("position", String.valueOf(this.position));
        return this.queryParameters;
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        if (this.srcPath != null) {
            return RequestBodySerializer.file(null, (File)new File(this.srcPath));
        }
        if (this.data != null) {
            return RequestBodySerializer.bytes(null, (byte[])this.data);
        }
        if (this.inputStream != null) {
            return RequestBodySerializer.stream(null, (File)new File(CosXmlSimpleService.appCachePath), (InputStream)this.inputStream);
        }
        return null;
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        File file;
        super.checkParameters();
        if (this.srcPath == null && this.data == null && this.inputStream == null) {
            throw new CosXmlClientException("Data Source must not be null");
        }
        if (this.srcPath != null && !(file = new File(this.srcPath)).exists()) {
            throw new CosXmlClientException("upload file does not exist");
        }
    }

    public void setPosition(long position) {
        if (position < 0L) {
            this.position = 0L;
        }
        this.position = position;
    }

    public long getPosition() {
        return this.position;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getFileLength() {
        if (this.srcPath != null) {
            File file = new File(this.srcPath);
            this.fileLength = file.length();
        } else if (this.data != null) {
            this.fileLength = this.data.length;
        }
        return this.fileLength;
    }

    public void setProgressListener(CosXmlProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public CosXmlProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setCacheControl(String cacheControl) {
        if (cacheControl == null) {
            return;
        }
        this.addHeader("Cache-Control", cacheControl);
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return;
        }
        this.addHeader("Content-Disposition", contentDisposition);
    }

    public void setContentEncodeing(String contentEncoding) {
        if (contentEncoding == null) {
            return;
        }
        this.addHeader("Content-Encoding", contentEncoding);
    }

    public void setExpires(String expires) {
        if (expires == null) {
            return;
        }
        this.addHeader("Expires", expires);
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.addHeader(key, value);
        }
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl);
        }
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.addHeader("x-cos-acl", cosacl.getAcl());
        }
    }

    public void setXCOSGrantRead(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-read", aclAccount.getAccount());
        }
    }

    public void setXCOSGrantWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-write", aclAccount.getAccount());
        }
    }

    public void setXCOSReadWrite(ACLAccount aclAccount) {
        if (aclAccount != null) {
            this.addHeader("x-cos-grant-full-control", aclAccount.getAccount());
        }
    }
}

