/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import android.util.Log;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.utils.CloseUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FileUtils {
    public static String tempCache(InputStream inputStream) throws CosXmlClientException {
        String string;
        if (inputStream == null) {
            return null;
        }
        FileOutputStream fileOutputStream = null;
        try {
            String tempPath = CosXmlSimpleService.appCachePath + File.separator + "temp.tmp";
            Log.d((String)"UnitTest", (String)tempPath);
            File tempFile = new File(tempPath);
            if (tempFile.exists()) {
                tempFile.delete();
            }
            fileOutputStream = new FileOutputStream(tempFile);
            byte[] buffer = new byte[65536];
            int receiveLen = -1;
            while ((receiveLen = inputStream.read(buffer, 0, buffer.length)) > 0) {
                fileOutputStream.write(buffer, 0, receiveLen);
            }
            fileOutputStream.flush();
            string = tempPath;
        }
        catch (IOException e) {
            try {
                throw new CosXmlClientException(e);
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly(fileOutputStream);
                CloseUtil.closeQuietly(inputStream);
                throw throwable;
            }
        }
        CloseUtil.closeQuietly(fileOutputStream);
        CloseUtil.closeQuietly(inputStream);
        return string;
    }
}

