/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.tag.CompleteMultipartUploadResult;
import com.tencent.cos.xml.model.tag.CosError;
import com.tencent.cos.xml.transfer.XmlSlimParser;
import com.tencent.qcloud.core.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParserException;

public final class CompleteMultiUploadResult
extends CosXmlResult {
    public CompleteMultipartUploadResult completeMultipartUpload;

    @Override
    public void parseResponseBody(HttpResponse response) throws CosXmlServiceException, CosXmlClientException {
        super.parseResponseBody(response);
        ByteArrayInputStream inputStream = null;
        try {
            this.completeMultipartUpload = new CompleteMultipartUploadResult();
            byte[] contents = response.bytes();
            inputStream = new ByteArrayInputStream(contents);
            XmlSlimParser.parseCompleteMultipartUploadResult(inputStream, this.completeMultipartUpload);
            if ((this.completeMultipartUpload.eTag == null || this.completeMultipartUpload.key == null || this.completeMultipartUpload.bucket == null) && contents != null && contents.length > 0) {
                ((InputStream)inputStream).reset();
                CosXmlServiceException cosXmlServiceException = new CosXmlServiceException("failed");
                CosError cosError = new CosError();
                XmlSlimParser.parseError(inputStream, cosError);
                cosXmlServiceException.setErrorCode(cosError.code);
                cosXmlServiceException.setErrorMessage(cosError.message);
                cosXmlServiceException.setRequestId(cosError.requestId);
                cosXmlServiceException.setServiceName(cosError.resource);
                cosXmlServiceException.setStatusCode(response.code());
                throw cosXmlServiceException;
            }
        }
        catch (XmlPullParserException e) {
            throw new CosXmlClientException(ClientErrorCode.SERVERERROR.getCode(), e);
        }
        catch (IOException e) {
            throw new CosXmlClientException(ClientErrorCode.POOR_NETWORK.getCode(), e);
        }
    }

    @Override
    public String printResult() {
        return this.completeMultipartUpload != null ? this.completeMultipartUpload.toString() : super.printResult();
    }
}

