/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.Range;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.File;
import java.util.Map;

public class GetObjectRequest
extends ObjectRequest {
    private String rspContentType;
    private String rspContentLanguage;
    private String rspExpires;
    private String rspCacheControl;
    private String rspContentDisposition;
    private String rspContentEncoding;
    private String versionId;
    private Range range;
    private long fileOffset = 0L;
    private CosXmlProgressListener progressListener;
    private String savePath;
    private String saveFileName;

    public GetObjectRequest(String bucket, String cosPath, String savePath) {
        super(bucket, cosPath);
        this.savePath = savePath;
    }

    public GetObjectRequest(String bucket, String cosPath, String savePath, String saveFileName) {
        super(bucket, cosPath);
        this.savePath = savePath;
        this.saveFileName = saveFileName;
    }

    public GetObjectRequest() {
        super(null, null);
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public void setFileOffset(long fileOffset) {
        if (fileOffset > 0L) {
            this.fileOffset = fileOffset;
        }
    }

    public void setVersionId(String versionId) {
        this.versionId = versionId;
    }

    public void setRspContentType(String rspContentType) {
        this.rspContentType = rspContentType;
    }

    public String getRspContentType() {
        return this.rspContentType;
    }

    public void setRspContentLanguage(String rspContentLanguage) {
        this.rspContentLanguage = rspContentLanguage;
    }

    public String getRspContentLanguage() {
        return this.rspContentLanguage;
    }

    public void setRspExpires(String rspExpires) {
        this.rspExpires = rspExpires;
    }

    public String getRspExpires() {
        return this.rspExpires;
    }

    public void setRspCacheControl(String rspCacheControl) {
        this.rspCacheControl = rspCacheControl;
    }

    public String getRspCacheControl() {
        return this.rspCacheControl;
    }

    public void setRspContentDispositon(String rspContentDispositon) {
        this.rspContentDisposition = rspContentDispositon;
    }

    public String getRspContentDispositon() {
        return this.rspContentDisposition;
    }

    public void setRspContentEncoding(String rspContentEncoding) {
        this.rspContentEncoding = rspContentEncoding;
    }

    public String getRspContentEncoding() {
        return this.rspContentEncoding;
    }

    public void setRange(long start, long end) {
        if (start < 0L) {
            start = 0L;
        }
        Range range = new Range(start, end);
        this.addHeader("Range", range.getRange());
        this.range = range;
    }

    public void setRange(long start) {
        this.setRange(start, -1L);
    }

    public Range getRange() {
        return this.range;
    }

    public void setIfModifiedSince(String ifModifiedSince) {
        if (ifModifiedSince != null) {
            this.addHeader("If-Modified-Since", ifModifiedSince);
        }
    }

    public void setIfUnmodifiedSince(String ifUnmodifiedSince) {
        if (ifUnmodifiedSince != null) {
            this.addHeader("If-Unmodified-Since", ifUnmodifiedSince);
        }
    }

    public void setIfMatch(String ifMatch) {
        if (ifMatch != null) {
            this.addHeader("If-Match", ifMatch);
        }
    }

    public void setIfNONEMatch(String ifNONEMatch) {
        if (ifNONEMatch != null) {
            this.addHeader("If-None-Match", ifNONEMatch);
        }
    }

    public void setProgressListener(CosXmlProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public CosXmlProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public String getSavePath() {
        return this.savePath;
    }

    public void setSaveFileName(String saveFileName) {
        this.saveFileName = saveFileName;
    }

    public String getSaveFileName() {
        return this.saveFileName;
    }

    public String getDownloadPath() {
        String path = null;
        if (this.savePath != null) {
            path = !this.savePath.endsWith("/") ? this.savePath + "/" : this.savePath;
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (this.saveFileName != null) {
                path = path + this.saveFileName;
                return path;
            }
            if (this.cosPath != null) {
                int separator = this.cosPath.lastIndexOf("/");
                path = separator >= 0 ? path + this.cosPath.substring(separator + 1) : path + this.cosPath;
            }
        }
        return path;
    }

    @Override
    public String getMethod() {
        return "GET";
    }

    @Override
    public Map<String, String> getQueryString() {
        if (this.versionId != null) {
            this.queryParameters.put("versionId", this.versionId);
        }
        if (this.rspContentType != null) {
            this.queryParameters.put("response-content-type", this.rspContentType);
        }
        if (this.rspContentLanguage != null) {
            this.queryParameters.put("response-content-language", this.rspContentLanguage);
        }
        if (this.rspExpires != null) {
            this.queryParameters.put("response-expires", this.rspExpires);
        }
        if (this.rspCacheControl != null) {
            this.queryParameters.put("response-cache-control", this.rspCacheControl);
        }
        if (this.rspContentDisposition != null) {
            this.queryParameters.put("response-content-disposition", this.rspContentDisposition);
        }
        if (this.rspContentEncoding != null) {
            this.queryParameters.put("response-content-encoding", this.rspContentEncoding);
        }
        return super.getQueryString();
    }

    @Override
    public RequestBodySerializer getRequestBody() {
        return null;
    }
}

