/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.utils;

import android.text.TextUtils;
import android.util.Base64;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.utils.CloseUtil;
import com.tencent.cos.xml.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class DigestUtils {
    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMD5(String filePath) throws CosXmlClientException {
        String md5;
        if (filePath == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "file Path is null");
        }
        File file = new File(filePath);
        if (!file.exists()) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "file Path is not exist");
        }
        FileInputStream fileInputStream = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[32768];
            int len = -1;
            while ((len = fileInputStream.read(buffer)) != -1) {
                messageDigest.update(buffer, 0, len);
            }
            md5 = StringUtils.toHexString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            try {
                throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
                catch (FileNotFoundException e2) {
                    throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e2);
                }
                catch (IOException e3) {
                    throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e3);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        CloseUtil.closeQuietly(fileInputStream);
        return md5;
    }

    public static String getSha1(String content) throws CosXmlClientException {
        String sha1;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            sha1 = StringUtils.toHexString(messageDigest.digest(content.getBytes(Charset.forName("UTF-8"))));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        return sha1;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getSHA1FromPath(String filePath) throws CosXmlClientException {
        String sha1;
        FileInputStream fileInputStream = null;
        try {
            int len;
            fileInputStream = new FileInputStream(filePath);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[65536];
            while ((len = fileInputStream.read(buffer, 0, buffer.length)) != -1) {
                messageDigest.update(buffer, 0, len);
            }
            sha1 = StringUtils.toHexString(messageDigest.digest());
        }
        catch (FileNotFoundException e) {
            try {
                throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
                catch (IOException e2) {
                    throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e2);
                }
                catch (NoSuchAlgorithmException e3) {
                    throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e3);
                }
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        CloseUtil.closeQuietly(fileInputStream);
        return sha1;
    }

    public static String getSHA1FromBytes(byte[] data, int offset, int len) throws CosXmlClientException {
        String sha1;
        if (data == null || len <= 0 || offset < 0) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "data == null | len <= 0 |offset < 0 |offset >= len");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.update(data, offset, len);
            sha1 = StringUtils.toHexString(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        catch (OutOfMemoryError e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        return sha1;
    }

    public static String getHmacSha1(String content, String key) throws CosXmlClientException {
        String hmacSha1;
        try {
            byte[] byteKey = key.getBytes(Charset.forName("UTF-8"));
            SecretKeySpec hmacKey = new SecretKeySpec(byteKey, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(hmacKey);
            hmacSha1 = StringUtils.toHexString(mac.doFinal(content.getBytes(Charset.forName("UTF-8"))));
        }
        catch (NoSuchAlgorithmException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        catch (InvalidKeyException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
        return hmacSha1;
    }

    public static String getBase64(String content) throws CosXmlClientException {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return content;
        }
        try {
            return Base64.encodeToString((byte[])content.getBytes("utf-8"), (int)2);
        }
        catch (UnsupportedEncodingException e) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), e);
        }
    }
}

