/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.text.TextUtils;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.common.ClientErrorCode;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.Delete;
import com.tencent.cos.xml.transfer.XmlBuilder;
import com.tencent.qcloud.core.auth.STSCredentialScope;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public final class DeleteMultiObjectRequest
extends ObjectRequest {
    private Delete delete = new Delete();

    public DeleteMultiObjectRequest(String bucket, List<String> deleteObjectList) {
        super(bucket, null);
        this.delete.deleteObjects = new ArrayList<Delete.DeleteObject>();
        this.setObjectList(deleteObjectList);
    }

    public DeleteMultiObjectRequest() {
        super(null, null);
        this.delete.deleteObjects = new ArrayList<Delete.DeleteObject>();
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("delete", null);
        return this.queryParameters;
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        try {
            return RequestBodySerializer.string((String)"application/xml", (String)XmlBuilder.buildDelete(this.delete));
        }
        catch (XmlPullParserException e) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), e);
        }
        catch (IOException e) {
            throw new CosXmlClientException(ClientErrorCode.IO_ERROR.getCode(), e);
        }
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        if (this.requestURL != null) {
            return;
        }
        if (this.bucket == null) {
            throw new CosXmlClientException(ClientErrorCode.INVALID_ARGUMENT.getCode(), "bucket must not be null");
        }
        if (this.delete.deleteObjects.size() == 0) {
            throw new CosXmlClientException(ClientErrorCode.INTERNAL_ERROR.getCode(), "object\uff08null or empty) is invalid");
        }
    }

    @Override
    public STSCredentialScope[] getSTSCredentialScope(CosXmlServiceConfig config) {
        STSCredentialScope[] scopes = new STSCredentialScope[this.delete.deleteObjects.size()];
        int i = 0;
        for (Delete.DeleteObject deleteObject : this.delete.deleteObjects) {
            scopes[i++] = new STSCredentialScope("name/cos:DeleteObject", config.getBucket(this.bucket), config.getRegion(), deleteObject.key);
        }
        return scopes;
    }

    @Override
    public String getPath(CosXmlServiceConfig config) {
        return config.getUrlPath(this.bucket, "/");
    }

    public void setQuiet(boolean quiet) {
        this.delete.quiet = quiet;
    }

    public void setObjectList(String object) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return;
        }
        if (object != null) {
            if (object.startsWith("/")) {
                object = object.substring(1);
            }
            Delete.DeleteObject deleteObject = new Delete.DeleteObject();
            deleteObject.key = object;
            this.delete.deleteObjects.add(deleteObject);
        }
    }

    public void setObjectList(String object, String versionId) {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return;
        }
        if (object != null) {
            if (object.startsWith("/")) {
                object = object.substring(1);
            }
            Delete.DeleteObject deleteObject = new Delete.DeleteObject();
            deleteObject.key = object;
            if (versionId != null) {
                deleteObject.versionId = versionId;
            }
            this.delete.deleteObjects.add(deleteObject);
        }
    }

    public void setObjectList(List<String> objectList) {
        if (objectList != null) {
            int size = objectList.size();
            for (int i = 0; i < size; ++i) {
                Delete.DeleteObject deleteObject = new Delete.DeleteObject();
                String object = objectList.get(i);
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                deleteObject.key = object.startsWith("/") ? object.substring(1) : object;
                this.delete.deleteObjects.add(deleteObject);
            }
        }
    }

    public void setObjectList(Map<String, String> objectListWithVersionId) {
        if (objectListWithVersionId != null) {
            for (Map.Entry<String, String> entry : objectListWithVersionId.entrySet()) {
                Delete.DeleteObject deleteObject = new Delete.DeleteObject();
                String object = entry.getKey();
                String versionId = entry.getValue();
                if (TextUtils.isEmpty((CharSequence)object)) continue;
                deleteObject.key = object.startsWith("/") ? object.substring(1) : object;
                if (versionId != null) {
                    deleteObject.versionId = versionId;
                }
                this.delete.deleteObjects.add(deleteObject);
            }
        }
    }

    @Override
    public boolean isNeedMD5() {
        return true;
    }

    public Delete getDelete() {
        return this.delete;
    }
}

