/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml;

import android.content.Context;
import com.tencent.qcloud.core.logger.FileLogAdapter;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class LogServerProxy {
    private static final String TAG = "LogServerProxy";
    private final String className = "com.tencent.qcloud.logutils.LogServer";
    private final String interfaceName = "com.tencent.qcloud.logutils.OnLogListener";
    private final String interfaceMethodName = "onLoad";
    private Object logServer;
    private Method destroyResourceMethod;
    private Method setOnLogListenerMethod;
    private Context applicationContext;
    private static LogServerProxy instance;
    private FileLogAdapter fileLogAdapter;

    private LogServerProxy(Context applicationContext, final FileLogAdapter fileLogAdapter) {
        this.applicationContext = applicationContext;
        this.fileLogAdapter = fileLogAdapter;
        try {
            Class<?> cls = Class.forName("com.tencent.qcloud.logutils.LogServer");
            Constructor<?> constructor = cls.getConstructor(Context.class);
            if (constructor != null) {
                this.logServer = constructor.newInstance(this.applicationContext);
            }
            this.destroyResourceMethod = cls.getDeclaredMethod("destroy", new Class[0]);
            if (this.destroyResourceMethod != null) {
                this.destroyResourceMethod.setAccessible(true);
            }
            Class<?> interfaceCls = Class.forName("com.tencent.qcloud.logutils.OnLogListener");
            Object interfaceInstance = Proxy.newProxyInstance(LogServerProxy.class.getClassLoader(), new Class[]{interfaceCls}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("onLoad".equals(method.getName())) {
                        return fileLogAdapter.getLogFilesDesc(30);
                    }
                    return null;
                }
            });
            this.setOnLogListenerMethod = cls.getDeclaredMethod("setOnLogListener", interfaceCls);
            if (this.setOnLogListenerMethod != null) {
                this.setOnLogListenerMethod.setAccessible(true);
                this.setOnLogListenerMethod.invoke(this.logServer, interfaceInstance);
            }
        }
        catch (ClassNotFoundException e) {
            QCloudLogger.d((String)TAG, (String)"com.tencent.qcloud.logutils.LogServer : not found", (Object[])new Object[0]);
        }
        catch (NoSuchMethodException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (InstantiationException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (IllegalAccessException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
        catch (InvocationTargetException e) {
            QCloudLogger.d((String)TAG, (String)(e.getMessage() + " : not found"), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context, FileLogAdapter fileLogAdapter) {
        Class<LogServerProxy> clazz = LogServerProxy.class;
        synchronized (LogServerProxy.class) {
            if (instance == null) {
                instance = new LogServerProxy(context, fileLogAdapter);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static LogServerProxy getInstance() {
        return instance;
    }

    public FileLogAdapter getFileLogAdapter() {
        return this.fileLogAdapter;
    }

    public void destroy() {
        if (this.logServer != null && this.destroyResourceMethod != null) {
            try {
                this.destroyResourceMethod.invoke(this.logServer, new Object[0]);
            }
            catch (IllegalAccessException e) {
                QCloudLogger.d((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                QCloudLogger.d((String)TAG, (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }
}

