/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.Context;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.exception.CosXmlServiceException;
import com.tencent.cos.xml.listener.CosXmlProgressListener;
import com.tencent.cos.xml.listener.CosXmlResultListener;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.CosXmlResult;
import com.tencent.cos.xml.model.object.AbortMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadRequest;
import com.tencent.cos.xml.model.object.CompleteMultiUploadResult;
import com.tencent.cos.xml.model.object.InitMultipartUploadRequest;
import com.tencent.cos.xml.model.object.InitMultipartUploadResult;
import com.tencent.cos.xml.model.object.ListPartsRequest;
import com.tencent.cos.xml.model.object.ListPartsResult;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectRequest;
import com.tencent.cos.xml.model.object.PutObjectResult;
import com.tencent.cos.xml.model.object.UploadPartRequest;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.cos.xml.model.tag.ListParts;
import com.tencent.cos.xml.utils.SharePreferenceUtils;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class UploadService {
    private static String TAG = "UploadService";
    private CosXmlSimpleService cosXmlService;
    private String bucket;
    private String cosPath;
    private String srcPath;
    private long sliceSize = 0x100000L;
    private String uploadId;
    private long fileLength;
    private static final long SIZE_LIMIT = 0x200000L;
    private CosXmlProgressListener cosXmlProgressListener;
    private Map<Integer, SlicePartStruct> partStructMap;
    private AtomicInteger UPLOAD_PART_COUNT;
    private AtomicLong ALREADY_SEND_DATA_LEN;
    private volatile int ERROR_EXIT_FLAG;
    private byte[] objectSync = new byte[0];
    private Exception mException;
    private Map<UploadPartRequest, Long> uploadPartRequestLongMap;
    private InitMultipartUploadRequest initMultipartUploadRequest;
    private ListPartsRequest listPartsRequest;
    private CompleteMultiUploadRequest completeMultiUploadRequest;
    private PutObjectRequest putObjectRequest;
    private UploadServiceResult uploadServiceResult;
    private long startTime = -1L;
    private long endTime = -1L;
    ResumeData resumeData;
    private List<String> headers = new ArrayList<String>();
    private boolean isNeedMd5 = false;
    private SharePreferenceUtils sharePreferenceUtils;
    private OnUploadInfoListener onUploadInfoListener;
    private EncryptionType encryptionType = EncryptionType.NONE;
    private boolean isSupportAccelerate = false;
    private OnSignatureListener onSignatureListener;

    public UploadService(CosXmlSimpleService cosXmlService, ResumeData resumeData) {
        this.cosXmlService = cosXmlService;
        this.init(resumeData);
    }

    public UploadService(CosXmlSimpleService cosXmlService, String bucket, String cosPath, String srcPath, long sliceSize, Context context) {
        String uploadId = null;
        if (context != null) {
            this.sharePreferenceUtils = SharePreferenceUtils.instance(context.getApplicationContext());
            String key = this.getKey(cosXmlService, bucket, cosPath, srcPath, sliceSize);
            if (key != null) {
                uploadId = this.sharePreferenceUtils.getValue(key);
            }
        }
        ResumeData resumeData = new ResumeData();
        resumeData.bucket = bucket;
        resumeData.cosPath = cosPath;
        resumeData.sliceSize = sliceSize;
        resumeData.srcPath = srcPath;
        resumeData.uploadId = uploadId;
        this.cosXmlService = cosXmlService;
        this.init(resumeData);
    }

    String getKey(CosXmlSimpleService cosXmlService, String bucket, String cosPath, String srcPath, long sliceSize) {
        File file = new File(srcPath);
        if (file.exists()) {
            StringBuffer stringBuffer = new StringBuffer();
            String appid = cosXmlService != null ? cosXmlService.getAppid() : null;
            stringBuffer.append(appid).append(";").append(bucket).append(";").append(cosPath).append(";").append(srcPath).append(";").append(file.length()).append(";").append(file.lastModified()).append(";").append(sliceSize);
            return stringBuffer.toString();
        }
        return null;
    }

    void clearSharePreference() {
        if (this.sharePreferenceUtils != null) {
            this.sharePreferenceUtils.clear(this.getKey(this.cosXmlService, this.bucket, this.cosPath, this.srcPath, this.sliceSize));
        }
    }

    boolean updateSharePreference(String value) {
        if (this.sharePreferenceUtils != null) {
            return this.sharePreferenceUtils.updateValue(this.getKey(this.cosXmlService, this.bucket, this.cosPath, this.srcPath, this.sliceSize), value);
        }
        return false;
    }

    void init(ResumeData resumeData) {
        this.bucket = resumeData.bucket;
        this.cosPath = resumeData.cosPath;
        this.srcPath = resumeData.srcPath;
        this.sliceSize = resumeData.sliceSize;
        this.uploadId = resumeData.uploadId;
        this.UPLOAD_PART_COUNT = new AtomicInteger(0);
        this.ALREADY_SEND_DATA_LEN = new AtomicLong(0L);
        this.ERROR_EXIT_FLAG = 0;
        this.partStructMap = new LinkedHashMap<Integer, SlicePartStruct>();
        this.uploadPartRequestLongMap = new LinkedHashMap<UploadPartRequest, Long>();
        this.resumeData = resumeData;
    }

    private void checkParameter() throws CosXmlClientException {
        File file;
        if (this.srcPath != null && (file = new File(this.srcPath)).exists()) {
            this.fileLength = file.length();
            return;
        }
        throw new CosXmlClientException("srcPath :" + this.srcPath + " is invalid or is not exist");
    }

    public void setSign(long startTime, long endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    private void setSignTime(CosXmlRequest cosXmlRequest) {
        if (cosXmlRequest != null && this.startTime > 0L && this.endTime >= this.startTime) {
            cosXmlRequest.setSign(this.startTime, this.endTime);
        }
    }

    public void setOnSignatureListener(OnSignatureListener onSignatureListener) {
        this.onSignatureListener = onSignatureListener;
    }

    public void setRequestHeaders(String key, String value) {
        if (key != null && value != null) {
            this.headers.add(key);
            this.headers.add(value);
        }
    }

    public void setNeedMd5(boolean isNeed) {
        this.isNeedMd5 = isNeed;
    }

    public void setCOSServerSideEncryptionType(EncryptionType encryptionType) {
        this.encryptionType = encryptionType;
    }

    public void isSupportAccelerate(boolean isSupportAccelerate) {
        this.isSupportAccelerate = isSupportAccelerate;
    }

    private void setEncryption(CosXmlRequest cosXmlRequest) throws CosXmlClientException {
        if (cosXmlRequest == null) {
            return;
        }
        switch (this.encryptionType) {
            case NONE: {
                break;
            }
            case SSE: {
                ((ObjectRequest)cosXmlRequest).setCOSServerSideEncryption();
                break;
            }
            case SSEC: {
                ((ObjectRequest)cosXmlRequest).setCOSServerSideEncryptionWithCustomerKey(this.resumeData.customerKeyForSSEC);
                break;
            }
            case SSEKMS: {
                ((ObjectRequest)cosXmlRequest).setCOSServerSideEncryptionWithKMS(this.resumeData.customerKeyIdForSSEKMS, this.resumeData.jsonContentForSSEKMS);
            }
        }
    }

    public void setProgressListener(CosXmlProgressListener cosXmlProgressListener) {
        this.cosXmlProgressListener = cosXmlProgressListener;
    }

    public void setOnUploadInfoListener(OnUploadInfoListener onUploadInfoListener) {
        this.onUploadInfoListener = onUploadInfoListener;
    }

    private void setRequestHeaders(CosXmlRequest cosXmlRequest) throws CosXmlClientException {
        if (cosXmlRequest != null) {
            int size = this.headers.size();
            for (int i = 0; i < size - 2; i += 2) {
                cosXmlRequest.setRequestHeaders(this.headers.get(i), this.headers.get(i + 1), false);
            }
        }
    }

    private void setSupportAccelerate(CosXmlRequest cosXmlRequest) {
        if (cosXmlRequest != null && this.isSupportAccelerate) {
            cosXmlRequest.isSupportAccelerate(this.isSupportAccelerate);
        }
    }

    public UploadServiceResult upload() throws CosXmlClientException, CosXmlServiceException {
        this.checkParameter();
        if (this.fileLength < 0x200000L) {
            return this.putObject(this.bucket, this.cosPath, this.srcPath);
        }
        return this.multiUploadParts();
    }

    public CosXmlResult resume(ResumeData resumeData) throws CosXmlServiceException, CosXmlClientException {
        this.init(resumeData);
        return this.upload();
    }

    public ResumeData pause() {
        this.ERROR_EXIT_FLAG = 2;
        ResumeData resumeData = new ResumeData();
        resumeData.bucket = this.bucket;
        resumeData.cosPath = this.cosPath;
        resumeData.sliceSize = this.sliceSize;
        resumeData.srcPath = this.srcPath;
        resumeData.uploadId = this.uploadId;
        resumeData.customerKeyForSSEC = this.resumeData.customerKeyForSSEC;
        resumeData.customerKeyIdForSSEKMS = this.resumeData.customerKeyIdForSSEKMS;
        resumeData.jsonContentForSSEKMS = this.resumeData.jsonContentForSSEKMS;
        return resumeData;
    }

    public void abort(CosXmlResultListener cosXmlResultListener) {
        this.ERROR_EXIT_FLAG = 3;
        this.abortMultiUpload(cosXmlResultListener);
    }

    private void clear() {
        this.putObjectRequest = null;
        this.initMultipartUploadRequest = null;
        this.listPartsRequest = null;
        this.completeMultiUploadRequest = null;
        this.partStructMap.clear();
        this.uploadPartRequestLongMap.clear();
    }

    private UploadServiceResult putObject(String bucket, String cosPath, String srcPath) throws CosXmlClientException, CosXmlServiceException {
        this.UPLOAD_PART_COUNT.set(1);
        this.putObjectRequest = new PutObjectRequest(bucket, cosPath, srcPath);
        this.putObjectRequest.setProgressListener(this.cosXmlProgressListener);
        if (this.onSignatureListener != null) {
            this.putObjectRequest.setSign(this.onSignatureListener.onGetSign(this.putObjectRequest));
        } else {
            this.setSignTime(this.putObjectRequest);
        }
        this.setRequestHeaders(this.putObjectRequest);
        this.setSupportAccelerate(this.putObjectRequest);
        this.setEncryption(this.putObjectRequest);
        this.putObjectRequest.setNeedMD5(this.isNeedMd5);
        this.cosXmlService.putObjectAsync(this.putObjectRequest, new CosXmlResultListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                byte[] byArray = UploadService.this.objectSync;
                synchronized (byArray) {
                    PutObjectResult putObjectResult = (PutObjectResult)result;
                    if (UploadService.this.uploadServiceResult == null) {
                        UploadService.this.uploadServiceResult = new UploadServiceResult();
                    }
                    ((UploadService)UploadService.this).uploadServiceResult.httpCode = putObjectResult.httpCode;
                    ((UploadService)UploadService.this).uploadServiceResult.httpMessage = putObjectResult.httpMessage;
                    ((UploadService)UploadService.this).uploadServiceResult.headers = putObjectResult.headers;
                    ((UploadService)UploadService.this).uploadServiceResult.eTag = putObjectResult.eTag;
                }
                UploadService.this.UPLOAD_PART_COUNT.decrementAndGet();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                byte[] byArray = UploadService.this.objectSync;
                synchronized (byArray) {
                    if (exception != null) {
                        UploadService.this.mException = (Exception)((Object)exception);
                    } else {
                        UploadService.this.mException = (Exception)((Object)serviceException);
                    }
                    UploadService.this.ERROR_EXIT_FLAG = 1;
                }
            }
        });
        while (this.UPLOAD_PART_COUNT.get() > 0 && this.ERROR_EXIT_FLAG == 0) {
        }
        if (this.ERROR_EXIT_FLAG > 0) {
            switch (this.ERROR_EXIT_FLAG) {
                case 2: {
                    this.realCancel();
                    this.clear();
                    throw new CosXmlClientException("request is cancelled by manual pause");
                }
                case 3: {
                    throw new CosXmlClientException("request is cancelled by abort request");
                }
                case 1: {
                    this.realCancel();
                    if (this.mException != null) {
                        if (this.mException instanceof CosXmlClientException) {
                            throw (CosXmlClientException)((Object)this.mException);
                        }
                        if (!(this.mException instanceof CosXmlServiceException)) break;
                        throw (CosXmlServiceException)((Object)this.mException);
                    }
                    throw new CosXmlClientException("unknown exception");
                }
            }
        }
        this.uploadServiceResult.accessUrl = this.cosXmlService.getAccessUrl(this.putObjectRequest);
        return this.uploadServiceResult;
    }

    private UploadServiceResult multiUploadParts() throws CosXmlClientException, CosXmlServiceException {
        this.initSlicePart();
        if (this.uploadId != null) {
            ListPartsResult listPartsResult = this.listPart();
            this.updateSlicePart(listPartsResult);
        } else {
            InitMultipartUploadResult initMultipartUploadResult = this.initMultiUpload();
            this.uploadId = initMultipartUploadResult.initMultipartUpload.uploadId;
        }
        if (this.onUploadInfoListener != null) {
            ResumeData resumeData = new ResumeData();
            resumeData.bucket = this.bucket;
            resumeData.cosPath = this.cosPath;
            resumeData.sliceSize = this.sliceSize;
            resumeData.srcPath = this.srcPath;
            resumeData.uploadId = this.uploadId;
            resumeData.customerKeyForSSEC = this.resumeData.customerKeyForSSEC;
            resumeData.customerKeyIdForSSEKMS = this.resumeData.customerKeyIdForSSEKMS;
            resumeData.jsonContentForSSEKMS = this.resumeData.jsonContentForSSEKMS;
            this.onUploadInfoListener.onInfo(resumeData);
        }
        this.updateSharePreference(this.uploadId);
        for (Map.Entry entry : this.partStructMap.entrySet()) {
            final SlicePartStruct slicePartStruct = (SlicePartStruct)entry.getValue();
            if (slicePartStruct.isAlreadyUpload) continue;
            this.uploadPart(slicePartStruct.partNumber, slicePartStruct.offset, slicePartStruct.sliceSize, new CosXmlResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                    byte[] byArray = UploadService.this.objectSync;
                    synchronized (byArray) {
                        slicePartStruct.eTag = ((UploadPartResult)result).eTag;
                        slicePartStruct.isAlreadyUpload = true;
                    }
                    UploadService.this.UPLOAD_PART_COUNT.decrementAndGet();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                    byte[] byArray = UploadService.this.objectSync;
                    synchronized (byArray) {
                        if (exception != null) {
                            UploadService.this.mException = (Exception)((Object)exception);
                        } else {
                            UploadService.this.mException = (Exception)((Object)serviceException);
                        }
                        UploadService.this.ERROR_EXIT_FLAG = 1;
                    }
                }
            });
        }
        while (this.UPLOAD_PART_COUNT.get() > 0 && this.ERROR_EXIT_FLAG == 0) {
        }
        this.clearSharePreference();
        if (this.ERROR_EXIT_FLAG > 0) {
            switch (this.ERROR_EXIT_FLAG) {
                case 2: {
                    this.realCancel();
                    this.clear();
                    throw new CosXmlClientException("request is cancelled by manual pause");
                }
                case 3: {
                    throw new CosXmlClientException("request is cancelled by abort request");
                }
                case 1: {
                    this.realCancel();
                    if (this.mException != null) {
                        if (this.mException instanceof CosXmlClientException) {
                            throw (CosXmlClientException)((Object)this.mException);
                        }
                        if (!(this.mException instanceof CosXmlServiceException)) break;
                        throw (CosXmlServiceException)((Object)this.mException);
                    }
                    throw new CosXmlClientException("unknown exception");
                }
            }
        }
        CompleteMultiUploadResult completeMultiUploadResult = this.completeMultiUpload();
        if (this.uploadServiceResult == null) {
            this.uploadServiceResult = new UploadServiceResult();
        }
        this.uploadServiceResult.httpCode = completeMultiUploadResult.httpCode;
        this.uploadServiceResult.httpMessage = completeMultiUploadResult.httpMessage;
        this.uploadServiceResult.headers = completeMultiUploadResult.headers;
        this.uploadServiceResult.eTag = completeMultiUploadResult.completeMultipartUpload.eTag;
        this.uploadServiceResult.accessUrl = this.cosXmlService.getAccessUrl(this.completeMultiUploadRequest);
        return this.uploadServiceResult;
    }

    private InitMultipartUploadResult initMultiUpload() throws CosXmlServiceException, CosXmlClientException {
        this.initMultipartUploadRequest = new InitMultipartUploadRequest(this.bucket, this.cosPath);
        if (this.onSignatureListener != null) {
            this.initMultipartUploadRequest.setSign(this.onSignatureListener.onGetSign(this.initMultipartUploadRequest));
        } else {
            this.setSignTime(this.initMultipartUploadRequest);
        }
        this.setRequestHeaders(this.initMultipartUploadRequest);
        this.setSupportAccelerate(this.initMultipartUploadRequest);
        this.setEncryption(this.initMultipartUploadRequest);
        return this.cosXmlService.initMultipartUpload(this.initMultipartUploadRequest);
    }

    private ListPartsResult listPart() throws CosXmlServiceException, CosXmlClientException {
        this.listPartsRequest = new ListPartsRequest(this.bucket, this.cosPath, this.uploadId);
        if (this.onSignatureListener != null) {
            this.listPartsRequest.setSign(this.onSignatureListener.onGetSign(this.listPartsRequest));
        } else {
            this.setSignTime(this.listPartsRequest);
        }
        this.setRequestHeaders(this.listPartsRequest);
        this.setSupportAccelerate(this.listPartsRequest);
        return this.cosXmlService.listParts(this.listPartsRequest);
    }

    private void uploadPart(int partNumber, long offset, long contentLength, CosXmlResultListener cosXmlResultListener) {
        final UploadPartRequest uploadPartRequest = new UploadPartRequest(this.bucket, this.cosPath, partNumber, this.srcPath, offset, contentLength, this.uploadId);
        this.uploadPartRequestLongMap.put(uploadPartRequest, 0L);
        uploadPartRequest.setNeedMD5(this.isNeedMd5);
        if (this.onSignatureListener != null) {
            uploadPartRequest.setSign(this.onSignatureListener.onGetSign(uploadPartRequest));
        } else {
            this.setSignTime(uploadPartRequest);
        }
        try {
            this.setRequestHeaders(uploadPartRequest);
            this.setSupportAccelerate(uploadPartRequest);
            this.setEncryption(uploadPartRequest);
        }
        catch (CosXmlClientException e) {
            cosXmlResultListener.onFail(this.putObjectRequest, e, null);
            return;
        }
        uploadPartRequest.setProgressListener(new CosXmlProgressListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onProgress(long complete, long target) {
                byte[] byArray = UploadService.this.objectSync;
                synchronized (byArray) {
                    block6: {
                        try {
                            long dataLen = UploadService.this.ALREADY_SEND_DATA_LEN.addAndGet(complete - (Long)UploadService.this.uploadPartRequestLongMap.get(uploadPartRequest));
                            UploadService.this.uploadPartRequestLongMap.put(uploadPartRequest, complete);
                            if (UploadService.this.cosXmlProgressListener != null) {
                                UploadService.this.cosXmlProgressListener.onProgress(dataLen, UploadService.this.fileLength);
                            }
                        }
                        catch (Exception e) {
                            if (UploadService.this.ERROR_EXIT_FLAG <= 0) break block6;
                            QCloudLogger.d((String)TAG, (String)"upload file has been abort", (Object[])new Object[0]);
                        }
                    }
                }
            }
        });
        this.cosXmlService.uploadPartAsync(uploadPartRequest, cosXmlResultListener);
    }

    private CompleteMultiUploadResult completeMultiUpload() throws CosXmlServiceException, CosXmlClientException {
        this.completeMultiUploadRequest = new CompleteMultiUploadRequest(this.bucket, this.cosPath, this.uploadId, null);
        for (Map.Entry<Integer, SlicePartStruct> entry : this.partStructMap.entrySet()) {
            SlicePartStruct slicePartStruct = entry.getValue();
            this.completeMultiUploadRequest.setPartNumberAndETag(slicePartStruct.partNumber, slicePartStruct.eTag);
        }
        if (this.onSignatureListener != null) {
            this.completeMultiUploadRequest.setSign(this.onSignatureListener.onGetSign(this.completeMultiUploadRequest));
        } else {
            this.setSignTime(this.completeMultiUploadRequest);
        }
        this.setRequestHeaders(this.completeMultiUploadRequest);
        this.setSupportAccelerate(this.completeMultiUploadRequest);
        this.completeMultiUploadRequest.setNeedMD5(this.isNeedMd5);
        return this.cosXmlService.completeMultiUpload(this.completeMultiUploadRequest);
    }

    private void abortMultiUpload(final CosXmlResultListener cosXmlResultListener) {
        if (this.uploadId == null) {
            return;
        }
        AbortMultiUploadRequest abortMultiUploadRequest = new AbortMultiUploadRequest(this.bucket, this.cosPath, this.uploadId);
        if (this.onSignatureListener != null) {
            abortMultiUploadRequest.setSign(this.onSignatureListener.onGetSign(abortMultiUploadRequest));
        } else {
            this.setSignTime(abortMultiUploadRequest);
        }
        try {
            this.setRequestHeaders(abortMultiUploadRequest);
            this.setSupportAccelerate(abortMultiUploadRequest);
        }
        catch (CosXmlClientException e) {
            cosXmlResultListener.onFail(abortMultiUploadRequest, e, null);
            return;
        }
        this.cosXmlService.abortMultiUploadAsync(abortMultiUploadRequest, new CosXmlResultListener(){

            @Override
            public void onSuccess(CosXmlRequest request, CosXmlResult result) {
                cosXmlResultListener.onSuccess(request, result);
                UploadService.this.realCancel();
                UploadService.this.clear();
            }

            @Override
            public void onFail(CosXmlRequest request, CosXmlClientException exception, CosXmlServiceException serviceException) {
                cosXmlResultListener.onFail(request, exception, serviceException);
                UploadService.this.realCancel();
                UploadService.this.clear();
            }
        });
    }

    private void realCancel() {
        this.cosXmlService.cancel(this.putObjectRequest);
        this.cosXmlService.cancel(this.initMultipartUploadRequest);
        this.cosXmlService.cancel(this.listPartsRequest);
        this.cosXmlService.cancel(this.completeMultiUploadRequest);
        if (this.uploadPartRequestLongMap != null) {
            Set<UploadPartRequest> set = this.uploadPartRequestLongMap.keySet();
            Iterator<UploadPartRequest> iterator = set.iterator();
            while (iterator.hasNext()) {
                this.cosXmlService.cancel(iterator.next());
            }
        }
    }

    private void initSlicePart() throws CosXmlClientException {
        if (this.srcPath != null) {
            File file = new File(this.srcPath);
            if (!file.exists()) {
                throw new CosXmlClientException("upload file does not exist");
            }
            this.fileLength = file.length();
        }
        if (this.fileLength > 0L && this.sliceSize > 0L) {
            SlicePartStruct slicePartStruct;
            int i;
            int count = (int)(this.fileLength / this.sliceSize);
            for (i = 1; i < count; ++i) {
                slicePartStruct = new SlicePartStruct();
                slicePartStruct.isAlreadyUpload = false;
                slicePartStruct.partNumber = i;
                slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
                slicePartStruct.sliceSize = this.sliceSize;
                this.partStructMap.put(i, slicePartStruct);
            }
            slicePartStruct = new SlicePartStruct();
            slicePartStruct.isAlreadyUpload = false;
            slicePartStruct.partNumber = i;
            slicePartStruct.offset = (long)(i - 1) * this.sliceSize;
            slicePartStruct.sliceSize = this.fileLength - slicePartStruct.offset;
            this.partStructMap.put(i, slicePartStruct);
            this.UPLOAD_PART_COUNT.set(i);
            return;
        }
        throw new CosXmlClientException("file size or slice size less than 0");
    }

    private void updateSlicePart(ListPartsResult listPartsResult) {
        List<ListParts.Part> parts;
        if (listPartsResult != null && listPartsResult.listParts != null && (parts = listPartsResult.listParts.parts) != null) {
            for (ListParts.Part part : parts) {
                if (!this.partStructMap.containsKey(Integer.valueOf(part.partNumber))) continue;
                SlicePartStruct slicePartStruct = this.partStructMap.get(Integer.valueOf(part.partNumber));
                slicePartStruct.isAlreadyUpload = true;
                slicePartStruct.eTag = part.eTag;
                this.UPLOAD_PART_COUNT.decrementAndGet();
                this.ALREADY_SEND_DATA_LEN.addAndGet(Long.parseLong(part.size));
            }
        }
    }

    void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public static interface OnSignatureListener {
        public String onGetSign(CosXmlRequest var1);
    }

    public static interface OnUploadInfoListener {
        public void onInfo(ResumeData var1);
    }

    public static enum EncryptionType {
        SSE,
        SSEC,
        SSEKMS,
        NONE;

    }

    public static class UploadServiceResult
    extends CosXmlResult {
        public String eTag;

        @Override
        public String printResult() {
            return super.printResult() + "\neTag:" + this.eTag + "\naccessUrl:" + this.accessUrl;
        }
    }

    private static class SlicePartStruct {
        public int partNumber;
        public boolean isAlreadyUpload;
        public long offset;
        public long sliceSize;
        public String eTag;

        private SlicePartStruct() {
        }
    }

    public static class ResumeData {
        public String bucket;
        public String cosPath;
        public String srcPath;
        public String uploadId;
        public long sliceSize;
        public String customerKeyForSSEC;
        public String customerKeyIdForSSEKMS;
        public String jsonContentForSSEKMS;
    }
}

