/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import android.text.TextUtils;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.object.ObjectRequest;
import com.tencent.cos.xml.model.tag.Delete;
import com.tencent.cos.xml.transfer.XmlBuilder;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xmlpull.v1.XmlPullParserException;

public final class DeleteMultiObjectRequest
extends ObjectRequest {
    private Delete delete = new Delete();

    public DeleteMultiObjectRequest(String bucket, List<String> deleteObjectList) {
        super(bucket, null);
        this.delete.deleteObjects = new ArrayList<Delete.DeleteObject>();
        this.setObjectList(deleteObjectList);
    }

    public DeleteMultiObjectRequest() {
        super(null, null);
        this.delete.deleteObjects = new ArrayList<Delete.DeleteObject>();
    }

    @Override
    public String getMethod() {
        return "POST";
    }

    @Override
    public Map<String, String> getQueryString() {
        this.queryParameters.put("delete", null);
        return this.queryParameters;
    }

    @Override
    public RequestBodySerializer getRequestBody() throws CosXmlClientException {
        try {
            return RequestBodySerializer.string((String)"application/xml", (String)XmlBuilder.buildDelete(this.delete));
        }
        catch (XmlPullParserException e) {
            throw new CosXmlClientException(e);
        }
        catch (IOException e) {
            throw new CosXmlClientException(e);
        }
    }

    @Override
    public void checkParameters() throws CosXmlClientException {
        if (this.requestURL != null) {
            return;
        }
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
    }

    @Override
    public String getPath(CosXmlServiceConfig config) {
        StringBuilder path = new StringBuilder();
        String appid = config.getAppid();
        String fullBucketName = this.bucket;
        if (config.isBucketInPath()) {
            if (!fullBucketName.endsWith("-" + appid) && !TextUtils.isEmpty((CharSequence)appid)) {
                fullBucketName = fullBucketName + "-" + appid;
            }
            path.append("/");
            path.append(fullBucketName);
        }
        return path.append("/").toString();
    }

    public void setQuiet(boolean quiet) {
        this.delete.quiet = quiet;
    }

    public void setObjectList(String object) {
        if (object != null) {
            if (object.startsWith("/")) {
                object = object.substring(1);
            }
            Delete.DeleteObject deleteObject = new Delete.DeleteObject();
            deleteObject.key = object;
            this.delete.deleteObjects.add(deleteObject);
        }
    }

    public void setObjectList(String object, String versionId) {
        if (object != null) {
            if (object.startsWith("/")) {
                object = object.substring(1);
            }
            Delete.DeleteObject deleteObject = new Delete.DeleteObject();
            deleteObject.key = object;
            if (versionId != null) {
                deleteObject.versionId = versionId;
            }
            this.delete.deleteObjects.add(deleteObject);
        }
    }

    public void setObjectList(List<String> objectList) {
        if (objectList != null) {
            int size = objectList.size();
            for (int i = 0; i < size; ++i) {
                Delete.DeleteObject deleteObject = new Delete.DeleteObject();
                String object = objectList.get(i);
                deleteObject.key = object.startsWith("/") ? object.substring(1) : object;
                this.delete.deleteObjects.add(deleteObject);
            }
        }
    }

    public void setObjectList(Map<String, String> objectListWithVersionId) {
        if (objectListWithVersionId != null) {
            for (Map.Entry<String, String> entry : objectListWithVersionId.entrySet()) {
                Delete.DeleteObject deleteObject = new Delete.DeleteObject();
                String object = entry.getKey();
                String versionId = entry.getValue();
                deleteObject.key = object.startsWith("/") ? object.substring(1) : object;
                if (versionId != null) {
                    deleteObject.versionId = versionId;
                }
                this.delete.deleteObjects.add(deleteObject);
            }
        }
    }

    @Override
    public boolean isNeedMD5() {
        return true;
    }

    public Delete getDelete() {
        return this.delete;
    }
}

