/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model;

import android.text.TextUtils;
import com.tencent.cos.xml.CosXmlServiceConfig;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.utils.URLEncodeUtils;
import com.tencent.qcloud.core.auth.COSXmlSignSourceProvider;
import com.tencent.qcloud.core.auth.QCloudSignSourceProvider;
import com.tencent.qcloud.core.common.QCloudTaskStateListener;
import com.tencent.qcloud.core.http.HttpTask;
import com.tencent.qcloud.core.http.RequestBodySerializer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class CosXmlRequest {
    protected Map<String, String> queryParameters = new LinkedHashMap<String, String>();
    protected Map<String, List<String>> requestHeaders = new LinkedHashMap<String, List<String>>();
    private QCloudSignSourceProvider signSourceProvider;
    private HttpTask httpTask;
    private boolean isNeedMD5 = false;
    private boolean isSupportAccelerate = false;
    private String region;
    protected String domainSuffix;
    protected String requestURL;
    protected QCloudTaskStateListener qCloudTaskStateListener;

    public void setRequestURL(String requestURL) {
        this.requestURL = requestURL;
    }

    public String getRequestURL() {
        return this.requestURL;
    }

    public abstract String getMethod();

    protected abstract String getHostPrefix();

    public abstract String getPath(CosXmlServiceConfig var1);

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setRequestHeaders(Map<String, List<String>> headers) {
        if (headers != null) {
            this.requestHeaders.putAll(headers);
        }
    }

    public Map<String, String> getQueryString() {
        return this.queryParameters;
    }

    public Map<String, List<String>> getRequestHeaders() {
        return this.requestHeaders;
    }

    public abstract RequestBodySerializer getRequestBody() throws CosXmlClientException;

    public abstract void checkParameters() throws CosXmlClientException;

    public boolean isNeedMD5() {
        return this.isNeedMD5;
    }

    public void setNeedMD5(boolean isNeedMD5) {
        this.isNeedMD5 = isNeedMD5;
    }

    public void setTaskStateListener(QCloudTaskStateListener qCloudTaskStateListener) {
        this.qCloudTaskStateListener = qCloudTaskStateListener;
    }

    public QCloudTaskStateListener getTaskStateListener() {
        return this.qCloudTaskStateListener;
    }

    @Deprecated
    public void setRequestHeaders(String key, String value) throws CosXmlClientException {
        if (key != null && value != null) {
            value = URLEncodeUtils.cosPathEncode(value);
            this.addHeader(key, value);
        }
    }

    public void setRequestHeaders(String key, String value, boolean isUrlEncoder) throws CosXmlClientException {
        if (key != null && value != null) {
            if (isUrlEncoder) {
                value = URLEncodeUtils.cosPathEncode(value);
            }
            this.addHeader(key, value);
        }
    }

    protected void addHeader(String key, String value) {
        List<String> values = this.requestHeaders.containsKey(key) ? this.requestHeaders.get(key) : new ArrayList<String>();
        values.add(value);
        this.requestHeaders.put(key, values);
    }

    private String getHost(String appid, String region, String domainSuffix, boolean isBucketInPath, boolean isSupportAccelerate) throws CosXmlClientException {
        String realRegion;
        this.domainSuffix = domainSuffix;
        String bucket = this.getHostPrefix();
        String string = realRegion = this.getRegion() == null ? region : this.getRegion();
        if (!bucket.endsWith("-" + appid) && !TextUtils.isEmpty((CharSequence)appid)) {
            bucket = bucket + "-" + appid;
        }
        StringBuilder host = new StringBuilder();
        if (!isBucketInPath) {
            host.append(bucket);
            host.append(".");
        }
        if (isSupportAccelerate) {
            host.append("cos-accelerate");
        } else {
            host.append("cos");
            if (!TextUtils.isEmpty((CharSequence)realRegion)) {
                host.append(".");
                host.append(realRegion);
            }
        }
        host.append(".").append(domainSuffix);
        return host.toString();
    }

    public String getHost(CosXmlServiceConfig config, boolean isSupportAccelerate) throws CosXmlClientException {
        return this.getHost(config.getAppid(), config.getRegion(), config.getDomainSuffix(), config.isBucketInPath(), isSupportAccelerate);
    }

    public void isSupportAccelerate(boolean isSupportAccelerate) {
        this.isSupportAccelerate = isSupportAccelerate;
    }

    public boolean isSupportAccelerate() {
        return this.isSupportAccelerate;
    }

    public void setSign(String sign) {
        this.addHeader("Authorization", sign);
    }

    public void setSign(long signDuration) {
        this.signSourceProvider = new COSXmlSignSourceProvider().setDuration(signDuration);
    }

    public void setSign(long startTime, long endTime) {
        this.signSourceProvider = new COSXmlSignSourceProvider().setSignBeginTime(startTime).setSignExpiredTime(endTime);
    }

    public QCloudSignSourceProvider getSignSourceProvider() {
        if (this.signSourceProvider == null) {
            this.signSourceProvider = new COSXmlSignSourceProvider().setDuration(600L);
        }
        return this.signSourceProvider;
    }

    public void setSign(long signDuration, Set<String> parameters, Set<String> headers) {
        COSXmlSignSourceProvider cosXmlSignSourceProvider = new COSXmlSignSourceProvider().setDuration(signDuration);
        cosXmlSignSourceProvider.parameters(parameters);
        cosXmlSignSourceProvider.headers(headers);
        this.signSourceProvider = cosXmlSignSourceProvider;
    }

    public void setSign(long startTime, long endTime, Set<String> parameters, Set<String> headers) {
        COSXmlSignSourceProvider cosXmlSignSourceProvider = new COSXmlSignSourceProvider().setSignBeginTime(startTime).setSignExpiredTime(endTime);
        cosXmlSignSourceProvider.parameters(parameters);
        cosXmlSignSourceProvider.headers(headers);
        this.signSourceProvider = cosXmlSignSourceProvider;
    }

    public void setSignSourceProvider(QCloudSignSourceProvider cosXmlSignSourceProvider) {
        this.signSourceProvider = cosXmlSignSourceProvider;
    }

    public void setRegion(String region) {
        if (!TextUtils.isEmpty((CharSequence)region)) {
            this.region = region;
        }
    }

    public String getRegion() {
        return this.region;
    }

    public void setTask(HttpTask httpTask) {
        this.httpTask = httpTask;
    }

    public HttpTask getHttpTask() {
        return this.httpTask;
    }
}

