/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import android.content.Context;
import android.support.annotation.NonNull;
import com.tencent.cos.xml.CosXmlSimpleService;
import com.tencent.cos.xml.transfer.NetworkMonitor;
import com.tencent.cos.xml.transfer.TransferObserver;
import com.tencent.cos.xml.transfer.TransferRunnable;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.transfer.TransferStatusManager;
import com.tencent.cos.xml.transfer.UploadService;
import com.tencent.qcloud.core.logger.QCloudLogger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Deprecated
public class TransferUtility {
    static final String TRANSFER_UTILITY_TAG = "TransferUtility";
    static final int MB = 0x100000;
    static final int DEFAULT_UPLOAD_PART_SIZE = 0x200000;
    private Map<String, TransferRunnable> tasks;
    private final CosXmlSimpleService cosService;
    private final Context appContext;
    private static int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static final int KEEP_ALIVE_TIME = 1;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private NetworkMonitor networkMonitor;
    private ThreadPoolExecutor transferExecutor;
    private TransferStatusManager transferStatusManager;

    private TransferUtility(Context context, CosXmlSimpleService cosService) {
        this.appContext = context;
        this.cosService = cosService;
        this.tasks = new HashMap<String, TransferRunnable>();
        LinkedBlockingQueue<Runnable> transferQueue = new LinkedBlockingQueue<Runnable>();
        this.transferExecutor = new ThreadPoolExecutor(NUMBER_OF_CORES, NUMBER_OF_CORES, 1L, KEEP_ALIVE_TIME_UNIT, transferQueue);
        this.networkMonitor = new NetworkMonitor();
        this.networkMonitor.addNetworkListener(new NetworkMonitor.NetworkListener(){

            @Override
            public void onReconnect() {
                TransferUtility.this.onNetworkReconnect();
            }

            @Override
            public void onDisconnect() {
                TransferUtility.this.onNetworkDisconnect();
            }
        });
        this.networkMonitor.register(this.appContext);
        this.transferStatusManager = new TransferStatusManager(this);
    }

    private void onNetworkReconnect() {
        String[] taskIdArray = new String[this.tasks.size()];
        this.tasks.keySet().toArray(taskIdArray);
        for (int i = 0; i < taskIdArray.length; ++i) {
            if (this.transferStatusManager.getState(taskIdArray[i]) != TransferState.WAITING_FOR_NETWORK) continue;
            this.resume(taskIdArray[i]);
        }
    }

    private void onNetworkDisconnect() {
        String[] taskIdArray = new String[this.tasks.size()];
        this.tasks.keySet().toArray(taskIdArray);
        for (int i = 0; i < taskIdArray.length; ++i) {
            if (this.transferStatusManager.getState(taskIdArray[i]) != TransferState.IN_PROGRESS) continue;
            this.pause(this.tasks.get(taskIdArray[i]));
            this.transferStatusManager.updateState(taskIdArray[i], TransferState.WAITING_FOR_NETWORK);
        }
    }

    @Deprecated
    public TransferObserver upload(String bucket, String object, String srcPath) {
        UploadService.ResumeData resumeData = new UploadService.ResumeData();
        resumeData.sliceSize = 0x200000L;
        resumeData.srcPath = srcPath;
        resumeData.cosPath = object;
        resumeData.bucket = bucket;
        UploadService uploadService = new UploadService(this.cosService, resumeData);
        String taskId = this.getUUID();
        TransferRunnable transferRunnable = new TransferRunnable(uploadService, taskId, this.transferStatusManager);
        this.tasks.put(taskId, transferRunnable);
        QCloudLogger.i((String)TRANSFER_UTILITY_TAG, (String)("add upload task(" + taskId + ")."), (Object[])new Object[0]);
        this.transferStatusManager.updateState(taskId, TransferState.IN_PROGRESS);
        this.transferExecutor.execute(transferRunnable);
        return transferRunnable.getTransferObserver();
    }

    @Deprecated
    public boolean pause(String id) {
        TransferRunnable task = this.tasks.get(id);
        if (task == null) {
            QCloudLogger.w((String)TRANSFER_UTILITY_TAG, (String)("The task(" + id + ") you want to pause is not exist!"), (Object[])new Object[0]);
            return false;
        }
        QCloudLogger.i((String)TRANSFER_UTILITY_TAG, (String)("Pause the task(" + id + ")"), (Object[])new Object[0]);
        this.transferStatusManager.updateState(id, TransferState.PAUSED);
        return this.pause(task);
    }

    private boolean pause(@NonNull TransferRunnable task) {
        task.pause();
        return true;
    }

    @Deprecated
    public boolean resume(String id) {
        TransferRunnable task = this.tasks.get(id);
        if (task == null) {
            QCloudLogger.w((String)TRANSFER_UTILITY_TAG, (String)("The task(" + id + ") you want to resume is not exist!"), (Object[])new Object[0]);
            return false;
        }
        QCloudLogger.i((String)TRANSFER_UTILITY_TAG, (String)("Resume task(" + id + ")"), (Object[])new Object[0]);
        return this.resume(task);
    }

    private boolean resume(@NonNull TransferRunnable task) {
        this.transferStatusManager.updateState(task.getTransferObserver().getTransferId(), TransferState.IN_PROGRESS);
        this.transferExecutor.execute(task);
        return true;
    }

    @Deprecated
    public boolean cancel(String id) {
        TransferRunnable task = this.tasks.get(id);
        if (task == null) {
            QCloudLogger.w((String)TRANSFER_UTILITY_TAG, (String)("The task(" + id + ") you want to cancel is not exist!"), (Object[])new Object[0]);
            return false;
        }
        QCloudLogger.i((String)TRANSFER_UTILITY_TAG, (String)("Cancel the task(" + id + ")"), (Object[])new Object[0]);
        return this.cancel(task);
    }

    private boolean cancel(TransferRunnable task) {
        this.transferStatusManager.updateState(task.getTransferObserver().getTransferId(), TransferState.CANCELED);
        task.cancel();
        this.tasks.remove(task.getTransferObserver().getTransferId());
        return true;
    }

    @Deprecated
    public void cancelAll() {
        TransferRunnable[] taskArray = new TransferRunnable[this.tasks.size()];
        this.tasks.values().toArray(taskArray);
        for (int i = 0; i < taskArray.length; ++i) {
            this.cancel(taskArray[i]);
        }
    }

    @Deprecated
    public void release() {
        this.cancelAll();
        this.networkMonitor.unregister(this.appContext);
        this.transferExecutor.shutdown();
    }

    TransferRunnable getTransferRunnable(String id) {
        return this.tasks.get(id);
    }

    private String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    @Deprecated
    public static class Builder {
        private CosXmlSimpleService cosService;
        private Context appContext;

        public Builder cosService(CosXmlSimpleService cosXmlSimpleService) {
            this.cosService = cosXmlSimpleService;
            return this;
        }

        public Builder context(Context appContext) {
            this.appContext = appContext.getApplicationContext();
            return this;
        }

        public TransferUtility build() {
            return new TransferUtility(this.appContext, this.cosService);
        }
    }
}

