/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.CosXmlService;
import com.tencent.cos.xml.transfer.DownloadListener;
import com.tencent.cos.xml.transfer.DownloadTask;
import com.tencent.cos.xml.transfer.OnRemoveTaskListener;
import com.tencent.cos.xml.transfer.SliceUploadTask;
import com.tencent.cos.xml.transfer.Task;
import com.tencent.cos.xml.transfer.UploadListener;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class TransferManager {
    private CosXmlService cosXmlService;
    private OnRemoveTaskListener onRemoveTaskListenerImpl = new OnRemoveTaskListener(){

        @Override
        public void onRemove(int id) {
            TransferManager.this.remove(id);
        }
    };
    private Map<Integer, Task> taskMap;
    private Object SYNC_TASK = new Object();
    private int uploadTaskNum = 0;
    private int downloadTaskNum = 0;
    private int copyTaskNum = 0;

    public TransferManager(CosXmlService cosXmlService) {
        if (cosXmlService == null) {
            throw new RuntimeException("CosXmlService must not be null");
        }
        this.cosXmlService = cosXmlService;
        this.taskMap = new HashMap<Integer, Task>();
    }

    public int upload(String bucket, String cosPath, String srcPath, String uploadId, UploadListener uploadListener) {
        return this.upload(null, bucket, cosPath, srcPath, uploadId, uploadListener);
    }

    public int upload(String region, String bucket, String cosPath, String srcPath, String uploadId, UploadListener uploadListener) {
        SliceUploadTask sliceUploadTask = new SliceUploadTask(region, bucket, cosPath, srcPath, uploadId, uploadListener);
        int id = UUID.randomUUID().hashCode();
        sliceUploadTask.setTaskId(id);
        this.taskMap.put(id, sliceUploadTask);
        sliceUploadTask.setOnRemoveTaskListenter(this.onRemoveTaskListenerImpl);
        sliceUploadTask.upload(this.cosXmlService);
        return id;
    }

    public int download(String bucket, String cosPath, String localSaveDirPath, DownloadListener downloadListener) {
        return this.download(null, bucket, cosPath, localSaveDirPath, null, downloadListener);
    }

    public int download(String bucket, String cosPath, String localSaveDirPath, String localSaveFileName, DownloadListener downloadListener) {
        return this.download(null, bucket, cosPath, localSaveDirPath, localSaveFileName, downloadListener);
    }

    public int download(String region, String bucket, String cosPath, String localSaveDirPath, String localSaveFileName, DownloadListener downloadListener) {
        DownloadTask downloadTask = new DownloadTask(region, bucket, cosPath, localSaveDirPath, localSaveFileName, downloadListener);
        downloadTask.download();
        int id = UUID.randomUUID().hashCode();
        this.taskMap.put(id, downloadTask);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause(int id) {
        Object object = this.SYNC_TASK;
        synchronized (object) {
            Task task = this.taskMap.get(id);
            if (task != null) {
                task.pause(this.cosXmlService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int id) {
        Object object = this.SYNC_TASK;
        synchronized (object) {
            Task task = this.taskMap.get(id);
            if (task != null) {
                task.cancel(this.cosXmlService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(int id) {
        Object object = this.SYNC_TASK;
        synchronized (object) {
            Task task = this.taskMap.get(id);
            if (task != null) {
                task.resume(this.cosXmlService);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(int id) {
        Object object = this.SYNC_TASK;
        synchronized (object) {
            if (this.taskMap.containsKey(id)) {
                this.taskMap.remove(id);
            }
        }
    }
}

