/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.cos.xml.transfer.TransferRunnable;
import com.tencent.cos.xml.transfer.TransferState;
import com.tencent.cos.xml.transfer.TransferUtility;
import java.util.HashMap;
import java.util.Map;

public class TransferStatusManager {
    private Map<String, TransferState> transferStatus = new HashMap<String, TransferState>();
    private TransferUtility transferUtility;

    TransferStatusManager(TransferUtility transferUtility) {
        this.transferUtility = transferUtility;
    }

    void updateState(String id, TransferState newState) {
        this.transferStatus.put(id, newState);
        TransferRunnable transferRunnable = this.transferUtility.getTransferRunnable(id);
        if (transferRunnable != null) {
            transferRunnable.notifyTransferStateChange(newState);
            transferRunnable.getTransferObserver().setTransferState(newState);
        }
        if (newState == TransferState.CANCELED || newState == TransferState.COMPLETED) {
            this.removeState(id);
        }
    }

    void removeState(String id) {
        this.transferStatus.remove(id);
    }

    TransferState getState(String id) {
        return this.transferStatus.get(id);
    }
}

