/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.transfer;

import com.tencent.qcloud.core.common.QCloudProgressListener;
import com.tencent.qcloud.core.http.ProgressBody;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;

public class MultipartRequestBody
extends RequestBody
implements ProgressBody {
    private File file;
    private byte[] bytes;
    private long offset = -1L;
    private long contentLength = -1L;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private String name = "file";
    private String fileName;
    private String contentType;
    private QCloudProgressListener progressListener;
    private MultipartBody multipartBody;

    public void build() {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder.setType(MediaType.parse((String)"multipart/form-data"));
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            builder.addFormDataPart(entry.getKey(), entry.getValue());
        }
        builder.addFormDataPart(this.name, this.fileName, (RequestBody)new InnerRequestBody());
        this.multipartBody = builder.build();
    }

    public void setParameters(Map<String, String> parameters) {
        if (parameters != null) {
            this.parameters.putAll(parameters);
        }
    }

    public void setContent(String contentType, String name, String fileName, byte[] bytes, long offset, long counts) {
        this.contentType = contentType;
        if (name != null) {
            this.name = name;
        }
        this.fileName = fileName;
        this.bytes = bytes;
        this.setOffset(offset, counts);
    }

    public void setContent(String contentType, String name, String fileName, File file, long offset, long counts) {
        this.contentType = contentType;
        if (name != null) {
            this.name = name;
        }
        this.fileName = fileName;
        this.file = file;
        this.setOffset(offset, counts);
    }

    public void setContent(String contentType, String name, String fileName, File tmpFile, InputStream stream, long offset, long counts) throws IOException {
        this.contentType = contentType;
        if (name != null) {
            this.name = name;
        }
        this.fileName = fileName;
        this.setOffset(offset, counts);
        this.saveStreamToTmpFile(stream, tmpFile);
        this.file = tmpFile;
        this.offset = -1L;
        this.contentLength = -1L;
    }

    private void setOffset(long offset, long counts) {
        this.offset = offset;
        this.contentLength = counts;
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public long getBytesTransferred() {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveStreamToTmpFile(InputStream stream, File tmpFile) throws IOException {
        long bytesLimit;
        byte[] buffer;
        FileOutputStream fos;
        block4: {
            long skip;
            fos = null;
            fos = new FileOutputStream(tmpFile);
            buffer = new byte[8192];
            bytesLimit = this.contentLength < 0L ? Long.MAX_VALUE : this.contentLength;
            if (this.offset <= 0L || (skip = stream.skip(this.offset)) == this.offset) break block4;
            Util.closeQuietly((Closeable)fos);
            return;
        }
        try {
            int bytesRead;
            for (long bytesTotal = 0L; bytesTotal < bytesLimit && (bytesRead = stream.read(buffer, 0, (int)Math.min((long)buffer.length, bytesLimit - bytesTotal))) != -1; bytesTotal += (long)bytesRead) {
                fos.write(buffer, 0, bytesRead);
            }
            fos.flush();
        }
        catch (Throwable throwable) {
            Util.closeQuietly(fos);
            throw throwable;
        }
        Util.closeQuietly((Closeable)fos);
    }

    private long getContentRawLength() throws IOException {
        long rawLength = 0L;
        if (this.file != null) {
            rawLength = this.file.length();
        } else if (this.bytes != null) {
            rawLength = this.bytes.length;
        }
        if (this.offset < 0L) {
            this.offset = 0L;
        }
        if (this.contentLength < 0L) {
            this.contentLength = rawLength;
        }
        return rawLength > this.offset + this.contentLength ? this.contentLength : rawLength - this.offset;
    }

    public MediaType contentType() {
        return this.multipartBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.multipartBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        this.multipartBody.writeTo(sink);
    }

    private class InnerRequestBody
    extends RequestBody {
        private InnerRequestBody() {
        }

        public MediaType contentType() {
            if (MultipartRequestBody.this.contentType != null) {
                return MediaType.parse((String)MultipartRequestBody.this.contentType);
            }
            return null;
        }

        public long contentLength() throws IOException {
            return MultipartRequestBody.this.getContentRawLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeTo(BufferedSink sink) throws IOException {
            InputStream stream;
            block8: {
                long realSkip;
                stream = null;
                if (MultipartRequestBody.this.file != null) {
                    stream = new FileInputStream(MultipartRequestBody.this.file);
                } else if (MultipartRequestBody.this.bytes != null) {
                    stream = new ByteArrayInputStream(MultipartRequestBody.this.bytes);
                }
                if (MultipartRequestBody.this.offset <= 0L || (realSkip = stream.skip(MultipartRequestBody.this.offset)) == MultipartRequestBody.this.offset) break block8;
                Util.closeQuietly((Closeable)stream);
                return;
            }
            try {
                if (stream != null) {
                    int count;
                    long length = this.contentLength();
                    byte[] buffer = new byte[2048];
                    long hasWriteLength = 0L;
                    while ((count = stream.read(buffer, 0, buffer.length)) != -1) {
                        sink.write(buffer, 0, count);
                        MultipartRequestBody.this.progressListener.onProgress(hasWriteLength += (long)count, length);
                    }
                }
            }
            catch (Throwable throwable) {
                Util.closeQuietly(stream);
                throw throwable;
            }
            Util.closeQuietly((Closeable)stream);
        }
    }
}

