/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.modelmsg.WXMusicVipInfo;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.d;

public class WXMusicVideoObject
implements WXMediaMessage.IMediaObject {
    private static final String TAG = "MicroMsg.SDK.WXMusicVideoObject";
    private static final int URL_LENGTH_LIMIT = 10240;
    private static final int LYRIC_LENGTH_LIMIT = 32768;
    private static final int STRING_LIMIT = 1024;
    private static final int HD_ALBUM_FILE_LENGTH = 0xA00000;
    public String musicUrl;
    public String musicDataUrl;
    public String singerName;
    public String songLyric;
    public String hdAlbumThumbFilePath;
    public String hdAlbumThumbFileHash;
    public String albumName;
    public String musicGenre;
    public long issueDate;
    public String identification;
    public int duration;
    public String musicOperationUrl;
    public WXMusicVipInfo musicVipInfo;

    @Override
    public void serialize(Bundle bundle) {
        bundle.putString("_wxmusicvideoobject_musicUrl", this.musicUrl);
        bundle.putString("_wxmusicvideoobject_musicDataUrl", this.musicDataUrl);
        bundle.putString("_wxmusicvideoobject_singerName", this.singerName);
        bundle.putString("_wxmusicvideoobject_songLyric", this.songLyric);
        bundle.putString("_wxmusicvideoobject_hdAlbumThumbFilePath", this.hdAlbumThumbFilePath);
        bundle.putString("_wxmusicvideoobject_albumName", this.albumName);
        bundle.putString("_wxmusicvideoobject_musicGenre", this.musicGenre);
        bundle.putLong("_wxmusicvideoobject_issueDate", this.issueDate);
        bundle.putString("_wxmusicvideoobject_identification", this.identification);
        bundle.putInt("_wxmusicvideoobject_duration", this.duration);
        bundle.putString("_wxmusicvideoobject_musicOperationUrl", this.musicOperationUrl);
        if (this.musicVipInfo != null) {
            bundle.putString("_wxmusicvideoobject_musicVipInfo", this.musicVipInfo.getClass().getName());
            this.musicVipInfo.serialize(bundle);
        }
        bundle.putString("_wxmusicvideoobject_hdAlbumThumbFileHash", this.hdAlbumThumbFileHash);
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.musicUrl = bundle.getString("_wxmusicvideoobject_musicUrl");
        this.musicDataUrl = bundle.getString("_wxmusicvideoobject_musicDataUrl");
        this.singerName = bundle.getString("_wxmusicvideoobject_singerName");
        this.songLyric = bundle.getString("_wxmusicvideoobject_songLyric");
        this.hdAlbumThumbFilePath = bundle.getString("_wxmusicvideoobject_hdAlbumThumbFilePath");
        this.albumName = bundle.getString("_wxmusicvideoobject_albumName");
        this.musicGenre = bundle.getString("_wxmusicvideoobject_musicGenre");
        this.issueDate = bundle.getLong("_wxmusicvideoobject_issueDate", 0L);
        this.identification = bundle.getString("_wxmusicvideoobject_identification");
        this.duration = bundle.getInt("_wxmusicvideoobject_duration", 0);
        this.musicOperationUrl = bundle.getString("_wxmusicvideoobject_musicOperationUrl");
        String string = bundle.getString("_wxmusicvideoobject_musicVipInfo");
        try {
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                this.musicVipInfo = (WXMusicVipInfo)clazz.newInstance();
                this.musicVipInfo.unserialize(bundle);
            }
        }
        catch (Exception exception) {
            Log.e(TAG, "get WXSceneDataObject from bundle failed: unknown vipInfoObjectStr " + string + ", ex = " + exception.getMessage());
        }
        this.hdAlbumThumbFileHash = bundle.getString("_wxmusicvideoobject_hdAlbumThumbFileHash");
    }

    @Override
    public int type() {
        return 76;
    }

    @Override
    public boolean checkArgs() {
        if (d.b(this.musicUrl) || this.musicUrl.length() > 10240) {
            Log.e(TAG, "musicUrl.length exceeds the limit");
            return false;
        }
        if (d.b(this.musicDataUrl) || this.musicDataUrl.length() > 10240) {
            Log.e(TAG, "musicDataUrl.length exceeds the limit");
            return false;
        }
        if (d.b(this.singerName) || this.singerName.length() > 1024) {
            Log.e(TAG, "singerName.length exceeds the limit");
            return false;
        }
        if (!d.b(this.songLyric) && this.songLyric.length() > 32768) {
            Log.e(TAG, "songLyric.length exceeds the limit");
            return false;
        }
        if (!d.b(this.hdAlbumThumbFilePath) && this.hdAlbumThumbFilePath.length() > 1024) {
            Log.e(TAG, "hdAlbumThumbFilePath.length exceeds the limit");
            return false;
        }
        if (!d.b(this.hdAlbumThumbFilePath)) {
            WXMusicVideoObject wXMusicVideoObject = this;
            if (wXMusicVideoObject.getFileSize(wXMusicVideoObject.hdAlbumThumbFilePath) > 0xA00000) {
                Log.e(TAG, "hdAlbumThumbFilePath file length exceeds the limit");
                return false;
            }
        }
        if (!d.b(this.musicGenre) && this.musicGenre.length() > 1024) {
            Log.e(TAG, "musicGenre.length exceeds the limit");
            return false;
        }
        if (!d.b(this.identification) && this.identification.length() > 1024) {
            Log.e(TAG, "identification.length exceeds the limit");
            return false;
        }
        if (!d.b(this.musicOperationUrl) && this.musicOperationUrl.length() > 10240) {
            Log.e(TAG, "musicOperationUrl.length exceeds the limit");
            return false;
        }
        return true;
    }

    private int getFileSize(String string) {
        return d.getFileSize(string);
    }
}

