/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.a;

public final class SendAuth {
    private SendAuth() {
    }

    public static class Options {
        public static final int INVALID_FLAGS = -1;
        public String callbackClassName;
        public int callbackFlags = -1;

        public void toBundle(Bundle bundle) {
            bundle.putString("_wxapi_sendauth_options_callback_classname", this.callbackClassName);
            bundle.putInt("_wxapi_sendauth_options_callback_flags", this.callbackFlags);
        }

        public void fromBundle(Bundle bundle) {
            this.callbackClassName = a.b(bundle, "_wxapi_sendauth_options_callback_classname");
            this.callbackFlags = a.a(bundle, "_wxapi_sendauth_options_callback_flags");
        }
    }

    public static class Resp
    extends BaseResp {
        private static final String TAG = "MicroMsg.SDK.SendAuth.Resp";
        private static final int LENGTH_LIMIT = 1024;
        public static final int ERR_SCOPE_SNSAPI_WXAAPP_INFO_CAN_ONLY_AUTHORIZED_SEPARATELY = -1000;
        public String code;
        public String state;
        public boolean authResult = false;
        public String url;
        public String lang;
        public String country;

        public Resp() {
        }

        public Resp(Bundle bundle) {
            this.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
            this.code = bundle.getString("_wxapi_sendauth_resp_token");
            this.state = bundle.getString("_wxapi_sendauth_resp_state");
            this.url = bundle.getString("_wxapi_sendauth_resp_url");
            this.lang = bundle.getString("_wxapi_sendauth_resp_lang");
            this.country = bundle.getString("_wxapi_sendauth_resp_country");
            this.authResult = bundle.getBoolean("_wxapi_sendauth_resp_auth_result");
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            bundle.putString("_wxapi_sendauth_resp_token", this.code);
            bundle.putString("_wxapi_sendauth_resp_state", this.state);
            bundle.putString("_wxapi_sendauth_resp_url", this.url);
            bundle.putString("_wxapi_sendauth_resp_lang", this.lang);
            bundle.putString("_wxapi_sendauth_resp_country", this.country);
            bundle.putBoolean("_wxapi_sendauth_resp_auth_result", this.authResult);
        }

        @Override
        public boolean checkArgs() {
            if (this.state != null && this.state.length() > 1024) {
                Log.e(TAG, "checkArgs fail, state is invalid");
                return false;
            }
            return true;
        }
    }

    public static class Req
    extends BaseReq {
        private static final String TAG = "MicroMsg.SDK.SendAuth.Req";
        private static final int LENGTH_LIMIT = 1024;
        public String scope;
        public String state;
        public String extData;
        public Options options;
        public boolean isOption1;
        public boolean nonAutomatic = false;

        public Req() {
        }

        public Req(Bundle bundle) {
            this.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
            this.scope = bundle.getString("_wxapi_sendauth_req_scope");
            this.state = bundle.getString("_wxapi_sendauth_req_state");
            this.extData = bundle.getString("_wxapi_sendauth_req_ext_data");
            this.isOption1 = bundle.getBoolean("_wxapi_sendauth_req_isoption1");
            this.nonAutomatic = bundle.getBoolean("_wxapi_sendauth_req_non_automatic");
            this.options = new Options();
            this.options.fromBundle(bundle);
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            bundle.putString("_wxapi_sendauth_req_scope", this.scope);
            bundle.putString("_wxapi_sendauth_req_state", this.state);
            bundle.putString("_wxapi_sendauth_req_ext_data", this.extData);
            bundle.putBoolean("_wxapi_sendauth_req_isoption1", this.isOption1);
            bundle.putBoolean("_wxapi_sendauth_req_non_automatic", this.nonAutomatic);
            if (this.options != null) {
                this.options.toBundle(bundle);
            }
        }

        @Override
        public boolean checkArgs() {
            if (this.scope == null || this.scope.length() == 0 || this.scope.length() > 1024) {
                Log.e(TAG, "checkArgs fail, scope is invalid");
                return false;
            }
            if (this.state != null && this.state.length() > 1024) {
                Log.e(TAG, "checkArgs fail, state is invalid");
                return false;
            }
            return true;
        }
    }
}

