/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.openapi;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import com.tencent.mm.opensdk.channel.MMessageActV2;
import com.tencent.mm.opensdk.channel.a.a;
import com.tencent.mm.opensdk.channel.a.b;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelbiz.AddCardToWXCardPackage;
import com.tencent.mm.opensdk.modelbiz.ChooseCardFromWXCardPackage;
import com.tencent.mm.opensdk.modelbiz.CreateChatroom;
import com.tencent.mm.opensdk.modelbiz.HandleScanResult;
import com.tencent.mm.opensdk.modelbiz.JoinChatroom;
import com.tencent.mm.opensdk.modelbiz.OpenWebview;
import com.tencent.mm.opensdk.modelbiz.SubscribeMessage;
import com.tencent.mm.opensdk.modelbiz.SubscribeMiniProgramMsg;
import com.tencent.mm.opensdk.modelbiz.WXInvoiceAuthInsert;
import com.tencent.mm.opensdk.modelbiz.WXLaunchMiniProgram;
import com.tencent.mm.opensdk.modelbiz.WXNontaxPay;
import com.tencent.mm.opensdk.modelbiz.WXOpenBusinessView;
import com.tencent.mm.opensdk.modelbiz.WXOpenBusinessWebview;
import com.tencent.mm.opensdk.modelbiz.WXPayInsurance;
import com.tencent.mm.opensdk.modelmsg.GetMessageFromWX;
import com.tencent.mm.opensdk.modelmsg.LaunchFromWX;
import com.tencent.mm.opensdk.modelmsg.SendAuth;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.modelmsg.ShowMessageFromWX;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.modelmsg.WXMiniProgramObject;
import com.tencent.mm.opensdk.modelmsg.WXWebpageObject;
import com.tencent.mm.opensdk.modelpay.JumpToOfflinePay;
import com.tencent.mm.opensdk.modelpay.PayResp;
import com.tencent.mm.opensdk.openapi.IWXAPI;
import com.tencent.mm.opensdk.openapi.IWXAPIEventHandler;
import com.tencent.mm.opensdk.openapi.MMSharedPreferences;
import com.tencent.mm.opensdk.openapi.WXApiImplComm;
import com.tencent.mm.opensdk.utils.ILog;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.d;
import java.net.URLEncoder;
import org.json.JSONObject;

class BaseWXApiImplV10
implements IWXAPI {
    protected static final String TAG = "MicroMsg.SDK.WXApiImplV10";
    protected Context context;
    protected String appId;
    protected boolean checkSignature = false;
    protected boolean detached = false;
    private static String wxappPayEntryClassname = null;

    BaseWXApiImplV10(Context context, String string, boolean bl) {
        Log.d(TAG, "<init>, appId = " + string + ", checkSignature = " + bl);
        this.context = context;
        this.appId = string;
        this.checkSignature = bl;
    }

    @Override
    public boolean registerApp(String string) {
        return this.registerApp(string, 0L);
    }

    @Override
    public boolean registerApp(String object, long l2) {
        if (this.detached) {
            throw new IllegalStateException("registerApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e(TAG, "register app failed for wechat app signature check failed");
            return false;
        }
        Log.d(TAG, "registerApp, appId = " + (String)object);
        if (object != null) {
            this.appId = object;
        }
        Log.d(TAG, "registerApp, appId = " + (String)object);
        if (object != null) {
            this.appId = object;
        }
        Log.d(TAG, "register app " + this.context.getPackageName());
        object = new a.a();
        new a.a().W = "com.tencent.mm";
        ((a.a)object).action = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_REGISTER";
        ((a.a)object).content = "weixin://registerapp?appid=" + this.appId;
        ((a.a)object).X = l2;
        return a.a(this.context, (a.a)object);
    }

    @Override
    public void unregisterApp() {
        if (this.detached) {
            throw new IllegalStateException("unregisterApp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e(TAG, "unregister app failed for wechat app signature check failed");
            return;
        }
        Log.d(TAG, "unregisterApp, appId = " + this.appId);
        if (this.appId == null || this.appId.length() == 0) {
            Log.e(TAG, "unregisterApp fail, appId is empty");
            return;
        }
        Log.d(TAG, "unregister app " + this.context.getPackageName());
        a.a a2 = new a.a();
        new a.a().W = "com.tencent.mm";
        a2.action = "com.tencent.mm.plugin.openapi.Intent.ACTION_HANDLE_APP_UNREGISTER";
        a2.content = "weixin://unregisterapp?appid=" + this.appId;
        a.a(this.context, a2);
    }

    @Override
    public boolean handleIntent(Intent object, IWXAPIEventHandler iWXAPIEventHandler) {
        try {
            if (!WXApiImplComm.isIntentFromWx((Intent)object, "com.tencent.mm.openapi.token")) {
                Log.i(TAG, "handleIntent fail, intent not from weixin msg");
                return false;
            }
            if (this.detached) {
                throw new IllegalStateException("handleIntent fail, WXMsgImpl has been detached");
            }
            Object object2 = object.getStringExtra("_mmessage_content");
            int bl = object.getIntExtra("_mmessage_sdkVersion", 0);
            String string = object.getStringExtra("_mmessage_appPackage");
            if (string == null || string.length() == 0) {
                Log.e(TAG, "invalid argument");
                return false;
            }
            byte[] byArray = object.getByteArrayExtra("_mmessage_checksum");
            if (!this.checkSumConsistent(byArray, (byte[])(object2 = (Object)b.a((String)object2, bl, string)))) {
                Log.e(TAG, "checksum fail");
                return false;
            }
            int n2 = object.getIntExtra("_wxapi_command_type", 0);
            Log.i(TAG, "handleIntent, cmd = " + n2);
            switch (n2) {
                case 1: {
                    object = new SendAuth.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 2: {
                    object = new SendMessageToWX.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 3: {
                    object = new GetMessageFromWX.Req(object.getExtras());
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 4: {
                    object = new ShowMessageFromWX.Req(object.getExtras());
                    Object object3 = ((ShowMessageFromWX.Req)object).message.messageExt;
                    if (object3 != null && ((String)object3).contains("wx_internal_resptype")) {
                        boolean object4 = this.handleWxInternalRespType((String)object3, iWXAPIEventHandler);
                        Log.i(TAG, "handleIntent, extInfo contains wx_internal_resptype, ret = " + object4);
                        return object4;
                    }
                    if (object3 != null && ((String)object3).contains("openbusinesswebview")) {
                        try {
                            Uri exception = Uri.parse((String)object3);
                            if (exception != null && "openbusinesswebview".equals(exception.getHost())) {
                                object3 = new WXOpenBusinessWebview.Resp();
                                string = exception.getQueryParameter("ret");
                                if (string != null && string.length() > 0) {
                                    ((WXOpenBusinessWebview.Resp)object3).errCode = d.j(string);
                                }
                                ((WXOpenBusinessWebview.Resp)object3).resultInfo = exception.getQueryParameter("resultInfo");
                                ((WXOpenBusinessWebview.Resp)object3).errStr = exception.getQueryParameter("errmsg");
                                String string2 = exception.getQueryParameter("type");
                                if (string2 != null && string2.length() > 0) {
                                    ((WXOpenBusinessWebview.Resp)object3).businessType = d.j(string2);
                                }
                                iWXAPIEventHandler.onResp((BaseResp)object3);
                                return true;
                            }
                            Log.d(TAG, "not openbusinesswebview %" + (String)object3);
                        }
                        catch (Exception exception) {
                            Log.e(TAG, "parse fail, ex = " + exception.getMessage());
                        }
                    }
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 5: {
                    object = new PayResp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 6: {
                    object = new LaunchFromWX.Req(object.getExtras());
                    iWXAPIEventHandler.onReq((BaseReq)object);
                    return true;
                }
                case 9: {
                    object = new AddCardToWXCardPackage.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 16: {
                    object = new ChooseCardFromWXCardPackage.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 14: {
                    object = new CreateChatroom.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 15: {
                    object = new JoinChatroom.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 12: {
                    object = new OpenWebview.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 17: {
                    object = new HandleScanResult.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 19: {
                    object = new WXLaunchMiniProgram.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 26: {
                    object = new WXOpenBusinessView.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 24: {
                    object = new JumpToOfflinePay.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
                case 25: {
                    object = new WXOpenBusinessWebview.Resp(object.getExtras());
                    iWXAPIEventHandler.onResp((BaseResp)object);
                    return true;
                }
            }
            Log.e(TAG, "unknown cmd = " + n2);
        }
        catch (Exception exception) {
            Log.e(TAG, "handleIntent fail, ex = " + exception.getMessage());
        }
        return false;
    }

    private boolean handleWxInternalRespType(String string, IWXAPIEventHandler iWXAPIEventHandler) {
        Log.i(TAG, "handleWxInternalRespType, extInfo = " + string);
        try {
            string = Uri.parse((String)string);
            Object object = string.getQueryParameter("wx_internal_resptype");
            Log.i(TAG, "handleWxInternalRespType, respType = " + (String)object);
            if (d.i((String)object)) {
                Log.e(TAG, "handleWxInternalRespType fail, respType is null");
                return false;
            }
            if (((String)object).equals("subscribemessage")) {
                object = new SubscribeMessage.Resp();
                String string2 = string.getQueryParameter("ret");
                if (string2 != null && string2.length() > 0) {
                    ((SubscribeMessage.Resp)object).errCode = d.j(string2);
                }
                ((SubscribeMessage.Resp)object).openId = string.getQueryParameter("openid");
                ((SubscribeMessage.Resp)object).templateID = string.getQueryParameter("template_id");
                ((SubscribeMessage.Resp)object).scene = d.j(string.getQueryParameter("scene"));
                ((SubscribeMessage.Resp)object).action = string.getQueryParameter("action");
                ((SubscribeMessage.Resp)object).reserved = string.getQueryParameter("reserved");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            if (((String)object).contains("invoice_auth_insert")) {
                object = new WXInvoiceAuthInsert.Resp();
                String string3 = string.getQueryParameter("ret");
                if (string3 != null && string3.length() > 0) {
                    ((WXInvoiceAuthInsert.Resp)object).errCode = d.j(string3);
                }
                ((WXInvoiceAuthInsert.Resp)object).wxOrderId = string.getQueryParameter("wx_order_id");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            if (((String)object).contains("payinsurance")) {
                object = new WXPayInsurance.Resp();
                String string4 = string.getQueryParameter("ret");
                if (string4 != null && string4.length() > 0) {
                    ((WXPayInsurance.Resp)object).errCode = d.j(string4);
                }
                ((WXPayInsurance.Resp)object).wxOrderId = string.getQueryParameter("wx_order_id");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            if (((String)object).contains("nontaxpay")) {
                object = new WXNontaxPay.Resp();
                String string5 = string.getQueryParameter("ret");
                if (string5 != null && string5.length() > 0) {
                    ((WXNontaxPay.Resp)object).errCode = d.j(string5);
                }
                ((WXNontaxPay.Resp)object).wxOrderId = string.getQueryParameter("wx_order_id");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            if ("subscribeminiprogrammsg".equals(object) || "5".equals(object)) {
                object = new SubscribeMiniProgramMsg.Resp();
                String string6 = string.getQueryParameter("ret");
                if (string6 != null && string6.length() > 0) {
                    ((SubscribeMiniProgramMsg.Resp)object).errCode = d.j(string6);
                }
                ((SubscribeMiniProgramMsg.Resp)object).openId = string.getQueryParameter("openid");
                ((SubscribeMiniProgramMsg.Resp)object).unionId = string.getQueryParameter("unionid");
                ((SubscribeMiniProgramMsg.Resp)object).nickname = string.getQueryParameter("nickname");
                ((SubscribeMiniProgramMsg.Resp)object).errStr = string.getQueryParameter("errmsg");
                iWXAPIEventHandler.onResp((BaseResp)object);
                return true;
            }
            Log.e(TAG, "this open sdk version not support the request type");
        }
        catch (Exception exception) {
            Log.e(TAG, "handleWxInternalRespType fail, ex = " + exception.getMessage());
        }
        return false;
    }

    @Override
    public boolean isWXAppInstalled() {
        if (this.detached) {
            throw new IllegalStateException("isWXAppInstalled fail, WXMsgImpl has been detached");
        }
        try {
            PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo("com.tencent.mm", 64);
            if (packageInfo == null) {
                return false;
            }
            return WXApiImplComm.validateAppSignature(this.context, packageInfo.signatures, this.checkSignature);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @Override
    public int getWXAppSupportAPI() {
        if (this.detached) {
            throw new IllegalStateException("getWXAppSupportAPI fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            Log.e(TAG, "open wx app failed, not installed or signature check failed");
            return 0;
        }
        int n2 = new MMSharedPreferences(this.context).getInt("_build_info_sdk_int_", 0);
        if (n2 == 0) {
            try {
                n2 = this.context.getPackageManager().getApplicationInfo((String)"com.tencent.mm", (int)128).metaData.getInt("com.tencent.mm.BuildInfo.OPEN_SDK_VERSION", 0);
            }
            catch (Exception exception) {
                Log.e(TAG, "get from metaData failed : " + exception.getMessage());
            }
        }
        return n2;
    }

    @Override
    public boolean openWXApp() {
        if (this.detached) {
            throw new IllegalStateException("openWXApp fail, WXMsgImpl has been detached");
        }
        if (!this.isWXAppInstalled()) {
            Log.e(TAG, "open wx app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage("com.tencent.mm"));
        }
        catch (Exception exception) {
            Log.e(TAG, "startActivity fail, exception = " + exception.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean sendReq(BaseReq baseReq) {
        Object object;
        int n2;
        if (this.detached) {
            throw new IllegalStateException("sendReq fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e(TAG, "sendReq failed for wechat app signature check failed");
            return false;
        }
        if (!baseReq.checkArgs()) {
            Log.e(TAG, "sendReq checkArgs fail");
            return false;
        }
        Log.i(TAG, "sendReq, req type = " + baseReq.getType());
        Bundle bundle = new Bundle();
        baseReq.toBundle(bundle);
        if (baseReq.getType() == 5) {
            return this.sendPayReq(this.context, bundle);
        }
        if (baseReq.getType() == 7) {
            return this.sendJumpToBizProfileReq(this.context, bundle);
        }
        if (baseReq.getType() == 8) {
            return this.sendJumpToBizWebviewReq(this.context, bundle);
        }
        if (baseReq.getType() == 10) {
            return this.sendJumpToBizTempSessionReq(this.context, bundle);
        }
        if (baseReq.getType() == 9) {
            return this.sendAddCardToWX(this.context, bundle);
        }
        if (baseReq.getType() == 16) {
            return this.sendChooseCardFromWX(this.context, bundle);
        }
        if (baseReq.getType() == 11) {
            return this.sendOpenRankListReq(this.context, bundle);
        }
        if (baseReq.getType() == 12) {
            return this.sendOpenWebview(this.context, bundle);
        }
        if (baseReq.getType() == 25) {
            return this.sendOpenBusinessWebview(this.context, baseReq);
        }
        if (baseReq.getType() == 13) {
            return this.sendOpenBusiLuckyMoney(this.context, bundle);
        }
        if (baseReq.getType() == 14) {
            return this.createChatroom(this.context, bundle);
        }
        if (baseReq.getType() == 15) {
            return this.joinChatroom(this.context, bundle);
        }
        if (baseReq.getType() == 17) {
            return this.sendHandleScanResult(this.context, bundle);
        }
        if (baseReq.getType() == 18) {
            return this.sendSubscribeMessage(this.context, baseReq);
        }
        if (baseReq.getType() == 23) {
            return this.sendSubscribeMiniProgramMsg(this.context, baseReq);
        }
        if (baseReq.getType() == 19) {
            return this.sendLaunchWXMiniprogram(this.context, baseReq);
        }
        if (baseReq.getType() == 26) {
            return this.sendOpenBusinessView(this.context, baseReq);
        }
        if (baseReq.getType() == 20) {
            return this.sendInvoiceAuthInsert(this.context, baseReq);
        }
        if (baseReq.getType() == 21) {
            return this.sendNonTaxPay(this.context, baseReq);
        }
        if (baseReq.getType() == 22) {
            return this.sendPayInSurance(this.context, baseReq);
        }
        if (baseReq.getType() == 24) {
            return this.sendJumpToOfflinePayReq(this.context, bundle);
        }
        if (baseReq.getType() == 2 && d.c(n2 = bundle.getInt("_wxapi_sendmessagetowx_req_media_type"))) {
            WXMediaMessage.IMediaObject iMediaObject;
            object = (SendMessageToWX.Req)baseReq;
            if (this.getWXAppSupportAPI() < 620756993) {
                iMediaObject = new WXWebpageObject();
                new WXWebpageObject().webpageUrl = bundle.getString("_wxminiprogram_webpageurl");
                ((SendMessageToWX.Req)object).message.mediaObject = iMediaObject;
            } else if (n2 == 46 && this.getWXAppSupportAPI() < 620953856) {
                iMediaObject = new WXWebpageObject();
                new WXWebpageObject().webpageUrl = bundle.getString("_wxminiprogram_webpageurl");
                ((SendMessageToWX.Req)object).message.mediaObject = iMediaObject;
            } else {
                iMediaObject = (WXMiniProgramObject)((SendMessageToWX.Req)object).message.mediaObject;
                ((WXMiniProgramObject)iMediaObject).userName = ((WXMiniProgramObject)iMediaObject).userName + "@app";
                Object object2 = ((WXMiniProgramObject)iMediaObject).path;
                if (!d.i((String)((WXMiniProgramObject)iMediaObject).path)) {
                    object2 = ((String[])(object2 = object2.split("\\?"))).length > 1 ? object2[0] + ".html?" + object2[1] : object2[0] + ".html";
                    ((WXMiniProgramObject)iMediaObject).path = object2;
                }
            }
            if (((SendMessageToWX.Req)object).scene != 3) {
                ((SendMessageToWX.Req)object).scene = 0;
            }
            baseReq.toBundle(bundle);
        }
        String string = this.getTokenFromWX(this.context);
        object = new MMessageActV2.Args();
        new MMessageActV2.Args().bundle = bundle;
        ((MMessageActV2.Args)object).content = "weixin://sendreq?appid=" + this.appId;
        ((MMessageActV2.Args)object).targetPkgName = "com.tencent.mm";
        ((MMessageActV2.Args)object).targetClassName = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        ((MMessageActV2.Args)object).token = string;
        return MMessageActV2.send(this.context, (MMessageActV2.Args)object);
    }

    private String getTokenFromWX(Context context) {
        String[] stringArray;
        context = context.getContentResolver();
        Object object = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/genTokenForOpenSdk");
        if ((context = context.query(object, null, null, stringArray = new String[]{this.appId, "620953856"}, null)) != null && context.moveToFirst()) {
            object = context.getString(0);
            Log.i(TAG, "getTokenFromWX token is " + (String)object);
            context.close();
            return object;
        }
        return null;
    }

    private boolean sendPayReq(Context context, Bundle bundle) {
        if (wxappPayEntryClassname == null) {
            wxappPayEntryClassname = new MMSharedPreferences(context).getString("_wxapp_pay_entry_classname_", null);
            Log.d(TAG, "pay, set wxappPayEntryClassname = " + wxappPayEntryClassname);
            if (wxappPayEntryClassname == null) {
                try {
                    wxappPayEntryClassname = context.getPackageManager().getApplicationInfo((String)"com.tencent.mm", (int)128).metaData.getString("com.tencent.mm.BuildInfo.OPEN_SDK_PAY_ENTRY_CLASSNAME", null);
                }
                catch (Exception exception) {
                    Log.e(TAG, "get from metaData failed : " + exception.getMessage());
                }
            }
            if (wxappPayEntryClassname == null) {
                Log.e(TAG, "pay fail, wxappPayEntryClassname is null");
                return false;
            }
        }
        MMessageActV2.Args args = new MMessageActV2.Args();
        new MMessageActV2.Args().bundle = bundle;
        args.targetPkgName = "com.tencent.mm";
        args.targetClassName = wxappPayEntryClassname;
        return MMessageActV2.send(context, args);
    }

    private boolean sendJumpToBizProfileReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizProfile");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_profile_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_profile_req_ext_msg"), "" + stringArray.getInt("_wxapi_jump_to_biz_profile_req_scene"), "" + stringArray.getInt("_wxapi_jump_to_biz_profile_req_profile_type")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendJumpToBizWebviewReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizProfile");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_webview_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_webview_req_ext_msg"), "" + stringArray.getInt("_wxapi_jump_to_biz_webview_req_scene")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendJumpToBizTempSessionReq(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToBizTempSession");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_biz_webview_req_to_user_name"), stringArray.getString("_wxapi_jump_to_biz_webview_req_session_from"), "" + stringArray.getInt("_wxapi_jump_to_biz_webview_req_show_type")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendAddCardToWX(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/addCardToWX");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_add_card_to_wx_card_list"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendChooseCardFromWX(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/chooseCardFromWX");
        if ((context = context.query(uri, null, null, stringArray = new String[]{stringArray.getString("_wxapi_choose_card_from_wx_card_app_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_location_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_sign_type"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_sign"), stringArray.getString("_wxapi_choose_card_from_wx_card_time_stamp"), stringArray.getString("_wxapi_choose_card_from_wx_card_nonce_str"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_id"), stringArray.getString("_wxapi_choose_card_from_wx_card_card_type"), stringArray.getString("_wxapi_choose_card_from_wx_card_can_multi_select"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenRankListReq(Context context, Bundle bundle) {
        String[] stringArray;
        context = context.getContentResolver();
        bundle = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openRankList");
        if ((context = context.query((Uri)bundle, null, null, stringArray = new String[0], null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenWebview(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openWebview");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_jump_to_webview_url"), stringArray.getString("_wxapi_basereq_transaction")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenBusinessWebview(Context context, BaseReq stringArray) {
        stringArray = (WXOpenBusinessWebview.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openBusinessWebview");
        String string = "";
        if (stringArray.queryInfo != null && stringArray.queryInfo.size() > 0) {
            string = new JSONObject(stringArray.queryInfo).toString();
        }
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, "" + stringArray.businessType, string}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendJumpToOfflinePayReq(Context context, Bundle bundle) {
        context = context.getContentResolver();
        bundle = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/jumpToOfflinePay");
        String[] stringArray = new String[]{this.appId};
        if ((context = context.query((Uri)bundle, null, null, stringArray, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenBusiLuckyMoney(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openBusiLuckyMoney");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_open_busi_lucky_money_timeStamp"), stringArray.getString("_wxapi_open_busi_lucky_money_nonceStr"), stringArray.getString("_wxapi_open_busi_lucky_money_signType"), stringArray.getString("_wxapi_open_busi_lucky_money_signature"), stringArray.getString("_wxapi_open_busi_lucky_money_package")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean createChatroom(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/createChatroom");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_basereq_transaction", ""), stringArray.getString("_wxapi_create_chatroom_group_id", ""), stringArray.getString("_wxapi_create_chatroom_chatroom_name", ""), stringArray.getString("_wxapi_create_chatroom_chatroom_nickname", ""), stringArray.getString("_wxapi_create_chatroom_ext_msg", ""), stringArray.getString("_wxapi_basereq_openid", "")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean joinChatroom(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/joinChatroom");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_basereq_transaction", ""), stringArray.getString("_wxapi_join_chatroom_group_id", ""), stringArray.getString("_wxapi_join_chatroom_chatroom_nickname", ""), stringArray.getString("_wxapi_join_chatroom_ext_msg", ""), stringArray.getString("_wxapi_basereq_openid", "")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendHandleScanResult(Context context, Bundle stringArray) {
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/handleScanResult");
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, stringArray.getString("_wxapi_scan_qrcode_result")}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendSubscribeMessage(Context context, BaseReq stringArray) {
        stringArray = (SubscribeMessage.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = new String[]{this.appId, "1", String.valueOf(stringArray.scene), stringArray.templateID, stringArray.reserved};
        if ((context = context.query(uri, null, null, stringArray, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendSubscribeMiniProgramMsg(Context context, BaseReq stringArray) {
        stringArray = (SubscribeMiniProgramMsg.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = new String[]{this.appId, "5", stringArray.miniProgramAppId};
        if ((context = context.query(uri, null, null, stringArray, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendInvoiceAuthInsert(Context context, BaseReq stringArray) {
        stringArray = (WXInvoiceAuthInsert.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = URLEncoder.encode(String.format("url=%s", URLEncoder.encode(stringArray.url)));
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, "2", stringArray}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendNonTaxPay(Context context, BaseReq stringArray) {
        stringArray = (WXNontaxPay.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = URLEncoder.encode(String.format("url=%s", URLEncoder.encode(stringArray.url)));
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, "3", stringArray}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendPayInSurance(Context context, BaseReq stringArray) {
        stringArray = (WXPayInsurance.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openTypeWebview");
        stringArray = URLEncoder.encode(String.format("url=%s", URLEncoder.encode(stringArray.url)));
        if ((context = context.query(uri, null, null, stringArray = new String[]{this.appId, "4", stringArray}, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendLaunchWXMiniprogram(Context context, BaseReq stringArray) {
        stringArray = (WXLaunchMiniProgram.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/launchWXMiniprogram");
        stringArray = new String[]{this.appId, stringArray.userName, stringArray.path, "" + stringArray.miniprogramType, stringArray.extData};
        if ((context = context.query(uri, null, null, stringArray, null)) != null) {
            context.close();
        }
        return true;
    }

    private boolean sendOpenBusinessView(Context context, BaseReq stringArray) {
        stringArray = (WXOpenBusinessView.Req)stringArray;
        context = context.getContentResolver();
        Uri uri = Uri.parse((String)"content://com.tencent.mm.sdk.comm.provider/openBusinessView");
        stringArray = new String[]{this.appId, stringArray.businessType, stringArray.query, stringArray.extInfo};
        if ((context = context.query(uri, null, null, stringArray, null)) != null) {
            context.close();
        }
        return true;
    }

    @Override
    public boolean sendResp(BaseResp object) {
        if (this.detached) {
            throw new IllegalStateException("sendResp fail, WXMsgImpl has been detached");
        }
        if (!WXApiImplComm.validateAppSignatureForPackage(this.context, "com.tencent.mm", this.checkSignature)) {
            Log.e(TAG, "sendResp failed for wechat app signature check failed");
            return false;
        }
        if (!((BaseResp)object).checkArgs()) {
            Log.e(TAG, "sendResp checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        ((BaseResp)object).toBundle(bundle);
        object = new MMessageActV2.Args();
        new MMessageActV2.Args().bundle = bundle;
        ((MMessageActV2.Args)object).content = "weixin://sendresp?appid=" + this.appId;
        ((MMessageActV2.Args)object).targetPkgName = "com.tencent.mm";
        ((MMessageActV2.Args)object).targetClassName = "com.tencent.mm.plugin.base.stub.WXEntryActivity";
        return MMessageActV2.send(this.context, (MMessageActV2.Args)object);
    }

    @Override
    public void detach() {
        Log.d(TAG, "detach");
        this.detached = true;
        this.context = null;
    }

    @Override
    public void setLogImpl(ILog iLog) {
        Log.setLogImpl(iLog);
    }

    private boolean checkSumConsistent(byte[] byArray, byte[] byArray2) {
        if (byArray == null || byArray.length == 0 || byArray2 == null || byArray2.length == 0) {
            Log.e(TAG, "checkSumConsistent fail, invalid arguments");
            return false;
        }
        if (byArray.length != byArray2.length) {
            Log.e(TAG, "checkSumConsistent fail, length is different");
            return false;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] == byArray2[i2]) continue;
            return false;
        }
        return true;
    }
}

