/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.arscutil.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class LittleEndianOutputStream
extends OutputStream {
    private RandomAccessFile original;

    public LittleEndianOutputStream(String file) throws FileNotFoundException {
        this(new RandomAccessFile(file, "rw"));
    }

    public LittleEndianOutputStream(RandomAccessFile original) {
        this.original = original;
    }

    @Override
    public void write(int b) throws IOException {
        this.original.write(b);
    }

    public void writeShort(short data) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putShort(data);
        byteBuffer.flip();
        this.original.write(byteBuffer.array());
    }

    public void writeInt(int data) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(data);
        byteBuffer.flip();
        this.original.write(byteBuffer.array());
    }

    public void writeByte(byte data) throws IOException {
        this.original.write(data);
    }

    public void writeByte(byte[] buffer) throws IOException {
        this.original.write(buffer);
    }

    public void writeByte(byte[] buffer, int offset, int length) throws IOException {
        this.original.write(buffer, offset, length);
    }

    public void seek(long pos) throws IOException {
        this.original.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.original.getFilePointer();
    }

    public long getFileLength() throws IOException {
        return this.original.length();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.original.close();
    }
}

