/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.arscutil.data;

import com.tencent.mm.arscutil.data.ResChunk;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class ResStringBlock
extends ResChunk {
    private int stringCount;
    private int styleCount;
    private int flag;
    private int stringStart;
    private int styleStart;
    private List<Integer> stringOffsets;
    private List<Integer> styleOffsets;
    private List<ByteBuffer> strings;
    private byte[] styles;
    private Map<String, Integer> stringIndexMap;

    public int getStringCount() {
        return this.stringCount;
    }

    public void setStringCount(int stringCount) {
        this.stringCount = stringCount;
    }

    public int getStyleCount() {
        return this.styleCount;
    }

    public void setStyleCount(int styleCount) {
        this.styleCount = styleCount;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public int getStringStart() {
        return this.stringStart;
    }

    public void setStringStart(int stringStart) {
        this.stringStart = stringStart;
    }

    public int getStyleStart() {
        return this.styleStart;
    }

    public void setStyleStart(int styleStart) {
        this.styleStart = styleStart;
    }

    public List<Integer> getStringOffsets() {
        return this.stringOffsets;
    }

    public void setStringOffsets(List<Integer> stringOffsets) {
        this.stringOffsets = stringOffsets;
    }

    public Map<String, Integer> getStringIndexMap() {
        return this.stringIndexMap;
    }

    public void setStringIndexMap(Map<String, Integer> stringIndexMap) {
        this.stringIndexMap = stringIndexMap;
    }

    public List<Integer> getStyleOffsets() {
        return this.styleOffsets;
    }

    public void setStyleOffsets(List<Integer> styleOffsets) {
        this.styleOffsets = styleOffsets;
    }

    public List<ByteBuffer> getStrings() {
        return this.strings;
    }

    public void setStrings(List<ByteBuffer> strings) {
        this.strings = strings;
    }

    public byte[] getStyles() {
        return this.styles;
    }

    public void setStyles(byte[] styles) {
        this.styles = styles;
    }

    public Charset getCharSet() {
        if ((this.flag & 0x100) != 0) {
            return StandardCharsets.UTF_8;
        }
        return StandardCharsets.UTF_16LE;
    }

    public static String resolveStringPoolEntry(byte[] buffer, Charset charSet) {
        String str = "";
        int len = 0;
        if (charSet.equals(StandardCharsets.UTF_8)) {
            len = buffer[0];
            if ((len & 0x80) != 0) {
                byte high = buffer[1];
                len = (len & 0x7F) << 8 | high;
            }
            str = new String(buffer, 2, buffer.length - 2 - 1, charSet);
        } else {
            ByteBuffer byteBuffer = ByteBuffer.allocate(4);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.clear();
            byteBuffer.put(buffer, 0, 2);
            byteBuffer.flip();
            len = byteBuffer.getShort();
            if ((len & 0x8000) != 0) {
                short high = byteBuffer.getShort();
                len = (len & Short.MAX_VALUE) << 16 | high;
            }
            str = new String(buffer, byteBuffer.limit(), buffer.length - 4, charSet);
        }
        return str;
    }

    public static byte[] encodeStringPoolEntry(String str, Charset charSet) {
        ByteBuffer resultBuf;
        byte[] content = str.getBytes(charSet);
        int len = str.length();
        if (charSet.equals(StandardCharsets.UTF_8)) {
            resultBuf = ByteBuffer.allocate(content.length + 2 + 1);
            resultBuf.order(ByteOrder.LITTLE_ENDIAN);
            if (len > 255) {
                resultBuf.put((byte)((len & 0x7F00) >> 8 | 0x80));
                resultBuf.put((byte)(len & 0xFF));
            } else {
                resultBuf.put((byte)(len & 0xFF));
                resultBuf.put((byte)(len & 0xFF));
            }
        } else if (len > 65535) {
            resultBuf = ByteBuffer.allocate(content.length + 4 + 2);
            resultBuf.order(ByteOrder.LITTLE_ENDIAN);
            resultBuf.putShort((short)((len & 0x7FFF0000) >> 16 | 0x8000));
            resultBuf.putShort((short)(len & 0xFFFF));
        } else {
            resultBuf = ByteBuffer.allocate(content.length + 2 + 2);
            resultBuf.order(ByteOrder.LITTLE_ENDIAN);
            resultBuf.putShort((short)(len & 0xFFFF));
        }
        resultBuf.put(content);
        resultBuf.rewind();
        return resultBuf.array();
    }

    public void refresh() {
        int oldChunkSize = this.chunkSize;
        this.chunkSize = 0;
        this.chunkSize += this.headSize;
        this.chunkSize += this.stringCount * 4;
        this.chunkSize += this.styleCount * 4;
        if (this.strings != null) {
            int i;
            this.stringStart = this.headSize + this.styleCount * 4 + this.stringCount * 4;
            if (this.stringIndexMap != null) {
                this.stringIndexMap.clear();
                for (i = 0; i < this.stringCount; ++i) {
                    this.stringIndexMap.put(ResStringBlock.resolveStringPoolEntry(this.strings.get(i).array(), this.getCharSet()), i);
                }
            }
            this.stringOffsets.clear();
            if (this.stringCount > 0) {
                this.stringOffsets.add(0);
                for (i = 1; i < this.stringCount; ++i) {
                    this.stringOffsets.add(this.stringOffsets.get(i - 1) + this.strings.get(i - 1).limit());
                }
                if (this.styleCount > 0) {
                    this.styleStart = this.stringStart + this.stringOffsets.get(this.stringCount - 1) + this.strings.get(this.stringCount - 1).limit();
                }
                for (ByteBuffer buffer : this.strings) {
                    int strLen = buffer.limit();
                    this.chunkSize += strLen;
                }
            }
        }
        if (this.styles != null) {
            this.chunkSize += this.styles.length;
        }
        if (this.chunkSize % 4 != 0) {
            this.chunkPadding = 4 - this.chunkSize % 4;
            this.chunkSize += this.chunkPadding;
        } else {
            this.chunkPadding = 0;
        }
    }

    @Override
    public byte[] toBytes() {
        int i;
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.chunkSize);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.clear();
        byteBuffer.putShort(this.type);
        byteBuffer.putShort(this.headSize);
        byteBuffer.putInt(this.chunkSize);
        byteBuffer.putInt(this.stringCount);
        byteBuffer.putInt(this.styleCount);
        byteBuffer.putInt(this.flag);
        byteBuffer.putInt(this.stringStart);
        byteBuffer.putInt(this.styleStart);
        if (this.headPadding > 0) {
            byteBuffer.put(new byte[this.headPadding]);
        }
        if (this.stringOffsets != null) {
            for (i = 0; i < this.stringOffsets.size(); ++i) {
                byteBuffer.putInt(this.stringOffsets.get(i));
            }
        }
        if (this.styleOffsets != null) {
            for (i = 0; i < this.styleOffsets.size(); ++i) {
                byteBuffer.putInt(this.styleOffsets.get(i));
            }
        }
        if (this.strings != null) {
            for (i = 0; i < this.strings.size(); ++i) {
                byteBuffer.put(this.strings.get(i).array());
            }
        }
        if (this.styles != null) {
            byteBuffer.put(this.styles);
        }
        if (this.chunkPadding > 0) {
            byteBuffer.put(new byte[this.chunkPadding]);
        }
        byteBuffer.flip();
        return byteBuffer.array();
    }
}

