/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.arscutil.data;

import com.tencent.mm.arscutil.data.ResMapValue;
import com.tencent.mm.arscutil.data.ResValue;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class ResEntry {
    protected short size;
    protected short flag;
    protected int stringPoolIndex;
    protected String entryName;
    private ResValue resValue;
    private int parent;
    private int pairCount;
    private List<ResMapValue> resMapValues;

    public short getSize() {
        return this.size;
    }

    public void setSize(short size) {
        this.size = size;
    }

    public short getFlag() {
        return this.flag;
    }

    public void setFlag(short flag) {
        this.flag = flag;
    }

    public int getStringPoolIndex() {
        return this.stringPoolIndex;
    }

    public void setStringPoolIndex(int stringPoolIndex) {
        this.stringPoolIndex = stringPoolIndex;
    }

    public int getParent() {
        return this.parent;
    }

    public void setParent(int parent) {
        this.parent = parent;
    }

    public int getPairCount() {
        return this.pairCount;
    }

    public void setPairCount(int pairCount) {
        this.pairCount = pairCount;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public ResValue getResValue() {
        return this.resValue;
    }

    public void setResValue(ResValue resValue) {
        this.resValue = resValue;
    }

    public List<ResMapValue> getResMapValues() {
        return this.resMapValues;
    }

    public void setResMapValues(List<ResMapValue> resMapValues) {
        this.resMapValues = resMapValues;
    }

    public byte[] toBytes() {
        ByteBuffer headBuffer = ByteBuffer.allocate(this.size);
        headBuffer.order(ByteOrder.LITTLE_ENDIAN);
        headBuffer.clear();
        headBuffer.putShort(this.size);
        headBuffer.putShort(this.flag);
        headBuffer.putInt(this.stringPoolIndex);
        int totalSize = this.size;
        ArrayList<ByteBuffer> content = new ArrayList<ByteBuffer>();
        if ((this.flag & 1) == 0) {
            ByteBuffer value = ByteBuffer.wrap(this.resValue.toBytes());
            content.add(value);
        } else {
            headBuffer.putInt(this.parent);
            headBuffer.putInt(this.pairCount);
            if (this.pairCount > 0) {
                for (int i = 0; i < this.resMapValues.size(); ++i) {
                    ByteBuffer value = ByteBuffer.wrap(this.resMapValues.get(i).toBytes());
                    content.add(value);
                }
            }
        }
        for (ByteBuffer value : content) {
            totalSize += value.limit();
        }
        headBuffer.flip();
        ByteBuffer finalBuffer = ByteBuffer.allocate(totalSize);
        finalBuffer.order(ByteOrder.LITTLE_ENDIAN);
        finalBuffer.clear();
        finalBuffer.put(headBuffer.array());
        for (ByteBuffer value : content) {
            finalBuffer.put(value.array());
        }
        finalBuffer.flip();
        return finalBuffer.array();
    }
}

