/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import com.tencent.tencentmap.mapsdk.maps.TencentMapContext;
import com.tencent.tencentmap.mapsdk.maps.model.TileProvider;

public final class TileOverlayOptions {
    private TileProvider mTileProvider;
    private volatile String mDiskCacheDir;
    private volatile String mVersionInfo;
    private int mZIndex = 1;
    private boolean mBetterQuality = true;
    private int mMaxMemoryCacheSize;

    public final TileOverlayOptions tileProvider(TileProvider tileProvider) {
        this.mTileProvider = tileProvider;
        return this;
    }

    public final TileOverlayOptions diskCacheDir(String diskCacheDir) {
        this.mDiskCacheDir = diskCacheDir;
        return this;
    }

    public final TileOverlayOptions maxMemoryCacheSize(int maxMemoryCacheSize) {
        this.mMaxMemoryCacheSize = maxMemoryCacheSize;
        return this;
    }

    public final TileOverlayOptions versionInfo(String versionInfo) {
        this.mVersionInfo = versionInfo;
        return this;
    }

    public final TileOverlayOptions zIndex(int zindex) {
        this.mZIndex = zindex;
        return this;
    }

    public final TileOverlayOptions betterQuality(boolean betterQuality) {
        this.mBetterQuality = betterQuality;
        return this;
    }

    public final TileProvider getTileProvider() {
        return this.mTileProvider;
    }

    public final int getZIndex() {
        return this.mZIndex;
    }

    public final boolean isBetterQuality() {
        return this.mBetterQuality;
    }

    public final String getDiskCacheDir() {
        return this.mDiskCacheDir;
    }

    public final String getVersionInfo() {
        return this.mVersionInfo;
    }

    public final int getMaxMemoryCacheSize(TencentMapContext context) {
        if (this.mMaxMemoryCacheSize == 0) {
            return 4 * context.getScreenPixels();
        }
        return this.mMaxMemoryCacheSize;
    }

    public final String toString() {
        return "{mDiskCacheDir='" + this.mDiskCacheDir + '\'' + ", mVersionInfo='" + this.mVersionInfo + '\'' + ", mZIndex=" + this.mZIndex + ", mBetterQuality=" + this.mBetterQuality + ", mMaxMemoryCacheSize=" + this.mMaxMemoryCacheSize + '}';
    }
}

