/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net.adapter;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import com.tencent.map.tools.net.NetAdapter;
import com.tencent.map.tools.net.NetResponse;
import com.tencent.map.tools.net.http.HttpCanceler;
import java.util.HashMap;

public abstract class AbsNetImpl
implements NetAdapter {
    private static final String TAG = "NetImpl";
    protected Bundle mParams;

    public void setArguments(Bundle params) {
        this.mParams = params;
    }

    @Override
    public void initNet(Context context) {
        try {
            this.onCreateNet(context, this.mParams);
            return;
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)("initNet error:" + e2.toString()));
            return;
        }
    }

    @Override
    public NetResponse doGet(String url, String userAgent, int retryMethod, int timeOut, HashMap<String, String> mapHeaders, HttpCanceler canceler) {
        NetResponse netResponse;
        try {
            netResponse = this.onGetRequest(url, userAgent, retryMethod, timeOut, mapHeaders, canceler);
        }
        catch (Exception e2) {
            netResponse = new NetResponse(e2);
        }
        return netResponse;
    }

    @Override
    public NetResponse doPost(String url, String userAgent, byte[] postData, int retryMethod, int timeout, HashMap<String, String> mapHeaders, HttpCanceler canceler) {
        NetResponse netResponse;
        try {
            netResponse = this.onPostRequest(url, userAgent, postData, retryMethod, mapHeaders, canceler, timeout);
        }
        catch (Exception e2) {
            netResponse = new NetResponse(e2);
        }
        return netResponse;
    }

    @Override
    public NetResponse doPostNoBuffer(String url, String userAgent, byte[] postData) {
        NetResponse netResponse;
        try {
            netResponse = this.onPostNoBuffer(url, userAgent, postData);
        }
        catch (Exception e2) {
            netResponse = new NetResponse(e2);
        }
        return netResponse;
    }

    @Override
    public void doRangePost(String url, byte[] postData, String token, String nonce, String timeStamp, String start, HttpCanceler canceler) {
        try {
            this.onRangePost(url, postData, token, nonce, timeStamp, start, canceler);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    protected static String parseCharset(String contentType) {
        String codingType = "GBK";
        if (contentType != null) {
            for (String seg : contentType.split(";")) {
                if (!seg.contains("charset")) continue;
                String[] nv = seg.split("=");
                if (nv.length <= 1) break;
                codingType = nv[1].trim();
                break;
            }
        }
        return codingType;
    }

    protected abstract void onCreateNet(Context var1, Bundle var2);

    protected abstract NetResponse onGetRequest(String var1, String var2, int var3, int var4, HashMap<String, String> var5, HttpCanceler var6) throws Exception;

    protected abstract NetResponse onPostRequest(String var1, String var2, byte[] var3, int var4, HashMap<String, String> var5, HttpCanceler var6, int var7) throws Exception;

    protected abstract NetResponse onPostNoBuffer(String var1, String var2, byte[] var3) throws Exception;

    protected abstract void onRangePost(String var1, byte[] var2, String var3, String var4, String var5, String var6, HttpCanceler var7) throws Exception;
}

