/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net;

import android.content.Context;
import com.tencent.map.tools.net.NetAdapter;
import com.tencent.map.tools.net.NetResponse;
import com.tencent.map.tools.net.NetUtil;
import com.tencent.map.tools.net.http.HttpCanceler;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;

public class NetManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "NetManager";
    private NetAdapter mAdapter;
    private boolean mInited = false;
    private static NetManager sInstance;

    public static synchronized NetManager getInstance() {
        if (sInstance == null) {
            sInstance = new NetManager();
        }
        return sInstance;
    }

    private NetManager() {
    }

    public void setAdapter(Context context, NetAdapter adapter) {
        if (adapter == null) {
            return;
        }
        if (this.mAdapter != adapter) {
            this.mInited = false;
            this.mAdapter = adapter;
            this.init(context);
        }
    }

    private void init(Context context) {
        if (this.mInited || this.mAdapter == null) {
            return;
        }
        this.mAdapter.initNet(context.getApplicationContext());
        this.mInited = true;
    }

    public NetRequestBuilder builder() {
        return new NetRequestBuilder();
    }

    public NetResponse doGet(String url, String userAgent, int retryMethod, int timeOut, HashMap<String, String> mapHeaders, HttpCanceler canceler) {
        if (this.mAdapter == null) {
            return null;
        }
        return this.mAdapter.doGet(url, userAgent, retryMethod, timeOut, mapHeaders, canceler);
    }

    public NetResponse doPost(String url, String userAgent, byte[] postData, int retryMethod, int timeout, HashMap<String, String> mapHeaders, HttpCanceler canceler) {
        if (this.mAdapter == null) {
            return null;
        }
        return this.mAdapter.doPost(url, userAgent, postData, retryMethod, timeout, mapHeaders, canceler);
    }

    public NetResponse doPostNoBuffer(String url, String userAgent, byte[] postData) {
        if (this.mAdapter == null) {
            return null;
        }
        return this.mAdapter.doPostNoBuffer(url, userAgent, postData);
    }

    public void doRangePost(String url, byte[] postData, String token, String nonce, String timeStamp, String start, HttpCanceler canceler) {
        if (this.mAdapter != null) {
            this.mAdapter.doRangePost(url, postData, token, nonce, timeStamp, start, canceler);
        }
    }

    public class NetRequestBuilder {
        private String mUrl;
        private String mUserAgent = "QQ Map Mobile";
        private byte[] mPostData;
        private int mRetryNum = 1;
        private int mTimeout = 10000;
        private HashMap<String, String> mHeaders;
        private HttpCanceler mCanceler;
        private String mToken;
        private String mNonce;
        private String mTimestamp;
        private String mStartTag;
        private File mCacheFile;
        private long mRequestId = System.nanoTime();

        NetRequestBuilder() {
        }

        public NetRequestBuilder url(String url) {
            this.mUrl = url;
            return this;
        }

        public NetRequestBuilder userAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public NetRequestBuilder postData(byte[] postData) {
            this.mPostData = postData;
            return this;
        }

        public NetRequestBuilder retryNum(int retryNum) {
            this.mRetryNum = retryNum;
            return this;
        }

        public NetRequestBuilder timeOut(int timeout) {
            this.mTimeout = timeout;
            return this;
        }

        public NetRequestBuilder header(HashMap<String, String> headers) {
            this.mHeaders = headers;
            return this;
        }

        public NetRequestBuilder canceler(HttpCanceler canceler) {
            this.mCanceler = canceler;
            return this;
        }

        public NetRequestBuilder token(String token) {
            this.mToken = token;
            return this;
        }

        public NetRequestBuilder nonce(String nonce) {
            this.mNonce = nonce;
            return this;
        }

        public NetRequestBuilder timestamp(String timestamp) {
            this.mTimestamp = timestamp;
            return this;
        }

        public NetRequestBuilder startTag(String startTag) {
            this.mStartTag = startTag;
            return this;
        }

        public NetRequestBuilder file(File file) {
            this.mCacheFile = file;
            return this;
        }

        public NetResponse doPost() {
            this.onRequestStart("doPost", this);
            NetRequestBuilder netRequestBuilder = this;
            return netRequestBuilder.onRequestFinish(netRequestBuilder.NetManager.this.doPost(this.mUrl, this.mUserAgent, this.mPostData, this.mRetryNum, this.mTimeout, this.mHeaders, this.mCanceler));
        }

        public NetResponse doPostNoBuffer() {
            this.onRequestStart("doPostNoBuffer", this);
            NetRequestBuilder netRequestBuilder = this;
            return netRequestBuilder.onRequestFinish(netRequestBuilder.NetManager.this.doPostNoBuffer(this.mUrl, this.mUserAgent, this.mPostData));
        }

        public void doRangePost() {
            this.onRequestStart("doRangePost", this);
            NetManager.this.doRangePost(this.mUrl, this.mPostData, this.mToken, this.mNonce, this.mTimestamp, this.mStartTag, this.mCanceler);
        }

        public NetResponse doGet() {
            this.onRequestStart("doGet", this);
            NetRequestBuilder netRequestBuilder = this;
            return netRequestBuilder.onRequestFinish(netRequestBuilder.NetManager.this.doGet(this.mUrl, this.mUserAgent, this.mRetryNum, this.mTimeout, this.mHeaders, this.mCanceler));
        }

        private void onRequestStart(String method, NetRequestBuilder builder) {
        }

        private NetResponse onRequestFinish(NetResponse netResponse) {
            if (netResponse != null && this.mCacheFile != null) {
                FileOutputStream fos = null;
                try {
                    if (this.mCacheFile.isFile()) {
                        if (this.mCacheFile.exists()) {
                            this.mCacheFile.delete();
                        }
                        this.mCacheFile.getParentFile().mkdirs();
                        this.mCacheFile.createNewFile();
                    }
                    fos = new FileOutputStream(this.mCacheFile);
                    NetUtil.writeBytesWithoutClose(netResponse.data, fos);
                }
                catch (Exception e2) {
                    NetUtil.safeClose(fos);
                    netResponse = new NetResponse(e2);
                }
            }
            return netResponse;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("NetRequestBuilder{");
            sb.append("mUrl='").append(this.mUrl).append('\'');
            sb.append(", mUserAgent='").append(this.mUserAgent).append('\'');
            sb.append(", mPostData=");
            if (this.mPostData == null) {
                sb.append("null");
            } else {
                sb.append('[');
                for (int i2 = 0; i2 < this.mPostData.length; ++i2) {
                    sb.append(i2 == 0 ? "" : ", ").append(this.mPostData[i2]);
                }
                sb.append(']');
            }
            sb.append(", mRetryNum=").append(this.mRetryNum);
            sb.append(", mTimeout=").append(this.mTimeout);
            sb.append(", mHeaders=").append(this.mHeaders);
            sb.append(", mCanceler=").append(this.mCanceler);
            sb.append(", mToken='").append(this.mToken).append('\'');
            sb.append(", mNonce='").append(this.mNonce).append('\'');
            sb.append(", mTimestamp='").append(this.mTimestamp).append('\'');
            sb.append(", mStartTag='").append(this.mStartTag).append('\'');
            sb.append('}');
            return sb.toString();
        }

        public NetResponse downloadTo(File file) {
            this.onRequestStart("downloadTo[" + file + "]", this);
            return this.file(file).doGet();
        }
    }
}

