/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.lib.models;

import android.graphics.Point;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Keep;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;

@Keep
public class GeoPoint
implements Parcelable {
    private int mLatitudeE6;
    private int mLongitudeE6;
    public static final Parcelable.Creator<GeoPoint> CREATOR = new Parcelable.Creator<GeoPoint>(){

        public final /* synthetic */ Object createFromParcel(Parcel parcel) {
            Parcel parcel2 = parcel;
            return new GeoPoint(parcel2);
        }
    };

    public GeoPoint() {
        this.mLatitudeE6 = -85000001;
        this.mLongitudeE6 = -180000001;
    }

    public GeoPoint(GeoPoint geoPoint) {
        this();
        this.mLatitudeE6 = geoPoint.mLatitudeE6;
        this.mLongitudeE6 = geoPoint.mLongitudeE6;
    }

    public GeoPoint(int latitudeE6, int longitudeE6) {
        this.mLatitudeE6 = latitudeE6;
        this.mLongitudeE6 = longitudeE6;
    }

    public GeoPoint(LatLng latLng) {
        this.mLatitudeE6 = (int)(latLng.latitude * 1000000.0);
        this.mLongitudeE6 = (int)(latLng.longitude * 1000000.0);
    }

    public static GeoPoint from(LatLng latLng) {
        if (latLng == null) {
            return null;
        }
        return new GeoPoint(latLng);
    }

    public static List<GeoPoint> from(List<LatLng> latLngList) {
        if (latLngList == null || latLngList.isEmpty()) {
            return new ArrayList<GeoPoint>(0);
        }
        int size = latLngList.size();
        ArrayList<GeoPoint> geoPoints = new ArrayList<GeoPoint>(size);
        for (int i2 = 0; i2 < size; ++i2) {
            LatLng latlng = latLngList.get(i2);
            if (latlng == null) continue;
            GeoPoint geoPoint = GeoPoint.from(latlng);
            geoPoints.add(geoPoint);
        }
        return geoPoints;
    }

    public int getLatitudeE6() {
        return this.mLatitudeE6;
    }

    public int getLongitudeE6() {
        return this.mLongitudeE6;
    }

    public void setLatitudeE6(int latitudeE6) {
        this.mLatitudeE6 = latitudeE6;
    }

    public void setLongitudeE6(int longitudeE6) {
        this.mLongitudeE6 = longitudeE6;
    }

    public void setGeoPoint(GeoPoint geoPoint) {
        this.mLatitudeE6 = geoPoint.getLatitudeE6();
        this.mLongitudeE6 = geoPoint.getLongitudeE6();
    }

    public boolean equals(Object object) {
        if (object instanceof GeoPoint) {
            GeoPoint o2 = (GeoPoint)object;
            return this.mLatitudeE6 == o2.mLatitudeE6 && this.mLongitudeE6 == o2.mLongitudeE6;
        }
        return false;
    }

    public String toString() {
        return this.mLatitudeE6 + "," + this.mLongitudeE6;
    }

    public static GeoPoint formString(String string) {
        GeoPoint point = new GeoPoint();
        try {
            String[] strs;
            if (string != null && (strs = string.split(",")) != null && strs.length == 2) {
                point.mLatitudeE6 = Integer.parseInt(strs[0]);
                point.mLongitudeE6 = Integer.parseInt(strs[1]);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return point;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mLatitudeE6);
        out.writeInt(this.mLongitudeE6);
    }

    private GeoPoint(Parcel in) {
        this.mLatitudeE6 = in.readInt();
        this.mLongitudeE6 = in.readInt();
    }

    public LatLng toLatLng() {
        return new LatLng((double)this.mLatitudeE6 / 1000000.0, (double)this.mLongitudeE6 / 1000000.0);
    }

    public Point toPoint() {
        return new Point(this.getLongitudeE6(), this.getLatitudeE6());
    }
}

