/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.CoordTypeEnum;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;
import java.util.ArrayList;
import java.util.List;

public class TranslateParam
implements ParamObject {
    private static final String LOCATIONS = "locations";
    private static final String TYPES = "type";
    private List<LatLng> latLngs;
    private CoordType type = CoordType.STANDARD;

    public TranslateParam addLocation(LatLng latLng) {
        if (this.latLngs == null) {
            this.latLngs = new ArrayList<LatLng>();
        }
        this.latLngs.add(latLng);
        return this;
    }

    public TranslateParam locations(LatLng ... latLngs) {
        if (this.latLngs == null) {
            this.latLngs = new ArrayList<LatLng>();
        }
        for (int i2 = 0; i2 < latLngs.length; ++i2) {
            this.latLngs.add(latLngs[i2]);
        }
        return this;
    }

    public TranslateParam coordType(CoordType type) {
        this.type = type;
        return this;
    }

    public TranslateParam coord_type(CoordTypeEnum type) {
        this.coordType(type.coordType);
        return this;
    }

    @Override
    public boolean checkParams() {
        return this.latLngs != null;
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = new RequestParams();
        if (this.latLngs != null && this.latLngs.size() > 0) {
            StringBuilder locationStr = new StringBuilder();
            for (int i2 = 0; i2 < this.latLngs.size(); ++i2) {
                String l2 = "";
                if (i2 != 0) {
                    l2 = l2 + ";";
                }
                l2 = l2 + this.latLngs.get((int)i2).latitude + "," + this.latLngs.get((int)i2).longitude;
                locationStr.append(l2);
            }
            params.add(LOCATIONS, locationStr.toString());
        }
        params.add(TYPES, "" + this.type.ordinal());
        return params;
    }

    public static enum CoordType {
        NONE,
        GPS,
        SOGOU,
        BAIDU,
        MAPBAR,
        STANDARD,
        SOGOUMERCATOR;

    }
}

