/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tencentmap.mapsdk.maps.model;

import android.graphics.Bitmap;
import android.view.View;
import com.tencent.tencentmap.mapsdk.maps.TencentMapContext;
import com.tencent.tencentmap.mapsdk.maps.model.BitmapDescriptor;
import java.lang.ref.WeakReference;

public final class BitmapDescriptorFactory {
    public static final float HUE_RED = 0.0f;
    public static final float HUE_ORANGE = 30.0f;
    public static final float HUE_YELLOW = 60.0f;
    public static final float HUE_GREEN = 120.0f;
    public static final float HUE_CYAN = 180.0f;
    public static final float HUE_AZURE = 210.0f;
    public static final float HUE_BLUE = 240.0f;
    public static final float HUE_VIOLET = 270.0f;
    public static final float HUE_MAGENTA = 300.0f;
    public static final float HUE_ROSE = 330.0f;
    private static WeakReference<TencentMapContext> sTencentMapContextWeakReference;

    private BitmapDescriptorFactory() {
    }

    public static void attachMapContext(TencentMapContext mapContext) {
        sTencentMapContextWeakReference = new WeakReference<TencentMapContext>(mapContext);
    }

    public static BitmapDescriptor fromResource(int resId) {
        TencentMapContext context;
        if (sTencentMapContextWeakReference != null && (context = (TencentMapContext)sTencentMapContextWeakReference.get()) != null) {
            return BitmapDescriptorFactory.fromResource(context, resId);
        }
        return null;
    }

    public static BitmapDescriptor fromAsset(String assetName) {
        TencentMapContext context;
        if (sTencentMapContextWeakReference != null && (context = (TencentMapContext)sTencentMapContextWeakReference.get()) != null) {
            return BitmapDescriptorFactory.fromAsset(context, assetName);
        }
        return null;
    }

    public static BitmapDescriptor fromFile(String filename) {
        TencentMapContext context;
        if (sTencentMapContextWeakReference != null && (context = (TencentMapContext)sTencentMapContextWeakReference.get()) != null) {
            return BitmapDescriptorFactory.fromFile(context, filename);
        }
        return null;
    }

    public static BitmapDescriptor fromPath(String filename) {
        TencentMapContext context;
        if (sTencentMapContextWeakReference != null && (context = (TencentMapContext)sTencentMapContextWeakReference.get()) != null) {
            return BitmapDescriptorFactory.fromPath(context, filename);
        }
        return null;
    }

    public static BitmapDescriptor fromBitmap(Bitmap bitmap) {
        TencentMapContext context;
        if (sTencentMapContextWeakReference != null && (context = (TencentMapContext)sTencentMapContextWeakReference.get()) != null) {
            return BitmapDescriptorFactory.fromBitmap(context, bitmap);
        }
        return null;
    }

    public static BitmapDescriptor fromView(View view) {
        TencentMapContext context;
        if (sTencentMapContextWeakReference != null && (context = (TencentMapContext)sTencentMapContextWeakReference.get()) != null) {
            return BitmapDescriptorFactory.fromView(context, view);
        }
        return null;
    }

    public static BitmapDescriptor defaultMarker() {
        TencentMapContext context;
        if (sTencentMapContextWeakReference != null && (context = (TencentMapContext)sTencentMapContextWeakReference.get()) != null) {
            return BitmapDescriptorFactory.defaultMarker(context);
        }
        return null;
    }

    public static BitmapDescriptor defaultMarker(float color) {
        TencentMapContext context;
        if (sTencentMapContextWeakReference != null && (context = (TencentMapContext)sTencentMapContextWeakReference.get()) != null) {
            return BitmapDescriptorFactory.defaultMarker(context, color);
        }
        return null;
    }

    public static BitmapDescriptor fromResource(TencentMapContext context, int resId) {
        return context.createBitmapDescriptor(resId, 1);
    }

    public static BitmapDescriptor fromAsset(TencentMapContext context, String assetName) {
        return context.createBitmapDescriptor(assetName, 2);
    }

    public static BitmapDescriptor fromFile(TencentMapContext context, String filename) {
        return context.createBitmapDescriptor(filename, 3);
    }

    public static BitmapDescriptor fromPath(TencentMapContext context, String filename) {
        return context.createBitmapDescriptor(filename, 4);
    }

    public static BitmapDescriptor defaultMarker(TencentMapContext context) {
        return context.createBitmapDescriptor(5);
    }

    public static BitmapDescriptor defaultMarker(TencentMapContext context, float color) {
        return context.createBitmapDescriptor(color, 6);
    }

    public static BitmapDescriptor fromBitmap(TencentMapContext context, Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap mapNew = BitmapDescriptorFactory.createBitmapFromBitmap(bitmap);
        return context.createBitmapDescriptor(mapNew, 7);
    }

    private static Bitmap createBitmapFromBitmap(Bitmap map) {
        Bitmap bmp = null;
        try {
            bmp = Bitmap.createBitmap((Bitmap)map);
        }
        catch (OutOfMemoryError outOfMemoryError) {}
        return bmp;
    }

    public static BitmapDescriptor fromView(TencentMapContext context, View view) {
        if (view == null) {
            return null;
        }
        try {
            view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            view.buildDrawingCache();
            Bitmap bitmap = view.getDrawingCache();
            BitmapDescriptor result = BitmapDescriptorFactory.fromBitmap(context, bitmap);
            if (bitmap != null) {
                bitmap.recycle();
            }
            view.destroyDrawingCache();
            return result;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

