/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.sheet;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.tencent.map.tools.Callback;
import com.tencent.map.tools.Util;
import com.tencent.map.tools.internal.c;
import com.tencent.map.tools.internal.d;
import com.tencent.map.tools.internal.e;
import com.tencent.map.tools.sheet.listener.ModuleUncaughtListener;
import java.io.File;

public class SheetManager
implements d {
    private static final SheetManager ourInstance = new SheetManager();
    private c mSheetAdapter;
    private d mSheetProxy;
    private boolean mPluginExists;

    public static SheetManager getInstance() {
        return ourInstance;
    }

    private SheetManager() {
    }

    public void initAsync(final Context context, final @NonNull Options options, final Callback<Void> callback) {
        final Handler mainHandler = new Handler(Looper.getMainLooper());
        new Thread(new Runnable(){

            @Override
            public final void run() {
                SheetManager.this.init(context, options);
                mainHandler.post(new Runnable(){

                    @Override
                    public final void run() {
                        if (callback != null) {
                            callback.callback(null);
                        }
                    }
                });
            }
        }, "tencentmap-sheetinit").start();
    }

    public void init(Context context, @NonNull Options options) {
        switch (options.mAdapterType) {
            case LOC_SHEET: {
                this.mSheetAdapter = new e(context, options);
            }
        }
        if (this.mSheetAdapter.a()) {
            this.mSheetProxy = this.mSheetAdapter.c();
            this.mPluginExists = this.mSheetProxy.getSheetLoader() != null;
        }
    }

    @Override
    public Class findSheet(String clazzPath) {
        if (this.mPluginExists) {
            return this.mSheetProxy.findSheet(clazzPath);
        }
        return Util.findClass(clazzPath, this.getSheetLoader());
    }

    @Override
    public <T> Class<? extends T> findSheet(String classPath, Class<T> parentClz) {
        if (this.mPluginExists) {
            return this.mSheetProxy.findSheet(classPath, parentClz);
        }
        return Util.findClass(classPath, parentClz, this.getSheetLoader());
    }

    @Override
    public Object newSheetIns(String clazzPath) {
        if (this.mPluginExists) {
            return this.mSheetProxy.newSheetIns(clazzPath);
        }
        return Util.newInstance(this.findSheet(clazzPath), new Object[0]);
    }

    @Override
    public <T> T newSheetIns(Class<T> clz, Object ... params) {
        if (this.mPluginExists) {
            return this.mSheetProxy.newSheetIns(clz, params);
        }
        return Util.newInstance(clz, params);
    }

    @Override
    public ClassLoader getSheetLoader() {
        if (this.mPluginExists) {
            return this.mSheetProxy.getSheetLoader();
        }
        return this.getClass().getClassLoader();
    }

    @Override
    public Object callSheetMth(Object obj, String method, Object ... params) {
        if (this.mPluginExists) {
            return this.mSheetProxy.callSheetMth(obj, method, params);
        }
        return Util.invokeMethod(obj, method, params);
    }

    @Override
    public Object callSheetMth(Object obj, String method, Class[] classes, Object[] params) {
        if (this.mPluginExists) {
            return this.mSheetProxy.callSheetMth(obj, method, classes, params);
        }
        return Util.invokeMethod(obj, method, classes, params);
    }

    @Override
    public Object callSheetStaMth(Class clz, String method, Class[] classes, Object[] params) {
        if (this.mPluginExists) {
            return this.mSheetProxy.callSheetStaMth(clz, method, classes, params);
        }
        return Util.invokeStaticMethod(clz, method, classes, params);
    }

    @Override
    public int loadSheetGroups() {
        if (this.mPluginExists) {
            return this.mSheetProxy.loadSheetGroups();
        }
        return 0;
    }

    public File getLogDir() {
        if (this.mSheetAdapter != null) {
            return this.mSheetAdapter.b();
        }
        return null;
    }

    public static class Options {
        private boolean mIsSheetEnable;
        private AdapterType mAdapterType = AdapterType.LOC_SHEET;
        private String mSoLibName;
        private String mPluginName;
        private String mPluginUpdateUrl;
        private String mSdkVersion;
        private String mSdkVersionCode;
        private String mSdkMapKey;
        private String mSdkFlavor;
        private boolean mIsCoreLogOn;
        private String mCoreLogReportUrl;
        private String mCoreLogToken;
        private File mCoreLogDir;
        private UncaughtListener mUncaughtListener;

        public UncaughtListener getUncaughtListener() {
            return this.mUncaughtListener;
        }

        public Options setUncaughtListener(UncaughtListener uncaughtListener) {
            this.mUncaughtListener = uncaughtListener;
            return this;
        }

        public AdapterType getAdapterType() {
            return this.mAdapterType;
        }

        public Options setAdapterType(AdapterType adapterType) {
            this.mAdapterType = adapterType;
            return this;
        }

        public String getPluginName() {
            return this.mPluginName;
        }

        public Options setSheetProjectName(String pluginName) {
            this.mPluginName = pluginName;
            return this;
        }

        public String getPluginUpdateUrl() {
            return this.mPluginUpdateUrl;
        }

        public Options setPluginUpdateUrl(String pluginUpdateUrl) {
            this.mPluginUpdateUrl = pluginUpdateUrl;
            return this;
        }

        public String getSdkVersion() {
            return this.mSdkVersion;
        }

        public Options setVersion(String sdkVersion) {
            this.mSdkVersion = sdkVersion;
            return this;
        }

        public String getSdkVersionCode() {
            return this.mSdkVersionCode;
        }

        public Options setVersionCode(String sdkVersionCode) {
            this.mSdkVersionCode = sdkVersionCode;
            return this;
        }

        public String getSdkFlavor() {
            return this.mSdkFlavor;
        }

        public Options setFlavor(String sdkFlavor) {
            this.mSdkFlavor = sdkFlavor;
            return this;
        }

        public String getSdkMapKey() {
            return this.mSdkMapKey;
        }

        public Options setAppKey(String sdkMapKey) {
            this.mSdkMapKey = sdkMapKey;
            return this;
        }

        public boolean isCoreLogOn() {
            return this.mIsCoreLogOn;
        }

        public Options setCoreLogOn(boolean coreLogOn) {
            this.mIsCoreLogOn = coreLogOn;
            return this;
        }

        public Options setSheetEnable(boolean enable) {
            this.mIsSheetEnable = enable;
            return this;
        }

        public boolean isSheetEnable() {
            return this.mIsSheetEnable;
        }

        public String getCoreLogReportUrl() {
            return this.mCoreLogReportUrl;
        }

        public Options setCoreLogReportUrl(String coreLogReportUrl) {
            this.mCoreLogReportUrl = coreLogReportUrl;
            return this;
        }

        public String getCoreLogToken() {
            return this.mCoreLogToken;
        }

        public Options setCoreLogToken(String coreLogToken) {
            this.mCoreLogToken = coreLogToken;
            return this;
        }

        public File getCoreLogDir() {
            return this.mCoreLogDir;
        }

        public void setCoreLogDir(File coreLogDir) {
            this.mCoreLogDir = coreLogDir;
        }

        public String getSoLibName() {
            return this.mSoLibName;
        }

        public Options setSoLibName(String soLibName) {
            this.mSoLibName = soLibName;
            return this;
        }

        public static enum AdapterType {
            LOC_SHEET;

        }
    }

    public static abstract class UncaughtListener
    extends ModuleUncaughtListener {
        public UncaughtListener(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            super(uncaughtExceptionHandler);
        }
    }
}

