/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.map.tools.net;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.text.TextUtils;

@SuppressLint(value={"MissingPermission"})
public class NetUtil {
    public static final int TYPE_NET_WORK_DISABLED = 0;
    public static final int TYPE_CMWAP = 1;
    public static final int TYPE_UNIWAP = 2;
    public static final int TYPE_3GWAP = 3;
    public static final int TYPE_CTWAP = 4;
    public static final int TYPE_WIFI = 5;
    public static final int TYPE_OTHER_NET = 6;
    public static final String MAP_USER_AGENT = "QQ Map Mobile";
    public static final String STR_UserAgent = "androidsdk";
    public static final int DEFAULT_TIME_OUT = 10000;
    private static final String WIFI = "wifi";
    private static final String CTWAP = "ctwap";
    private static final String CMWAP = "cmwap";
    private static final String WAP_3G = "3gwap";
    private static final String NET_3G = "3gnet";
    private static final String UNIWAP = "uniwap";

    public static NetworkInfo getNetworkInfo(Context ctx) {
        try {
            return ((ConnectivityManager)ctx.getSystemService("connectivity")).getActiveNetworkInfo();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static int getNetType(Context ctx) {
        return NetUtil.getNetType(NetUtil.getNetworkInfo(ctx));
    }

    public static String getNetTypeStr(Context ctx) {
        int netType = NetUtil.getNetType(ctx);
        String netTypeStr = "";
        switch (netType) {
            case 5: {
                netTypeStr = WIFI;
                break;
            }
            case 3: {
                netTypeStr = WAP_3G;
                break;
            }
            case 2: {
                netTypeStr = UNIWAP;
                break;
            }
            case 1: {
                netTypeStr = CMWAP;
                break;
            }
            case 4: {
                netTypeStr = CTWAP;
            }
        }
        return netTypeStr;
    }

    private static int getNetType(NetworkInfo mobNetInfoActivity) {
        if (mobNetInfoActivity == null || !mobNetInfoActivity.isAvailable()) {
            return 0;
        }
        int netType = mobNetInfoActivity.getType();
        if (netType == 1) {
            return 5;
        }
        if (netType != 0) {
            return 6;
        }
        String netMode = mobNetInfoActivity.getExtraInfo();
        if (TextUtils.isEmpty((CharSequence)netMode)) {
            return 6;
        }
        if (netMode.equalsIgnoreCase(CMWAP)) {
            return 1;
        }
        if (netMode.equalsIgnoreCase(WAP_3G)) {
            return 3;
        }
        if (netMode.equalsIgnoreCase(UNIWAP)) {
            return 2;
        }
        if (netMode.equalsIgnoreCase(CTWAP)) {
            return 4;
        }
        return 3;
    }

    public static String getNetworkType(Context ctx) {
        try {
            NetworkInfo networkInfo = ((ConnectivityManager)ctx.getSystemService("connectivity")).getActiveNetworkInfo();
            if (networkInfo != null) {
                int type = networkInfo.getType();
                if (type == 1) {
                    return WIFI;
                }
                if (type == 0) {
                    switch (networkInfo.getSubtype()) {
                        case 4: {
                            return "2g";
                        }
                        case 2: {
                            return "2g";
                        }
                        case 5: {
                            return "3g";
                        }
                        case 6: {
                            return "3g";
                        }
                        case 1: {
                            return "2g";
                        }
                        case 8: {
                            return "3g";
                        }
                        case 3: {
                            return "3g";
                        }
                    }
                    return "other";
                }
                return "other";
            }
            return "unknown";
        }
        catch (Exception exception) {
            return "unknown";
        }
    }

    public static boolean isNetAvailable(Context ctx) {
        try {
            ConnectivityManager manager = (ConnectivityManager)ctx.getSystemService("connectivity");
            NetworkInfo active = NetUtil.getNetworkInfo(ctx);
            if (active != null) {
                return active.isAvailable();
            }
            for (NetworkInfo info : manager.getAllNetworkInfo()) {
                if (!info.isAvailable() || !info.isConnectedOrConnecting()) continue;
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public static boolean isWifi(Context ctx) {
        return NetUtil.getNetType(ctx) == 5;
    }

    public static boolean isMobile(Context ctx) {
        int netType = NetUtil.getNetType(ctx);
        return netType != 0 && netType != 5;
    }
}

