/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.lbssearch.object.param;

import android.text.TextUtils;
import com.tencent.lbssearch.object.RequestParams;
import com.tencent.lbssearch.object.param.ParamObject;
import com.tencent.map.tools.Util;
import com.tencent.tencentmap.mapsdk.maps.model.LatLng;

public class SuggestionParam
implements ParamObject {
    private static final String KEYWORD = "keyword";
    private static final String REGION = "region";
    private static final String FILTER = "filter";
    private String keyword;
    private String region;
    private int regionFix;
    private LatLng location;
    private int isGetSubPois;
    private int policy;
    private String filter;
    private String addressFormat;
    private int pageIndex;
    private int pageSize;

    public SuggestionParam() {
    }

    public SuggestionParam(String keyword, String region) {
        this.keyword = keyword;
        this.region = region;
    }

    public SuggestionParam keyword(String keyword) {
        this.keyword = keyword;
        return this;
    }

    public SuggestionParam region(String region) {
        this.region = region;
        return this;
    }

    public SuggestionParam filter(String ... values) {
        this.filter = Util.filterBuilder(values);
        return this;
    }

    public SuggestionParam regionFix(boolean enable) {
        this.regionFix = enable ? 1 : 0;
        return this;
    }

    public SuggestionParam location(LatLng location) {
        this.location = location;
        return this;
    }

    public SuggestionParam getSubPois(boolean enable) {
        this.isGetSubPois = enable ? 1 : 0;
        return this;
    }

    public SuggestionParam addressFormat(AddressFormat format) {
        this.addressFormat = format.value;
        return this;
    }

    public SuggestionParam policy(Policy policy) {
        this.policy = policy.value;
        return this;
    }

    public SuggestionParam pageIndex(int page_index) {
        this.pageIndex = page_index;
        return this;
    }

    public SuggestionParam pageSize(int pagesize) {
        this.pageSize = pagesize;
        return this;
    }

    @Override
    public boolean checkParams() {
        return !TextUtils.isEmpty((CharSequence)this.keyword) && !TextUtils.isEmpty((CharSequence)this.region);
    }

    @Override
    public RequestParams buildParameters() {
        RequestParams params = new RequestParams();
        if (!TextUtils.isEmpty((CharSequence)this.keyword)) {
            params.add(KEYWORD, this.keyword);
        }
        if (!TextUtils.isEmpty((CharSequence)this.region)) {
            params.add(REGION, this.region);
        }
        if (!TextUtils.isEmpty((CharSequence)this.filter)) {
            params.add(FILTER, this.filter);
        }
        params.add("region_fix", "" + this.regionFix);
        if (this.location != null) {
            params.add("location", this.location.latitude + "," + this.location.longitude);
        }
        params.add("get_subpois", "" + this.isGetSubPois);
        params.add("policy", "" + this.policy);
        if (!TextUtils.isEmpty((CharSequence)this.addressFormat)) {
            params.add("address_format", this.addressFormat);
        }
        if (this.pageIndex > 0 && this.pageIndex <= 20 && this.pageSize > 0 && this.pageSize <= 20) {
            params.add("page_index", "" + this.pageIndex);
            params.add("page_size", "" + this.pageSize);
        }
        return params;
    }

    public static enum AddressFormat {
        SHORT("short");

        public String value;

        private AddressFormat(String value) {
            this.value = value;
        }
    }

    public static enum Policy {
        DEF(0),
        O2O(1),
        TRIP_START(10),
        TRIP_END(11);

        public int value;

        private Policy(int val) {
            this.value = val;
        }
    }
}

