/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.drm.reuse;

import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class TPDoubleQueueCachedPool<T> {
    private static final String TAG = "[PlayerCore][TPDoubleQueueCachedPool]";
    private final List<T> mIdleCacheList = new ArrayList<T>();
    private final List<T> mBusyCacheList = new ArrayList<T>();
    private static final int DEFAULT_CORE_POOL_SIZE = 2;
    private final int mCorePoolSize;
    private ITPObjectLifecycleMgr<T> mObjectLifecycleMgr;

    public TPDoubleQueueCachedPool(int n2, int n3, ITPObjectLifecycleMgr<T> iTPObjectLifecycleMgr) {
        this.mCorePoolSize = n3 > 0 ? n3 : 2;
        n2 = n2 > 0 ? n2 : 2;
        this.mObjectLifecycleMgr = iTPObjectLifecycleMgr;
        for (int i2 = 0; i2 < n2; ++i2) {
            T t2 = iTPObjectLifecycleMgr.create(this);
            if (t2 == null) {
                TPNativeLog.printLog(3, TAG, "TPDoubleQueueCachedPool, createObject failed.");
                continue;
            }
            this.mIdleCacheList.add(t2);
        }
        TPNativeLog.printLog(2, TAG, "TPDoubleQueueCachedPool init size:" + this.mIdleCacheList.size());
    }

    public synchronized T allocObject() {
        T t2;
        if (this.mIdleCacheList.isEmpty()) {
            t2 = this.mObjectLifecycleMgr.create(this);
            if (t2 == null) {
                return null;
            }
        } else {
            t2 = this.mIdleCacheList.remove(0);
        }
        this.mBusyCacheList.add(t2);
        return t2;
    }

    public synchronized void recycleObject(T t2) {
        if (this.mBusyCacheList.remove(t2) && this.mIdleCacheList.size() < this.mCorePoolSize && this.mObjectLifecycleMgr.reset(this, t2)) {
            this.mIdleCacheList.add(t2);
            return;
        }
        this.mObjectLifecycleMgr.release(this, t2);
    }

    public synchronized void freeObject(T t2) {
        this.mBusyCacheList.remove(t2);
        this.mObjectLifecycleMgr.release(this, t2);
    }

    public synchronized void release() {
        ListIterator<T> listIterator = this.mBusyCacheList.listIterator();
        while (listIterator.hasNext()) {
            this.mObjectLifecycleMgr.release(this, listIterator.next());
            listIterator.remove();
        }
        listIterator = this.mIdleCacheList.listIterator();
        while (listIterator.hasNext()) {
            this.mObjectLifecycleMgr.release(this, listIterator.next());
            listIterator.remove();
        }
        this.mObjectLifecycleMgr = null;
    }

    static interface ITPObjectLifecycleMgr<T> {
        public T create(TPDoubleQueueCachedPool<T> var1);

        public void release(TPDoubleQueueCachedPool<T> var1, T var2);

        public boolean reset(TPDoubleQueueCachedPool<T> var1, T var2);
    }
}

