/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.drm;

import android.media.MediaDrm;
import android.media.MediaDrmException;
import android.media.UnsupportedSchemeException;
import android.os.Build;
import android.os.Handler;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import com.tencent.thumbplayer.tcmedia.core.drm.ITPMediaDrm;
import com.tencent.thumbplayer.tcmedia.core.drm.TPMediaDrmFatalException;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class TPDirectMediaDrm
implements ITPMediaDrm {
    private static final String TAG = "TPDirectMediaDrm";
    private MediaDrm mMediaDrm;
    private boolean mReleased = false;
    private ITPMediaDrm.OnEventListener mOnEventListener;
    private ITPMediaDrm.OnKeyStatusChangeListener mOnKeyStatusChangeListener;
    private ITPMediaDrm.OnExpirationUpdateListener mOnExpirationUpdateListener;

    public TPDirectMediaDrm(UUID uUID) {
        try {
            this.mMediaDrm = new MediaDrm(uUID);
        }
        catch (UnsupportedSchemeException unsupportedSchemeException) {
            throw unsupportedSchemeException;
        }
        catch (Throwable throwable) {
            this.mReleased = true;
            TPNativeLog.printLog(4, TAG, "new MediaDrm failed, e:".concat(String.valueOf(throwable)));
        }
        TPNativeLog.printLog(2, TAG, "TPDirectMediaDrm constructor");
    }

    @Override
    public synchronized byte[] openSession() {
        if (this.mReleased) {
            throw new TPMediaDrmFatalException("released");
        }
        try {
            return this.mMediaDrm.openSession();
        }
        catch (MediaDrmException mediaDrmException) {
            throw mediaDrmException;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            throw new TPMediaDrmFatalException(throwable.getMessage());
        }
    }

    @Override
    public synchronized void closeSession(byte[] byArray) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.closeSession(byArray);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    public synchronized MediaDrm.KeyRequest getKeyRequest(byte[] byArray, byte[] byArray2, String string, int n2, HashMap<String, String> hashMap) {
        if (this.mReleased) {
            throw new TPMediaDrmFatalException("released");
        }
        try {
            return this.mMediaDrm.getKeyRequest(byArray, byArray2, string, n2, hashMap);
        }
        catch (MediaDrmException mediaDrmException) {
            throw mediaDrmException;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            throw new TPMediaDrmFatalException(throwable.getMessage());
        }
    }

    @Override
    public synchronized byte[] provideKeyResponse(byte[] byArray, byte[] byArray2) {
        if (this.mReleased) {
            throw new TPMediaDrmFatalException("released");
        }
        try {
            return this.mMediaDrm.provideKeyResponse(byArray, byArray2);
        }
        catch (MediaDrmException mediaDrmException) {
            throw mediaDrmException;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            throw new TPMediaDrmFatalException(throwable.getMessage());
        }
    }

    @Override
    public synchronized MediaDrm.ProvisionRequest getProvisionRequest() {
        if (this.mReleased) {
            throw new TPMediaDrmFatalException("released");
        }
        try {
            return this.mMediaDrm.getProvisionRequest();
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            throw new TPMediaDrmFatalException(throwable.getMessage());
        }
    }

    @Override
    public synchronized void provideProvisionResponse(byte[] byArray) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.provideProvisionResponse(byArray);
            return;
        }
        catch (MediaDrmException mediaDrmException) {
            throw mediaDrmException;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    public synchronized void restoreKeys(byte[] byArray, byte[] byArray2) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.restoreKeys(byArray, byArray2);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    public synchronized void removeKeys(byte[] byArray) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.removeKeys(byArray);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    public synchronized void setOnKeyStatusChangeListener(ITPMediaDrm.OnKeyStatusChangeListener onKeyStatusChangeListener, Handler handler) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (this.mReleased) {
            return;
        }
        this.mOnKeyStatusChangeListener = onKeyStatusChangeListener;
        this.mMediaDrm.setOnKeyStatusChangeListener(new MediaDrm.OnKeyStatusChangeListener(){

            public void onKeyStatusChange(MediaDrm mediaDrm, byte[] byArray, List<MediaDrm.KeyStatus> list, boolean bl) {
                ITPMediaDrm.OnKeyStatusChangeListener onKeyStatusChangeListener = TPDirectMediaDrm.this.mOnKeyStatusChangeListener;
                if (onKeyStatusChangeListener != null) {
                    onKeyStatusChangeListener.onKeyStatusChange(TPDirectMediaDrm.this, byArray, list, bl);
                }
            }
        }, handler);
    }

    @Override
    public synchronized void setOnExpirationUpdateListener(ITPMediaDrm.OnExpirationUpdateListener onExpirationUpdateListener, Handler handler) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        if (this.mReleased) {
            return;
        }
        this.mOnExpirationUpdateListener = onExpirationUpdateListener;
        this.mMediaDrm.setOnExpirationUpdateListener(new MediaDrm.OnExpirationUpdateListener(){

            public void onExpirationUpdate(MediaDrm mediaDrm, byte[] byArray, long l2) {
                ITPMediaDrm.OnExpirationUpdateListener onExpirationUpdateListener = TPDirectMediaDrm.this.mOnExpirationUpdateListener;
                if (onExpirationUpdateListener != null) {
                    onExpirationUpdateListener.onExpirationUpdate(TPDirectMediaDrm.this, byArray, l2);
                }
            }
        }, handler);
    }

    @Override
    public synchronized HashMap<String, String> queryKeyStatus(byte[] byArray) {
        if (this.mReleased) {
            return new HashMap<String, String>();
        }
        try {
            return this.mMediaDrm.queryKeyStatus(byArray);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return new HashMap<String, String>();
        }
    }

    @Override
    public synchronized String getPropertyString(String string) {
        if (this.mReleased) {
            return "";
        }
        try {
            return this.mMediaDrm.getPropertyString(string);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return "";
        }
    }

    @Override
    public synchronized void setPropertyString(String string, String string2) {
        if (this.mReleased) {
            return;
        }
        try {
            this.mMediaDrm.setPropertyString(string, string2);
            return;
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
            this.close();
            return;
        }
    }

    @Override
    public synchronized void close() {
        if (this.mReleased) {
            return;
        }
        this.mMediaDrm.setOnEventListener(null);
        this.mOnEventListener = null;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mMediaDrm.setOnExpirationUpdateListener(null, null);
        }
        this.mOnExpirationUpdateListener = null;
        if (Build.VERSION.SDK_INT >= 23) {
            this.mMediaDrm.setOnKeyStatusChangeListener(null, null);
        }
        this.mOnKeyStatusChangeListener = null;
        try {
            if (Build.VERSION.SDK_INT >= 28) {
                this.mMediaDrm.close();
            } else {
                this.mMediaDrm.release();
            }
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, TAG, throwable.toString());
        }
        this.mMediaDrm = null;
        this.mReleased = true;
    }
}

