/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.common;

import android.content.Context;
import android.text.TextUtils;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class TPLoadLibFromApk {
    private static final HashMap<String, WeakReference<ClassLoader>> mLoadedLibs = new HashMap();
    private static Context mContext = null;

    private TPLoadLibFromApk() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean load(String string, ClassLoader classLoader, Context context) {
        Object object;
        Object object2;
        if (string == null || string.length() == 0 || classLoader == null) {
            return false;
        }
        mContext = context;
        Serializable serializable = mLoadedLibs;
        synchronized (serializable) {
            object2 = null;
            object = mLoadedLibs.get(string);
            if (object != null) {
                object2 = (ClassLoader)((Reference)object).get();
            }
            if (object2 != null) {
                if (object2 == classLoader) {
                    TPNativeLog.printLog(2, "callerClassLoader has already load ! name=".concat(String.valueOf(string)));
                    return true;
                }
                throw new UnsatisfiedLinkError("Library '" + string + "' was loaded by a different ClassLoader.");
            }
        }
        if (context == null) {
            try {
                TPNativeLog.printLog(2, "context is null,load by System.loadLibrary,name= ".concat(String.valueOf(string)));
                TPLoadLibFromApk.reflectSystemLoadLibrary(string, classLoader);
                serializable = mLoadedLibs;
                synchronized (serializable) {
                    mLoadedLibs.put(string, new WeakReference<ClassLoader>(classLoader));
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Failed loading library: ".concat(String.valueOf(string))).initCause(invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Failed loading library: ".concat(String.valueOf(string))).initCause(exception);
            }
            return true;
        }
        object2 = context.getDir("recover_lib", 0);
        object = new File((File)object2, "lib" + string + ".so");
        serializable = TPLoadLibFromApk.loadFromRecovery(string, classLoader, context, (File)object);
        if (serializable == null) {
            return true;
        }
        return TPLoadLibFromApk.loadFromApk(string, classLoader, context, (File)object, serializable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UnsatisfiedLinkError loadFromRecovery(String string, ClassLoader classLoader, Context context, File file) {
        Serializable serializable;
        UnsatisfiedLinkError unsatisfiedLinkError = null;
        if (file.isFile()) {
            try {
                TPNativeLog.printLog(2, "load by recover_lib,name= " + string + "recoverfile=" + file);
                TPLoadLibFromApk.reflectSystemLoad(file.getAbsolutePath(), classLoader);
                HashMap<String, WeakReference<ClassLoader>> hashMap = mLoadedLibs;
                synchronized (hashMap) {
                    mLoadedLibs.put(string, new WeakReference<ClassLoader>(classLoader));
                }
                return null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
            }
            catch (InvocationTargetException invocationTargetException) {
                serializable = invocationTargetException;
                if (invocationTargetException.getCause() instanceof UnsatisfiedLinkError) {
                    unsatisfiedLinkError = (UnsatisfiedLinkError)((InvocationTargetException)serializable).getCause();
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Failed recovering native library: ".concat(String.valueOf(string))).initCause(((InvocationTargetException)serializable).getCause());
            }
            catch (Throwable throwable) {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Failed recovering native library: ".concat(String.valueOf(string))).initCause(throwable);
            }
            TPNativeLog.printLog(2, "load by recover_lib failed!,name= ".concat(String.valueOf(string)));
            file.delete();
        }
        try {
            TPLoadLibFromApk.reflectSystemLoadLibrary(string, classLoader);
            TPNativeLog.printLog(2, "load by reflectSystemLoadLibrary,name= ".concat(String.valueOf(string)));
            serializable = mLoadedLibs;
            synchronized (serializable) {
                mLoadedLibs.put(string, new WeakReference<ClassLoader>(classLoader));
            }
            return null;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError3) {
            if (unsatisfiedLinkError == null) {
                unsatisfiedLinkError = unsatisfiedLinkError3;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            serializable = invocationTargetException;
            if (invocationTargetException.getCause() instanceof UnsatisfiedLinkError) {
                if (unsatisfiedLinkError == null) {
                    unsatisfiedLinkError = (UnsatisfiedLinkError)((InvocationTargetException)serializable).getCause();
                }
            }
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Failed recovering native library: ".concat(String.valueOf(string))).initCause(((InvocationTargetException)serializable).getCause());
        }
        catch (Throwable throwable) {
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Failed recovering native library: ".concat(String.valueOf(string))).initCause(throwable);
        }
        return unsatisfiedLinkError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean loadFromApk(String string, ClassLoader classLoader, Context context, File file, UnsatisfiedLinkError unsatisfiedLinkError) {
        Object object;
        ZipFile zipFile = null;
        try {
            object = context.getApplicationInfo().sourceDir;
            zipFile = new ZipFile((String)object);
            TPNativeLog.printLog(2, "unzip apk,name= " + string + "apkPath=" + (String)object);
            if (!TPLoadLibFromApk.extractLibrary(zipFile, string, TPLoadLibFromApk.generateAbiList(), file)) {
                throw new RuntimeException("Can't find recover library: ".concat(String.valueOf(string)));
            }
        }
        catch (Exception exception) {
            try {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Failed recovering native library.").initCause(exception);
            }
            catch (Throwable throwable) {
                if (zipFile == null) throw throwable;
                try {
                    zipFile.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    return false;
                }
            }
        }
        try {
            zipFile.close();
        }
        catch (IOException iOException) {
            return false;
        }
        try {
            TPNativeLog.printLog(2, "load from unzip apk,name= ".concat(String.valueOf(string)));
            TPLoadLibFromApk.reflectSystemLoad(file.getAbsolutePath(), classLoader);
            object = mLoadedLibs;
            synchronized (object) {
                mLoadedLibs.put(string, new WeakReference<ClassLoader>(classLoader));
                return true;
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            if (unsatisfiedLinkError != null) throw unsatisfiedLinkError;
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Failed recovering native library: ".concat(String.valueOf(string))).initCause(invocationTargetException.getCause());
        }
        catch (Exception exception) {
            if (unsatisfiedLinkError != null) throw unsatisfiedLinkError;
            throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("Failed recovering native library.").initCause(exception);
        }
    }

    public static String find(String string, Context context) {
        String string2;
        Object object;
        Object object2;
        if (context == null) {
            return null;
        }
        try {
            object2 = TPLoadLibFromApk.class.getClassLoader();
            object = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
            ((Method)object).setAccessible(true);
            string2 = (String)((Method)object).invoke(object2, string);
        }
        catch (Exception exception) {
            string2 = null;
        }
        if (string2 == null && ((File)(object = new File((File)(object2 = context.getDir("recover_lib", 0)), "lib" + string + ".so"))).canRead()) {
            string2 = ((File)object).getAbsolutePath();
        }
        return string2;
    }

    private static void reflectSystemLoad(String string, ClassLoader classLoader) {
        Runtime runtime = Runtime.getRuntime();
        Method method = runtime.getClass().getDeclaredMethod("load", String.class, ClassLoader.class);
        method.setAccessible(true);
        method.invoke((Object)runtime, string, classLoader);
    }

    private static void reflectSystemLoadLibrary(String string, ClassLoader classLoader) {
        Runtime runtime = Runtime.getRuntime();
        Method method = runtime.getClass().getDeclaredMethod("loadLibrary", String.class, ClassLoader.class);
        method.setAccessible(true);
        method.invoke((Object)runtime, string, classLoader);
    }

    private static List<String> generateAbiList() {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        Method method = Class.forName("android.os.SystemProperties").getMethod("get", String.class);
        String string = (String)method.invoke(null, "ro.product.cpu.abi");
        if (string != null && string.length() > 0) {
            arrayList.add(string);
        }
        if ((string = (String)method.invoke(null, "ro.product.cpu.abi2")) != null && string.length() > 0) {
            arrayList.add(string);
        }
        arrayList.add("armeabi");
        return arrayList;
    }

    private static boolean extractLibrary(ZipFile zipFile, String string, List<String> list, File file) {
        if (file.isFile()) {
            return true;
        }
        Iterator<String> iterator = list.iterator();
        if (iterator.hasNext()) {
            String string2 = iterator.next();
            ZipEntry zipEntry = zipFile.getEntry("lib/" + string2 + "/lib" + string + ".so");
            if (zipEntry == null) {
                return false;
            }
            String string3 = zipEntry.getName();
            if (!TextUtils.isEmpty((CharSequence)string3) && string3.contains("../")) {
                return false;
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            byte[] byArray = new byte[2048];
            try {
                int n2;
                while ((n2 = inputStream.read(byArray, 0, 2048)) != -1) {
                    fileOutputStream.write(byArray, 0, n2);
                }
            }
            finally {
                inputStream.close();
                fileOutputStream.close();
            }
            try {
                file.setReadOnly();
            }
            catch (Throwable throwable) {
                return false;
            }
            return true;
        }
        return false;
    }

    private static void extractAllLibraries(Context context) {
        if (context == null) {
            return;
        }
        List<String> list = TPLoadLibFromApk.generateAbiList();
        File file = context.getDir("recover_lib", 0);
        String string = context.getApplicationInfo().sourceDir;
        ZipFile zipFile = new ZipFile(string);
        try {
            HashSet<String> hashSet = new HashSet<String>();
            Pattern pattern = Pattern.compile("lib/[A-Za-z0-9-_=]+/lib([A-Za-z0-9-_=]+)\\.so");
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                String string2;
                ZipEntry zipEntry = enumeration.nextElement();
                String string3 = zipEntry.getName();
                if (!TextUtils.isEmpty((CharSequence)string3) && string3.contains("../")) {
                    throw new Exception("contain ../, throw err");
                }
                Matcher matcher = pattern.matcher(zipEntry.getName());
                if (!matcher.matches() || hashSet.contains(string2 = matcher.group(1))) continue;
                File file2 = new File(file, "lib" + string2 + ".so");
                TPLoadLibFromApk.extractLibrary(zipFile, string2, list, file2);
                hashSet.add(string2);
            }
            return;
        }
        finally {
            zipFile.close();
        }
    }

    public static void setupBrokenLibraryHandler() {
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new LibraryBrokenHandler(uncaughtExceptionHandler));
    }

    static class LibraryBrokenHandler
    implements Thread.UncaughtExceptionHandler {
        private Thread.UncaughtExceptionHandler mParent;

        LibraryBrokenHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            this.mParent = uncaughtExceptionHandler;
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            boolean bl = false;
            if (throwable instanceof UnsatisfiedLinkError || throwable instanceof NoSuchMethodError && throwable.getMessage().matches(".*sig(nature)?[=:].*")) {
                try {
                    TPLoadLibFromApk.extractAllLibraries(mContext);
                    bl = true;
                }
                catch (Exception exception) {
                    bl = false;
                }
            }
            if (bl) {
                throwable = new UnsatisfiedLinkError("Invalid so detected and recovered.").initCause(throwable);
            }
            this.mParent.uncaughtException(thread, throwable);
        }
    }
}

