/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.common;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.tencent.thumbplayer.tcmedia.core.common.TPAudioPassThroughCapabilities;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TPAudioPassThroughPluginDetector {
    private static final String TAG = "TPAudioPassThroughPluginDetector";
    private static boolean isInitted = false;
    private static boolean hasRegisterReceiver = false;
    private static WeakReference<Context> mContextRef = null;
    private static BroadcastReceiver mReceiver = null;
    private static List<AudioPassThroughPluginListener> listeners = new LinkedList<AudioPassThroughPluginListener>();
    private static boolean mIsAudioPassThroughPlugin = false;
    private static TPAudioPassThroughCapabilities mAudioPassThroughCapabilities = null;
    private static final int DEFAULT_MAX_CHANNEL_COUNT = 8;
    private static Handler mHandler;

    private static Looper getLooper() {
        Looper looper = Looper.myLooper();
        if (looper != null) {
            return looper;
        }
        return Looper.getMainLooper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context) {
        Class<TPAudioPassThroughPluginDetector> clazz = TPAudioPassThroughPluginDetector.class;
        synchronized (TPAudioPassThroughPluginDetector.class) {
            TPNativeLog.printLog(2, TAG, "TPAudioPassThroughPluginDetector init enter!");
            if (isInitted) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            Context context2 = context.getApplicationContext();
            mContextRef = new WeakReference<Context>(context2);
            isInitted = true;
            mHandler = new Handler(TPAudioPassThroughPluginDetector.getLooper());
            TPAudioPassThroughPluginDetector.registerReceiver();
            hasRegisterReceiver = true;
            TPNativeLog.printLog(2, TAG, "TPAudioPassThroughPluginDetector init succeed!");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deinit() {
        Class<TPAudioPassThroughPluginDetector> clazz = TPAudioPassThroughPluginDetector.class;
        synchronized (TPAudioPassThroughPluginDetector.class) {
            if (!isInitted || mContextRef == null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            mContextRef.clear();
            isInitted = false;
            TPNativeLog.printLog(2, TAG, "TPAudioPassThroughPluginDetector deinit succeed!");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAudioPassThroughPlugin() {
        Class<TPAudioPassThroughPluginDetector> clazz = TPAudioPassThroughPluginDetector.class;
        synchronized (TPAudioPassThroughPluginDetector.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return mIsAudioPassThroughPlugin;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(AudioPassThroughPluginListener audioPassThroughPluginListener) {
        Class<TPAudioPassThroughPluginDetector> clazz = TPAudioPassThroughPluginDetector.class;
        synchronized (TPAudioPassThroughPluginDetector.class) {
            if (listeners.add(audioPassThroughPluginListener) && !hasRegisterReceiver) {
                TPAudioPassThroughPluginDetector.registerReceiver();
                hasRegisterReceiver = true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(AudioPassThroughPluginListener audioPassThroughPluginListener) {
        Class<TPAudioPassThroughPluginDetector> clazz = TPAudioPassThroughPluginDetector.class;
        synchronized (TPAudioPassThroughPluginDetector.class) {
            listeners.remove(audioPassThroughPluginListener);
            if (listeners.isEmpty() && hasRegisterReceiver) {
                TPAudioPassThroughPluginDetector.unregisterReceiver();
                hasRegisterReceiver = false;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean isAudioPassThroughSupport(int n2, int n3) {
        if (mAudioPassThroughCapabilities != null) {
            return mAudioPassThroughCapabilities.supportsEncoding(n2) && n3 <= mAudioPassThroughCapabilities.getMaxChannelCount();
        }
        TPNativeLog.printLog(4, TAG, "isAudioPassThroughSupport failed, mAudioPassThroughCapabilities is not init yet!");
        return false;
    }

    private static void registerReceiver() {
        Context context;
        TPNativeLog.printLog(2, TAG, "registerReceiver enter");
        if (Build.VERSION.SDK_INT < 24) {
            return;
        }
        if (!isInitted || mContextRef == null) {
            TPNativeLog.printLog(4, TAG, "registerReceiver failed, TPAudioPassThroughPluginDetector is not init yet!");
            return;
        }
        if (mReceiver == null) {
            mReceiver = new HdmiAudioPlugBroadcastReceiver();
        }
        if ((context = (Context)mContextRef.get()) == null) {
            TPNativeLog.printLog(4, TAG, "registerReceiver failed, context is null, maybe is invalid!");
            return;
        }
        Intent intent = null;
        if (mReceiver != null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.media.action.HDMI_AUDIO_PLUG");
            intent = context.registerReceiver(mReceiver, intentFilter, null, mHandler);
        }
        mAudioPassThroughCapabilities = TPAudioPassThroughCapabilities.getCapabilities(context, intent);
        TPNativeLog.printLog(2, TAG, "registerReceiver leave");
    }

    private static void unregisterReceiver() {
        if (!isInitted || mContextRef == null) {
            TPNativeLog.printLog(4, TAG, "registerReceiver failed, TPAudioPassThroughPluginDetector is not init yet!");
            return;
        }
        Context context = (Context)mContextRef.get();
        if (context == null) {
            TPNativeLog.printLog(4, TAG, "registerReceiver failed, context is null, maybe is invalid!");
            return;
        }
        context.unregisterReceiver(mReceiver);
    }

    private static void onUpdateAudioCapabilities(TPAudioPassThroughCapabilities tPAudioPassThroughCapabilities) {
        if (!tPAudioPassThroughCapabilities.equals(mAudioPassThroughCapabilities)) {
            mAudioPassThroughCapabilities = tPAudioPassThroughCapabilities;
            TPNativeLog.printLog(2, TAG, "onUpdateAudioCapabilities AudioCapabilities:" + mAudioPassThroughCapabilities.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyAudioPassThroughStateChange(boolean bl) {
        boolean bl2 = true;
        if (mIsAudioPassThroughPlugin == bl) {
            bl2 = false;
        }
        if (!bl2) {
            return;
        }
        mIsAudioPassThroughPlugin = bl;
        Class<TPAudioPassThroughPluginDetector> clazz = TPAudioPassThroughPluginDetector.class;
        synchronized (TPAudioPassThroughPluginDetector.class) {
            Iterator<AudioPassThroughPluginListener> iterator = listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().onAudioPassThroughPlugin(bl);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static class HdmiAudioPlugBroadcastReceiver
    extends BroadcastReceiver {
        private HdmiAudioPlugBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            TPNativeLog.printLog(2, TPAudioPassThroughPluginDetector.TAG, "HdmiAudioPlugBroadcastReceiver onReceive: " + intent.getAction());
            boolean bl = false;
            if (intent != null) {
                int n2 = intent.getIntExtra("android.media.extra.AUDIO_PLUG_STATE", 0);
                if (n2 == 0) {
                    bl = false;
                } else if (n2 == 1) {
                    bl = true;
                }
                TPNativeLog.printLog(2, TPAudioPassThroughPluginDetector.TAG, "HdmiAudioPlugBroadcastReceiver audioPassThroughState:" + n2 + " bPlugin:" + bl);
                TPAudioPassThroughPluginDetector.onUpdateAudioCapabilities(new TPAudioPassThroughCapabilities(intent.getIntArrayExtra("android.media.extra.ENCODINGS"), intent.getIntExtra("android.media.extra.MAX_CHANNEL_COUNT", 8)));
                TPAudioPassThroughPluginDetector.notifyAudioPassThroughStateChange(bl);
            }
        }
    }

    static interface AudioPassThroughPluginListener {
        public void onAudioPassThroughPlugin(boolean var1);
    }
}

