/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.h;
import com.tencent.liteav.base.util.i;
import com.tencent.rtmp.ui.AndroidViewEventListener;
import com.tencent.rtmp.ui.FocusIndicatorView;
import com.tencent.rtmp.ui.c;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;

public class TXCloudVideoView
extends FrameLayout
implements ScaleGestureDetector.OnScaleGestureListener {
    private final String mTAG = "TXCloudVideoView_" + ((Object)((Object)this)).hashCode();
    private static final int FOCUS_AREA_SIZE_IN_DP = 70;
    private final WeakReference<SurfaceView> mSurfaceView;
    private final WeakReference<Surface> mSurface;
    private TextureView mUserTextureView;
    private TextureView mInnerTextureView;
    protected Object mGLContext;
    private FocusIndicatorView mFocusIndicatorView;
    private boolean mEnableTouchToFocus = false;
    private final a mDelayedTapRunnable = new a(0);
    private ScaleGestureDetector mScaleGestureDetector;
    private boolean mEnableZoom = false;
    private float mLastScaleFactor;
    private float mScaleFactor;
    private String mUserId = "";
    private WeakReference<b> mCallback;
    private boolean mEnableShowLog;
    private AndroidViewEventListener mViewEventListener;
    private Object mRenderClient;
    private TextureView.SurfaceTextureListener mClientTextureViewListener;
    private SurfaceTexture mInnerSurfaceTexture;
    private int mInnerSurfaceTextureWidth;
    private int mInnerSurfaceTextureHeight;
    private final Runnable mHideIndicatorViewRunnable = com.tencent.rtmp.ui.a.a(this);
    private final TextureView.SurfaceTextureListener mInnerTextureViewListener = new TextureView.SurfaceTextureListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            LiteavLog.i(TXCloudVideoView.this.mTAG, "onSurfaceTextureAvailable: " + surface + ", " + width + "x" + height);
            1 var4_4 = this;
            synchronized (var4_4) {
                TXCloudVideoView.this.mInnerSurfaceTexture = surface;
                TXCloudVideoView.this.mInnerSurfaceTextureWidth = width;
                TXCloudVideoView.this.mInnerSurfaceTextureHeight = height;
                if (TXCloudVideoView.this.mClientTextureViewListener != null) {
                    TXCloudVideoView.this.mClientTextureViewListener.onSurfaceTextureAvailable(TXCloudVideoView.this.mInnerSurfaceTexture, TXCloudVideoView.this.mInnerSurfaceTextureWidth, TXCloudVideoView.this.mInnerSurfaceTextureHeight);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            if (!surface.equals(TXCloudVideoView.this.mInnerSurfaceTexture)) {
                return;
            }
            1 var4_4 = this;
            synchronized (var4_4) {
                TXCloudVideoView.this.mInnerSurfaceTextureWidth = width;
                TXCloudVideoView.this.mInnerSurfaceTextureHeight = height;
                if (TXCloudVideoView.this.mClientTextureViewListener != null) {
                    TXCloudVideoView.this.mClientTextureViewListener.onSurfaceTextureSizeChanged(surface, width, height);
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            LiteavLog.i(TXCloudVideoView.this.mTAG, "onSurfaceTextureDestroyed: ".concat(String.valueOf(surface)));
            if (!surface.equals(TXCloudVideoView.this.mInnerSurfaceTexture)) {
                return true;
            }
            1 var2_2 = this;
            synchronized (var2_2) {
                TXCloudVideoView.this.mInnerSurfaceTexture = null;
                TXCloudVideoView.this.mInnerSurfaceTextureWidth = 0;
                TXCloudVideoView.this.mInnerSurfaceTextureHeight = 0;
                if (TXCloudVideoView.this.mClientTextureViewListener != null) {
                    TXCloudVideoView.this.mClientTextureViewListener.onSurfaceTextureDestroyed(surface);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onSurfaceTextureUpdated(SurfaceTexture surface) {
            if (!surface.equals(TXCloudVideoView.this.mInnerSurfaceTexture)) {
                return;
            }
            1 var2_2 = this;
            synchronized (var2_2) {
                if (TXCloudVideoView.this.mClientTextureViewListener != null) {
                    TXCloudVideoView.this.mClientTextureViewListener.onSurfaceTextureUpdated(surface);
                }
                return;
            }
        }
    };

    public TXCloudVideoView(Context context) {
        this(context, null, null);
    }

    public TXCloudVideoView(SurfaceView surfaceView) {
        this(surfaceView.getContext(), null, surfaceView);
    }

    public TXCloudVideoView(Context context, Surface surface) {
        this(context, null, null, surface);
    }

    public TXCloudVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, null);
    }

    public TXCloudVideoView(Context context, AttributeSet attrs, SurfaceView surfaceView) {
        this(context, attrs, surfaceView, null);
    }

    private TXCloudVideoView(Context context, AttributeSet attrs, SurfaceView surfaceView, Surface surface) {
        super(context, attrs);
        this.mSurfaceView = surfaceView != null ? new WeakReference<SurfaceView>(surfaceView) : null;
        WeakReference<Surface> weakReference = this.mSurface = surface != null ? new WeakReference<Surface>(surface) : null;
        if (surfaceView == null && surface == null) {
            this.mInnerTextureView = new TextureView(context);
            this.mInnerTextureView.setSurfaceTextureListener(this.mInnerTextureViewListener);
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.addView((View)tXCloudVideoView.mInnerTextureView);
        }
    }

    public void addVideoView(TextureView view) {
        if (view == null) {
            LiteavLog.w(this.mTAG, "addVideoView: null");
            return;
        }
        if (i.a(this.mUserTextureView, view)) {
            LiteavLog.i(this.mTAG, "addVideoView: same view");
            return;
        }
        this.removeVideoView();
        LiteavLog.i(this.mTAG, "addVideoView: ".concat(String.valueOf(view)));
        if (view.getParent() == null) {
            this.addView((View)view);
        } else if (view.getParent() == this) {
            LiteavLog.i(this.mTAG, "addVideoView: already added.");
        } else {
            LiteavLog.w(this.mTAG, "addVideoView: has other parent:" + view.getParent());
        }
        this.mUserTextureView = view;
    }

    public void removeVideoView() {
        if (this.mUserTextureView == null) {
            return;
        }
        LiteavLog.i(this.mTAG, "removeVideoView");
        try {
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.removeView((View)tXCloudVideoView.mUserTextureView);
        }
        catch (Exception exception) {
            LiteavLog.e(this.mTAG, "removeVideoView error: ", exception);
        }
        this.mUserTextureView = null;
    }

    @Deprecated
    public TextureView getVideoView() {
        if (this.mUserTextureView != null) {
            return this.mUserTextureView;
        }
        return this.mInnerTextureView;
    }

    private void setBackgroundColorForInternalView(int color) {
        LiteavLog.i(this.mTAG, "setBackgroundColorForInternalView color:".concat(String.valueOf(color)));
        if (this.mSurface != null || this.mSurfaceView != null) {
            return;
        }
        int n2 = color & 0xFF;
        int n3 = color >> 8 & 0xFF;
        int n4 = color >> 16 & 0xFF;
        int n5 = color >> 24 & 0xFF;
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.post(com.tencent.rtmp.ui.b.a(tXCloudVideoView, n2, n5, n4, n3));
    }

    @Deprecated
    public TextureView getHWVideoView() {
        return this.getVideoView();
    }

    private TextureView getTextureViewSetByUser() {
        return this.mUserTextureView;
    }

    private TextureView getInnerTextureView() {
        return this.mInnerTextureView;
    }

    private synchronized void setRenderClient(Object client, TextureView.SurfaceTextureListener listener) {
        if (client == null || listener == null) {
            LiteavLog.w(this.mTAG, "setRenderClient: null client or listener, ignore.");
            return;
        }
        if (this.mRenderClient != null && i.a(this.mRenderClient, client)) {
            LiteavLog.w(this.mTAG, "setRenderClient: same client, ignore.");
            return;
        }
        if (this.mRenderClient != null) {
            LiteavLog.w(this.mTAG, "setRenderClient: last client unreleased, " + this.mRenderClient);
            if (this.mClientTextureViewListener != null) {
                this.mClientTextureViewListener.onSurfaceTextureDestroyed(this.mInnerSurfaceTexture);
            }
            this.mRenderClient = null;
            this.mClientTextureViewListener = null;
        }
        LiteavLog.i(this.mTAG, "setRenderClient: ".concat(String.valueOf(client)));
        this.mRenderClient = client;
        this.mClientTextureViewListener = listener;
        if (this.mInnerSurfaceTexture != null) {
            this.mClientTextureViewListener.onSurfaceTextureAvailable(this.mInnerSurfaceTexture, this.mInnerSurfaceTextureWidth, this.mInnerSurfaceTextureHeight);
        }
    }

    private synchronized void releaseRenderClient(Object client, boolean clearLastImage) {
        if (client == null || !i.a(this.mRenderClient, client)) {
            LiteavLog.w(this.mTAG, "releaseRenderClient: client not equal, ignore.");
            return;
        }
        LiteavLog.i(this.mTAG, "releaseRenderClient: " + client + ", clearLastImage=" + clearLastImage);
        this.mRenderClient = null;
        this.mClientTextureViewListener = null;
        if (clearLastImage && this.mInnerTextureView != null && this.mInnerTextureView.getParent() == this) {
            try {
                TXCloudVideoView tXCloudVideoView = this;
                tXCloudVideoView.removeView((View)tXCloudVideoView.mInnerTextureView);
                TXCloudVideoView tXCloudVideoView2 = this;
                tXCloudVideoView2.addView((View)tXCloudVideoView2.mInnerTextureView, 0);
                return;
            }
            catch (Exception exception) {
                LiteavLog.e(this.mTAG, "reset texture view error: ", exception);
            }
        }
    }

    private void setTouchToFocusEnabled(boolean enabled) {
        this.mEnableTouchToFocus = enabled;
    }

    private void setZoomEnabled(boolean enabled) {
        LiteavLog.i(this.mTAG, "setZoomEnabled: ".concat(String.valueOf(enabled)));
        this.mEnableZoom = enabled;
    }

    public SurfaceView getSurfaceView() {
        if (this.mSurfaceView == null) {
            return null;
        }
        SurfaceView surfaceView = (SurfaceView)this.mSurfaceView.get();
        if (surfaceView == null) {
            LiteavLog.w(this.mTAG, "surfaceView is null.");
        }
        return surfaceView;
    }

    public Surface getSurface() {
        if (this.mSurface == null) {
            return null;
        }
        Surface surface = (Surface)this.mSurface.get();
        if (surface == null) {
            LiteavLog.w(this.mTAG, "surface is null.");
        }
        return surface;
    }

    public void setOpenGLContext(Object glContext) {
        this.mGLContext = glContext;
    }

    public Object getOpenGLContext() {
        return this.mGLContext;
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onDestroy() {
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        LiteavLog.i(this.mTAG, "onAttachedToWindow");
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        LiteavLog.i(this.mTAG, "onDetachedFromWindow");
    }

    public void clearLastFrame(boolean clear) {
        if (clear) {
            this.setVisibility(8);
        }
    }

    public void setUserId(String userId) {
        this.mUserId = userId;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getPointerCount() == 1 && event.getAction() == 0) {
            if (this.mEnableTouchToFocus) {
                int n2 = this.getHeight();
                int n3 = this.getWidth();
                int n4 = (int)event.getY();
                int n5 = (int)event.getX();
                a a2 = this.mDelayedTapRunnable;
                this.mDelayedTapRunnable.a.x = n5;
                a2.a.y = n4;
                a2.b = n3;
                a2.c = n2;
                TXCloudVideoView tXCloudVideoView = this;
                tXCloudVideoView.removeCallbacks(tXCloudVideoView.mDelayedTapRunnable);
                TXCloudVideoView tXCloudVideoView2 = this;
                tXCloudVideoView2.postDelayed(tXCloudVideoView2.mDelayedTapRunnable, 100L);
            }
        } else if (event.getPointerCount() > 1 && event.getAction() == 2 && this.mEnableZoom) {
            TXCloudVideoView tXCloudVideoView = this;
            tXCloudVideoView.removeCallbacks(tXCloudVideoView.mDelayedTapRunnable);
            this.hideIndicatorView();
            if (this.mScaleGestureDetector == null) {
                this.mScaleGestureDetector = new ScaleGestureDetector(this.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this);
            }
            this.mScaleGestureDetector.onTouchEvent(event);
        }
        if (this.mEnableZoom) {
            if (event.getAction() == 0) {
                this.performClick();
            }
            return true;
        }
        return super.onTouchEvent(event);
    }

    private void showFocusView(int x2, int y2, int width, int height) {
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.post(c.a(tXCloudVideoView, x2, y2, width, height));
    }

    private void showFocusViewInternal(int x2, int y2, int width, int height) {
        int n2;
        if (width != 0 && width != this.getWidth() || height != 0 && height != this.getHeight()) {
            LiteavLog.i(this.mTAG, "ignore show indicator view when view size changed");
            return;
        }
        LiteavLog.v(this.mTAG, "show indicator view at (%d,%d)", x2, y2);
        TXCloudVideoView tXCloudVideoView = this;
        tXCloudVideoView.removeCallbacks(tXCloudVideoView.mHideIndicatorViewRunnable);
        int n3 = n2 = (int)(70.0f * this.getResources().getDisplayMetrics().density + 0.5f);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n3);
        new FrameLayout.LayoutParams(n3, n3).leftMargin = h.a(x2 - n2 / 2, this.getWidth() - n2);
        layoutParams.topMargin = h.a(y2 - n2 / 2, this.getHeight() - n2);
        if (this.mFocusIndicatorView == null) {
            this.mFocusIndicatorView = new FocusIndicatorView(this.getContext());
            TXCloudVideoView tXCloudVideoView2 = this;
            tXCloudVideoView2.addView(tXCloudVideoView2.mFocusIndicatorView, (ViewGroup.LayoutParams)layoutParams);
        } else {
            TXCloudVideoView tXCloudVideoView3 = this;
            if (tXCloudVideoView3.indexOfChild(tXCloudVideoView3.mFocusIndicatorView) != this.getChildCount() - 1) {
                try {
                    TXCloudVideoView tXCloudVideoView4 = this;
                    tXCloudVideoView4.removeView(tXCloudVideoView4.mFocusIndicatorView);
                }
                catch (Exception exception) {
                    LiteavLog.e(this.mTAG, "removeView focus indicator view error: ", exception);
                }
                TXCloudVideoView tXCloudVideoView5 = this;
                tXCloudVideoView5.addView(tXCloudVideoView5.mFocusIndicatorView, (ViewGroup.LayoutParams)layoutParams);
            } else {
                this.mFocusIndicatorView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
        }
        this.mFocusIndicatorView.setVisibility(0);
        FocusIndicatorView focusIndicatorView = this.mFocusIndicatorView;
        focusIndicatorView.startAnimation((Animation)focusIndicatorView.a);
        TXCloudVideoView tXCloudVideoView6 = this;
        tXCloudVideoView6.postDelayed(tXCloudVideoView6.mHideIndicatorViewRunnable, TimeUnit.SECONDS.toMillis(1L));
    }

    private void hideIndicatorView() {
        if (this.mFocusIndicatorView != null) {
            this.mFocusIndicatorView.setVisibility(8);
        }
    }

    public boolean onScale(ScaleGestureDetector detector) {
        float f2;
        if (!this.mEnableZoom) {
            return false;
        }
        float f3 = detector.getScaleFactor() - this.mLastScaleFactor;
        this.mLastScaleFactor = detector.getScaleFactor();
        float f4 = this.mScaleFactor + f3;
        float f5 = f2 < 0.0f ? 0.0f : (this.mScaleFactor = f4 > 1.0f ? 1.0f : f4);
        if (this.mViewEventListener != null) {
            this.mViewEventListener.onZoom(this.mScaleFactor);
        }
        return false;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        this.mLastScaleFactor = detector.getScaleFactor();
        return this.mEnableZoom;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
    }

    public void setLogMargin(float leftMarginInDp, float rightMarginInDp, float topMarginInDp, float bottomMarginInDp) {
    }

    public void setDashBoardMarginInPx(int left, int right, int top, int bottom) {
    }

    public void setDashBoardMarginInRatio(float leftRatio, float rightRatio, float topRatio, float bottomRatio) {
    }

    public void disableLog(boolean enable) {
    }

    public void showLog(boolean enable) {
        this.mEnableShowLog = enable;
        b b2 = this.mCallback == null ? null : (b)this.mCallback.get();
        if (b2 != null) {
            b2.onShowLog(enable);
        }
    }

    public void clearLog() {
    }

    private void setShowLogCallback(WeakReference<b> callback) {
        this.mCallback = callback;
    }

    private boolean isShowLogEnabled() {
        return this.mEnableShowLog;
    }

    private void setAndroidViewEventListener(AndroidViewEventListener listener) {
        this.mViewEventListener = listener;
    }

    protected void onSizeChanged(int w2, int h2, int oldw, int oldh) {
        if (this.mViewEventListener != null) {
            this.mViewEventListener.onSizeChanged(w2, h2, oldw, oldh);
        }
        super.onSizeChanged(w2, h2, oldw, oldh);
    }

    static /* synthetic */ void lambda$showFocusView$1(TXCloudVideoView this_, int x2, int y2, int width, int height) {
        this_.showFocusViewInternal(x2, y2, width, height);
    }

    static /* synthetic */ void lambda$setBackgroundColorForInternalView$0(TXCloudVideoView this_, int alpha, int red, int green, int blue) {
        this_.setBackgroundColor(Color.argb((int)alpha, (int)red, (int)green, (int)blue));
    }

    static /* synthetic */ void access$lambda$0(TXCloudVideoView tXCloudVideoView) {
        tXCloudVideoView.hideIndicatorView();
    }

    public static interface b {
        public void onShowLog(boolean var1);
    }

    final class a
    implements Runnable {
        final Point a = new Point();
        int b = 0;
        int c = 0;

        private a() {
        }

        @Override
        public final void run() {
            if (TXCloudVideoView.this.mViewEventListener != null) {
                TXCloudVideoView.this.mViewEventListener.onTap(this.a.x, this.a.y, this.b, this.c);
            }
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

