/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.media.ExifInterface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.f;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::video")
public class BitmapUtils {
    public static Bitmap createBitmap(Bitmap source, Matrix matrix, boolean sizeSameAsOriginBitmap) {
        if (source == null) {
            return null;
        }
        source.getConfig();
        try {
            if (sizeSameAsOriginBitmap) {
                Bitmap bitmap = Bitmap.createBitmap((int)source.getWidth(), (int)source.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Paint paint = new Paint();
                paint.setAntiAlias(true);
                new Canvas(bitmap).drawBitmap(source, matrix, paint);
                return bitmap;
            }
            return Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (Throwable throwable) {
            LiteavLog.e("BitmapUtils", "build bitmap failed.", throwable);
            return null;
        }
    }

    public static Bitmap createBitmapFromBuffer(ByteBuffer buffer, int width, int height) {
        try {
            buffer.position(0);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)buffer);
            return bitmap;
        }
        catch (Throwable throwable) {
            LiteavLog.e("BitmapUtils", "build bitmap failed.", throwable);
            return null;
        }
    }

    public static Bitmap createBitmapFromFile(String filePath, int maxWidth, int maxHeight) {
        try {
            boolean bl = false;
            int n2 = 0;
            switch (new ExifInterface(filePath).getAttributeInt("Orientation", 1)) {
                case 2: {
                    bl = true;
                }
                case 1: {
                    n2 = 0;
                    break;
                }
                case 7: {
                    bl = true;
                }
                case 6: {
                    n2 = 90;
                    break;
                }
                case 4: {
                    bl = true;
                }
                case 3: {
                    n2 = 180;
                    break;
                }
                case 5: {
                    bl = true;
                }
                case 8: {
                    n2 = 270;
                }
            }
            Matrix matrix = new Matrix();
            if (bl) {
                matrix.postScale(-1.0f, 1.0f);
            }
            if (n2 != 0) {
                matrix.postRotate((float)n2);
            }
            Bitmap bitmap = BitmapUtils.loadBitmapFile(filePath, maxWidth, maxHeight, n2);
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        catch (Throwable throwable) {
            LiteavLog.e("BitmapUtils", "build bitmap failed, path: ".concat(String.valueOf(filePath)), throwable);
            return null;
        }
    }

    private static Bitmap loadBitmapFile(String filePath, int maxWidth, int maxHeight, int rotation) throws Throwable {
        int n2;
        if (maxWidth <= 0 || maxHeight <= 0) {
            return BitmapFactory.decodeFile((String)filePath);
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        int n3 = 1;
        boolean bl = rotation == 90 || rotation == 270;
        int n4 = bl ? options.outHeight : options.outWidth;
        int n5 = n2 = bl ? options.outWidth : options.outHeight;
        if (n4 > maxWidth || n2 > maxHeight) {
            int n6 = n2 / (maxHeight / 2 + 1);
            int n7 = n4 / (maxWidth / 2 + 1);
            n3 = n6 > n7 ? n7 : n6;
        }
        options.inSampleSize = n3;
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
    }

    public static void saveBitmapToFile(Bitmap bitmap, String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
        }
        catch (Exception exception) {
            try {
                LiteavLog.e("BitmapUtils", "save jpg file failed.", exception);
            }
            catch (Throwable throwable) {
                f.a(fileOutputStream);
                throw throwable;
            }
            f.a(fileOutputStream);
            return;
        }
        f.a(fileOutputStream);
        return;
    }
}

