/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.txcplayer.ext.service;

import android.content.Context;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.Surface;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.sdk.common.LicenseChecker;
import com.tencent.liteav.txcplayer.ITXVCubePlayer;
import com.tencent.liteav.txcplayer.common.c;
import com.tencent.liteav.txcplayer.ext.host.HostEngine;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RenderProcessService {
    private static final String TAG = "HostEngine-RenderProcessService";
    private static RenderProcessService mInstance;
    private ConcurrentHashMap<ITXVCubePlayer, WeakReference<IRenderServiceEventListener>> mEventListenerMap = new ConcurrentHashMap();
    private int mCurrentModel = 0;

    private RenderProcessService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RenderProcessService getInstance() {
        if (mInstance != null) return mInstance;
        Class<RenderProcessService> clazz = RenderProcessService.class;
        synchronized (RenderProcessService.class) {
            if (mInstance != null) return mInstance;
            mInstance = new RenderProcessService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void checkInit(Context appContext) {
        HostEngine.getInstance().init(appContext);
    }

    public int getVodLicenseFeature() {
        if (HostEngine.getInstance().getAppContext() == null) {
            LiteavLog.w(TAG, "Host engine not init!!");
            return 0;
        }
        boolean bl = c.b(LicenseChecker.a.g) == LicenseChecker.d.a;
        LiteavLog.i("VodLicenseCheck", "checkValidForPlayerMonet = ".concat(String.valueOf(bl)));
        if (bl) {
            return 1;
        }
        return 0;
    }

    public boolean canRenderProcessWork(ITXVCubePlayer player) {
        if (player != null && !player.isEnableRenderProcess()) {
            LiteavLog.i(TAG, "[canRenderProcessWork],isEnableRenderProcess == false !!!");
            return false;
        }
        if (!HostEngine.getInstance().checkAndLoadPlugin(2)) {
            LiteavLog.i(TAG, "[canRenderProcessWork],isEnableRenderProcess == false !!!");
            return false;
        }
        if (this.mCurrentModel == 1 || this.mCurrentModel == 2) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            HostEngine.getInstance().sendSyncRequestToPlugin(2, 104, null, hashMap);
            boolean bl = false;
            Object v2 = hashMap.get("KEY_RET_PARAM1");
            if (v2 != null && v2 instanceof Boolean) {
                bl = (Boolean)v2;
            }
            if (!bl) {
                LiteavLog.i(TAG, "[canRenderProcessWork],IS_SUPPORT_RESOLUTION == false !!!");
                return false;
            }
        }
        LiteavLog.i(TAG, "[canRenderProcessWork], finally return true");
        return true;
    }

    public boolean connectPlayer(ITXVCubePlayer player, Surface surface, int moduleType, Map<String, Object> moduleConfig) {
        if (player == null || surface == null) {
            LiteavLog.w(TAG, "connectPlayer invalid param player or surface is null !!!");
            return false;
        }
        if (!this.canRenderProcessWork(player)) {
            LiteavLog.w(TAG, "connectPlayer\uff0cpostProcessService does not need to work");
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        hashMap.put("KEY_PARAM2", surface);
        hashMap.put("KEY_PARAM3", moduleType);
        hashMap.put("KEY_PARAM4", moduleConfig);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 100, hashMap, hashMap2);
        Boolean bl = Boolean.FALSE;
        Object v2 = hashMap2.get("KEY_RET_PARAM1");
        if (v2 != null && v2 instanceof Boolean) {
            bl = (Boolean)v2;
        }
        return bl;
    }

    public boolean setSurfaceBufferSize(ITXVCubePlayer player) {
        if (player == null) {
            LiteavLog.w(TAG, "setSurfaceBufferSize invalid param player is null !!!");
            return false;
        }
        if (!this.canRenderProcessWork(player)) {
            LiteavLog.w(TAG, "setSurfaceBufferSize\uff0cpostProcessService does not need to work");
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 101, hashMap, hashMap2);
        Boolean bl = Boolean.FALSE;
        Object v2 = hashMap2.get("KEY_RET_PARAM1");
        if (v2 != null && v2 instanceof Boolean) {
            bl = (Boolean)v2;
        }
        return bl;
    }

    public void stopRenderProcess(ITXVCubePlayer player) {
        if (!this.canRenderProcessWork(player)) {
            return;
        }
        if (player == null) {
            LiteavLog.w(TAG, "stopRenderProcess invalid param player is null !!!");
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 103, hashMap, null);
    }

    public void updateRenderProcessMode(ITXVCubePlayer player, int mode) {
        this.mCurrentModel = mode;
        if (!this.canRenderProcessWork(player)) {
            LiteavLog.w(TAG, "updatePostProcessMode\uff0cpostProcessService does not need to work");
            return;
        }
        if (player == null) {
            LiteavLog.w(TAG, "updatePostProcessMode invalid param player is null !!!");
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        hashMap.put("KEY_PARAM2", mode);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 102, hashMap, null);
    }

    public void sendPlayerEventToPlugin(ITXVCubePlayer player, int eventId, Bundle bundle) {
        if (player == null) {
            LiteavLog.w(TAG, "sendPlayerEventToPlugin invalid param player is null !!!");
            return;
        }
        if (!this.canRenderProcessWork(player)) {
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        hashMap.put("KEY_PARAM2", eventId);
        hashMap.put("KEY_PARAM3", bundle);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 106, hashMap, null);
    }

    public boolean onTouchEvent(ITXVCubePlayer player, MotionEvent motionEvent) {
        if (!this.canRenderProcessWork(player)) {
            return false;
        }
        if (this.mCurrentModel != 11 && this.mCurrentModel != 12) {
            return false;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        hashMap.put("KEY_PARAM2", motionEvent);
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 105, hashMap, hashMap2);
        boolean bl = false;
        Object v2 = hashMap2.get("KEY_RET_PARAM1");
        if (v2 != null && v2 instanceof Boolean) {
            bl = (Boolean)v2;
        }
        return bl;
    }

    public void doAction(ITXVCubePlayer player, String key, Object value) {
        if (player == null) {
            LiteavLog.w(TAG, "doAction invalid param player or surface is null !!!");
            return;
        }
        if (!this.canRenderProcessWork(player)) {
            LiteavLog.w(TAG, "doAction\uff0cpostProcessService does not need to work");
            return;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("KEY_PARAM1", player);
        hashMap.put("KEY_PARAM2", key);
        if (value != null) {
            hashMap.put("KEY_PARAM3", value);
        }
        HostEngine.getInstance().sendSyncRequestToPlugin(2, 107, hashMap, null);
    }

    public void postEventWithPlayer(ITXVCubePlayer player, int eventId, Bundle bundle) {
        IRenderServiceEventListener iRenderServiceEventListener;
        if (player == null) {
            return;
        }
        WeakReference<IRenderServiceEventListener> weakReference = this.mEventListenerMap.get(player);
        if (weakReference != null && (iRenderServiceEventListener = (IRenderServiceEventListener)weakReference.get()) != null) {
            iRenderServiceEventListener.onRenderServiceEvent(player, eventId, bundle);
        }
    }

    public void setRenderServiceEventListener(ITXVCubePlayer player, IRenderServiceEventListener listener) {
        if (player != null) {
            if (listener != null) {
                this.mEventListenerMap.put(player, new WeakReference<IRenderServiceEventListener>(listener));
                return;
            }
            this.mEventListenerMap.remove(player);
        }
    }

    public static interface IRenderServiceEventListener {
        public void onRenderServiceEvent(ITXVCubePlayer var1, int var2, Bundle var3);
    }
}

