/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.thumbplayer;

import android.util.Log;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.thumbplayer.ThumbMediaPlayer;
import com.tencent.thumbplayer.tcmedia.api.ITPPlayer;
import com.tencent.thumbplayer.tcmedia.api.ITPPlayerListener;
import com.tencent.thumbplayer.tcmedia.api.TPAudioFrameBuffer;
import com.tencent.thumbplayer.tcmedia.api.TPPlayerMsg;
import com.tencent.thumbplayer.tcmedia.api.TPPostProcessFrameBuffer;
import com.tencent.thumbplayer.tcmedia.api.TPSubtitleData;
import com.tencent.thumbplayer.tcmedia.api.TPSubtitleFrameBuffer;
import com.tencent.thumbplayer.tcmedia.api.TPVideoFrameBuffer;

class ThumbMediaPlayerListener
implements ITPPlayerListener.IOnAudioFrameOutputListener,
ITPPlayerListener.IOnAudioProcessFrameOutputListener,
ITPPlayerListener.IOnCompletionListener,
ITPPlayerListener.IOnErrorListener,
ITPPlayerListener.IOnInfoListener,
ITPPlayerListener.IOnPreparedListener,
ITPPlayerListener.IOnSeekCompleteListener,
ITPPlayerListener.IOnStateChangeListener,
ITPPlayerListener.IOnStopAsyncCompleteListener,
ITPPlayerListener.IOnSubtitleDataListener,
ITPPlayerListener.IOnSubtitleFrameOutListener,
ITPPlayerListener.IOnVideoFrameOutListener,
ITPPlayerListener.IOnVideoProcessFrameOutputListener,
ITPPlayerListener.IOnVideoSizeChangedListener {
    private final ThumbMediaPlayer mThumbMediaPlayer;
    private final String TAG = ThumbMediaPlayerListener.class.getName();
    private static final int ERROR_DEMUXER_PREPARE_TIMEOUT = 1104;

    public ThumbMediaPlayerListener(ThumbMediaPlayer thumbMediaPlayer) {
        this.mThumbMediaPlayer = thumbMediaPlayer;
    }

    void attachToPlayer() {
        ITPPlayer iTPPlayer;
        ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
        if (thumbMediaPlayer != null && (iTPPlayer = thumbMediaPlayer.getTPPPlayer()) != null) {
            iTPPlayer.setOnPreparedListener(this);
            iTPPlayer.setOnCompletionListener(this);
            iTPPlayer.setOnInfoListener(this);
            iTPPlayer.setOnErrorListener(this);
            iTPPlayer.setOnSeekCompleteListener(this);
            iTPPlayer.setOnVideoSizeChangedListener(this);
            iTPPlayer.setOnSubtitleDataListener(this);
            iTPPlayer.setOnSubtitleFrameOutListener(this);
            iTPPlayer.setOnVideoFrameOutListener(this);
            iTPPlayer.setOnAudioFrameOutputListener(this);
            iTPPlayer.setOnVideoProcessFrameOutputListener(this);
            iTPPlayer.setOnAudioProcessFrameOutputListener(this);
            iTPPlayer.setOnPlayerStateChangeListener(this);
            iTPPlayer.setOnStopAsyncCompleteListener(this);
        }
    }

    @Override
    public void onPrepared(ITPPlayer player) {
        this.innerLogI("onPrepared");
        ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
        if (thumbMediaPlayer != null) {
            thumbMediaPlayer.notifyOnPrepared();
        }
    }

    @Override
    public void onCompletion(ITPPlayer player) {
        ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
        if (thumbMediaPlayer != null) {
            thumbMediaPlayer.notifyOnCompletion();
        }
    }

    @Override
    public void onVideoSizeChanged(ITPPlayer player, long width, long height) {
        ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
        if (thumbMediaPlayer != null) {
            this.innerLogI("onVideoSizeChanged width: " + width + " ,height: " + height);
            thumbMediaPlayer.notifyOnVideoSizeChanged((int)width, (int)height, thumbMediaPlayer.getVideoSarNum(), thumbMediaPlayer.getVideoSarDen(), null);
        }
    }

    @Override
    public void onInfo(ITPPlayer player, int what, long arg1, long arg2, Object extraObject) {
        ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
        if (thumbMediaPlayer != null) {
            Object object;
            int n2 = this.transferInfo(what);
            int n3 = (int)arg1;
            if (extraObject != null && extraObject instanceof TPPlayerMsg.TPCDNURLInfo) {
                object = (TPPlayerMsg.TPCDNURLInfo)extraObject;
                this.innerLogI("onInfo TPCDNURLInfo:cdnIp:" + ((TPPlayerMsg.TPCDNURLInfo)object).cdnIp + ":uIp:" + ((TPPlayerMsg.TPCDNURLInfo)object).uIp + ": url: " + ((TPPlayerMsg.TPCDNURLInfo)object).url + ":errorStr: " + ((TPPlayerMsg.TPCDNURLInfo)object).errorStr);
            }
            if (extraObject != null && extraObject instanceof TPPlayerMsg.TPDownLoadProgressInfo) {
                String[] stringArray;
                object = (TPPlayerMsg.TPDownLoadProgressInfo)extraObject;
                long l2 = ((TPPlayerMsg.TPDownLoadProgressInfo)object).totalFileSize;
                thumbMediaPlayer.updateBitrate(l2);
                long l3 = ((TPPlayerMsg.TPDownLoadProgressInfo)object).downloadSpeedKBps;
                if (l3 < 0L && ((TPPlayerMsg.TPDownLoadProgressInfo)object).extraInfo != null && (stringArray = ((TPPlayerMsg.TPDownLoadProgressInfo)object).extraInfo.split(",")) != null) {
                    String[] stringArray2 = stringArray;
                    int n4 = stringArray.length;
                    for (int i2 = 0; i2 < n4; ++i2) {
                        String string = stringArray2[i2];
                        if (string == null || !string.contains("httpAvgSpeedKB")) continue;
                        String string2 = string;
                        l3 = Long.valueOf(string2.substring(string2.indexOf(":") + 1, string.length()).trim());
                        break;
                    }
                }
                thumbMediaPlayer.updateTcpSpeed(l3 * 1024L);
            }
            if (extraObject instanceof TPPlayerMsg.TPVideoCropInfo) {
                object = (TPPlayerMsg.TPVideoCropInfo)extraObject;
                this.innerLogI("onInfo TPVideoCropInfo:cropBottom:" + ((TPPlayerMsg.TPVideoCropInfo)object).cropBottom + ":cropLeft:" + ((TPPlayerMsg.TPVideoCropInfo)object).cropLeft + ": cropRight: " + ((TPPlayerMsg.TPVideoCropInfo)object).cropRight + ":cropTop: " + ((TPPlayerMsg.TPVideoCropInfo)object).cropTop + ":height:" + ((TPPlayerMsg.TPVideoCropInfo)object).height + ":width:" + ((TPPlayerMsg.TPVideoCropInfo)object).width);
            }
            thumbMediaPlayer.notifyOnInfo(n2, n3, (int)arg2, extraObject);
        }
    }

    private int transferInfo(int what) {
        int n2 = -1;
        switch (what) {
            case 104: {
                n2 = 2008;
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
                if (thumbMediaPlayer == null) break;
                thumbMediaPlayer.onReceiveFirstVideoRenderEvent();
                break;
            }
            case 107: {
                ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
                if (thumbMediaPlayer == null) break;
                thumbMediaPlayer.onReceiveFirstPacketReadEvent();
                break;
            }
            case 200: {
                n2 = 2007;
                break;
            }
            case 201: {
                n2 = 2014;
                break;
            }
            case 1001: {
                this.innerLogI("TP_PLAYER_INFO_LONG0_ALL_DOWNLOAD_FINISH");
                ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
                if (thumbMediaPlayer == null) break;
                thumbMediaPlayer.updateTcpSpeed(0L);
                break;
            }
            case 1006: {
                n2 = 1006;
                break;
            }
            case 4: {
                n2 = 2020;
                break;
            }
            case 1018: {
                n2 = 2002;
                break;
            }
            case 503: {
                n2 = 2030;
            }
        }
        return n2;
    }

    @Override
    public void onError(ITPPlayer player, int errorType, int errorCode, long arg1, long arg2) {
        try {
            if (errorType != 1000) {
                this.innerLogE("onError type: " + errorType + " code: " + errorCode + " arg1: " + arg1 + " arg2: " + arg2);
                ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
                if (thumbMediaPlayer != null) {
                    int n2 = this.transferError(errorType, errorCode);
                    thumbMediaPlayer.notifyOnError(n2, errorCode);
                }
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throwable.printStackTrace();
            this.innerLogE("onError, e= " + Log.getStackTraceString((Throwable)throwable2));
            return;
        }
    }

    private int transferError(int errorType, int errorCode) {
        int n2 = -6002;
        switch (errorType) {
            case 2000: {
                n2 = -6004;
                break;
            }
            case 2001: {
                n2 = -2301;
                break;
            }
            case 1001: {
                n2 = -6002;
                if (errorCode != 11010104) break;
                n2 = -2305;
                break;
            }
            case 1100: 
            case 1102: {
                n2 = -6003;
                if (errorCode < 11070000 || errorCode >= 11080000) break;
                n2 = -6101;
                break;
            }
            case 1200: 
            case 1220: 
            case 1221: {
                String string;
                ThumbMediaPlayer thumbMediaPlayer;
                n2 = -6006;
                if (errorType != 1220 || (thumbMediaPlayer = this.mThumbMediaPlayer) == null || (string = thumbMediaPlayer.getTPPPlayer().getPropertyString(0)) == null || !string.toLowerCase().contains("hevc") && !string.toLowerCase().contains("h265")) break;
                n2 = -2304;
                break;
            }
            case 1103: 
            case 1104: {
                n2 = -6005;
                break;
            }
            case 1210: 
            case 1211: {
                n2 = -6007;
                break;
            }
            case 1600: {
                n2 = -6010;
                break;
            }
            case 1230: 
            case 1231: {
                n2 = -6008;
                break;
            }
            case 1300: {
                n2 = -6009;
                break;
            }
            case 4000: {
                n2 = -6011;
            }
        }
        this.innerLogI("[transferError], errorType: " + errorType + " ,errorCode: " + errorCode + " ,vodErrorEvent: " + n2);
        return n2;
    }

    @Override
    public void onSeekComplete(ITPPlayer player) {
        this.innerLogI(" onSeekComplete");
        ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
        if (thumbMediaPlayer != null) {
            thumbMediaPlayer.notifyOnSeekComplete();
        }
    }

    @Override
    public void onAudioFrameOut(ITPPlayer player, TPAudioFrameBuffer tpAudioFrameBuffer) {
    }

    @Override
    public TPPostProcessFrameBuffer onAudioProcessFrameOut(ITPPlayer player, TPPostProcessFrameBuffer tpPostProcessFrameBuffer) {
        return tpPostProcessFrameBuffer;
    }

    @Override
    public void onStateChange(int preState, int curState) {
    }

    @Override
    public void onStopAsyncComplete(ITPPlayer player) {
    }

    @Override
    public void onSubtitleData(ITPPlayer player, TPSubtitleData tpSubtitleData) {
        ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
        if (thumbMediaPlayer != null && tpSubtitleData != null) {
            thumbMediaPlayer.notifyOnSubtitleData(tpSubtitleData);
        }
    }

    @Override
    public void onSubtitleFrameOut(ITPPlayer player, TPSubtitleFrameBuffer tpSubtitleFrameBuffer) {
        ThumbMediaPlayer thumbMediaPlayer = this.mThumbMediaPlayer;
        if (thumbMediaPlayer != null) {
            thumbMediaPlayer.notifySubtitleFrameData(tpSubtitleFrameBuffer);
        }
    }

    @Override
    public void onVideoFrameOut(ITPPlayer player, TPVideoFrameBuffer tpVideoFrameBuffer) {
    }

    @Override
    public TPPostProcessFrameBuffer onVideoProcessFrameOut(ITPPlayer player, TPPostProcessFrameBuffer tpPostProcessFrameBuffer) {
        return tpPostProcessFrameBuffer;
    }

    private void innerLogI(String message) {
        LiteavLog.i(this.TAG, "[" + this.hashCode() + "], " + message);
    }

    private void innerLogE(String message) {
        LiteavLog.e(this.TAG, "[" + this.hashCode() + "], " + message);
    }
}

