/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.extensions;

import android.content.res.AssetManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.util.LiteavLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class AssetsUtils {
    public static boolean hasAssetFile(String assetsPath) {
        AssetManager assetManager = ContextUtils.getApplicationAssets();
        try {
            InputStream inputStream = assetManager.open(assetsPath);
            boolean bl = inputStream != null;
            inputStream.close();
            return bl;
        }
        catch (IOException iOException) {
            LiteavLog.i("virtual-background", "hasAssetFile error: " + iOException.getMessage());
            return false;
        }
    }

    public static boolean copyAssetFile(String fileName, String targetPath) {
        AssetManager assetManager = ContextUtils.getApplicationAssets();
        try {
            int n2;
            File file = new File(targetPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            byte[] byArray = new byte[1024];
            InputStream inputStream = assetManager.open(fileName);
            File file2 = new File(targetPath + File.separator + fileName + ".tmp");
            if (!file2.exists()) {
                file2.createNewFile();
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            while ((n2 = inputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.flush();
            inputStream.close();
            fileOutputStream.close();
            File file3 = new File(targetPath + File.separator + fileName);
            if (!file2.renameTo(file3)) {
                file2.delete();
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            LiteavLog.i("virtual-background", "copyAssetFile error: " + iOException.getMessage());
            return false;
        }
    }
}

