/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.jmx.SigarProcess;
import org.hyperic.sigar.jmx.SigarRegistry;

public class Mx
extends SigarCommandBase {
    private ObjectName registryName;

    public Mx(Shell shell) {
        super(shell);
    }

    public Mx() {
    }

    public String getUsageShort() {
        return "Register MBeans for use via jconsole, etc.";
    }

    protected boolean validateArgs(String[] args) {
        return args.length <= 1;
    }

    public static MBeanServer getMBeanServer() throws SigarException {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        if (servers.size() == 0) {
            throw new SigarException("No MBeanServers available");
        }
        return (MBeanServer)servers.get(0);
    }

    private void register(MBeanServer server) throws SigarException {
        if (this.registryName != null) {
            return;
        }
        try {
            String name = SigarRegistry.class.getName();
            this.registryName = server.createMBean(name, null).getObjectName();
            SigarProcess proc = new SigarProcess(this.sigar);
            ObjectName pname = new ObjectName(proc.getObjectName());
            if (!server.isRegistered(pname)) {
                server.registerMBean(proc, pname);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SigarException(e.getMessage());
        }
    }

    private void jconsole() {
        String pid = String.valueOf(this.sigar.getPid());
        String[] argv = new String[]{"jconsole", pid};
        this.println("exec(jconsole, " + pid + ")");
        try {
            Process p = Runtime.getRuntime().exec(argv);
            p.waitFor();
            this.println("jconsole exited");
        }
        catch (Exception e) {
            this.println(e.getMessage());
        }
    }

    public void output(String[] args) throws SigarException {
        MBeanServer server = Mx.getMBeanServer();
        this.register(server);
        boolean hasQuery = false;
        boolean launchJconsole = false;
        String query = "sigar:*";
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-jconsole")) {
                launchJconsole = true;
                continue;
            }
            query = arg;
            hasQuery = true;
        }
        try {
            Set<ObjectName> beans = server.queryNames(new ObjectName(query), null);
            this.println(beans.size() + " MBeans are registered...");
            Iterator<ObjectName> it = beans.iterator();
            while (it.hasNext()) {
                ObjectName name = it.next();
                if (hasQuery) {
                    MBeanInfo info = server.getMBeanInfo(name);
                    MBeanAttributeInfo[] attrs = info.getAttributes();
                    for (int i = 0; i < attrs.length; ++i) {
                        String attr = attrs[i].getName();
                        Object val = server.getAttribute(name, attr);
                        this.println(name + ":" + attr + "=" + val);
                    }
                    continue;
                }
                this.println(name.toString());
            }
        }
        catch (Exception e) {
            throw new SigarException(e.getMessage());
        }
        if (launchJconsole) {
            this.flush();
            this.jconsole();
            try {
                server.unregisterMBean(this.registryName);
                this.registryName = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new Mx().processCommand(args);
    }
}

