/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.object.UploadPartResult;
import com.tencent.qcloud.core.network.QCloudProgressListener;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import com.tencent.qcloud.core.network.request.serializer.RequestBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestByteArraySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestFileBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestStreamBodySerializer;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;

public final class UploadPartRequest
extends CosXmlRequest {
    private int partNumber;
    private String uploadId;
    private String cosPath;
    private String srcPath;
    private byte[] data;
    private InputStream inputStream;
    private long fileLength;
    private long fileOffset;
    private long fileContentLength;
    private QCloudProgressListener progressListener;

    public UploadPartRequest(String bucket, String cosPath, int partNumber, String srcPath, String uploadId) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.partNumber = partNumber;
        this.srcPath = srcPath;
        this.uploadId = uploadId;
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.fileOffset = -1L;
        this.fileContentLength = -1L;
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, String srcPath, long offset, long length, String uploadId) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.partNumber = partNumber;
        this.setSrcPath(srcPath, offset, length);
        this.uploadId = uploadId;
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, byte[] data, String uploadId) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.partNumber = partNumber;
        this.data = data;
        this.uploadId = uploadId;
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.fileOffset = -1L;
        this.fileContentLength = -1L;
    }

    public UploadPartRequest(String bucket, String cosPath, int partNumber, InputStream inputStream, long sendLength, String uploadId) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.partNumber = partNumber;
        this.inputStream = inputStream;
        this.fileLength = sendLength;
        this.uploadId = uploadId;
        this.contentType = "text/plain";
        this.requestHeaders.put("Content-Type", this.contentType);
        this.fileOffset = -1L;
        this.fileContentLength = -1L;
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_LOW;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.srcPath != null) {
            RequestFileBodySerializer requestFileBodySerializer = new RequestFileBodySerializer(this.srcPath, "text/plain", this.fileOffset, this.fileContentLength);
            requestFileBodySerializer.setProgressListener(this.progressListener);
            this.requestOriginBuilder.body((RequestBodySerializer)requestFileBodySerializer);
        } else if (this.data != null) {
            RequestByteArraySerializer requestByteArraySerializer = new RequestByteArraySerializer(this.data, "text/plain");
            requestByteArraySerializer.setProgressListener(this.progressListener);
            this.requestOriginBuilder.body((RequestBodySerializer)requestByteArraySerializer);
        } else if (this.inputStream != null) {
            RequestStreamBodySerializer requestStreamBodySerializer = new RequestStreamBodySerializer(this.inputStream, this.fileLength, "text/plain");
            requestStreamBodySerializer.setProgressListener(this.progressListener);
            this.requestOriginBuilder.body((RequestBodySerializer)requestStreamBodySerializer);
        }
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(UploadPartResult.class);
    }

    public void setPartNumber(int partNumber) {
        this.partNumber = partNumber;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public void setUploadId(String uploadId) {
        this.uploadId = uploadId;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("partNumber", String.valueOf(this.partNumber));
        this.requestQueryParams.put("uploadID", this.uploadId);
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        File file;
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
        if (this.partNumber <= 0) {
            throw new CosXmlClientException("partNumber must be >= 1");
        }
        if (this.uploadId == null) {
            throw new CosXmlClientException("uploadID must not be null");
        }
        if (this.cosPath == null) {
            throw new CosXmlClientException("cosPath must not be null");
        }
        if (this.srcPath == null && this.data == null && this.inputStream == null) {
            throw new CosXmlClientException("Data Source must not be null");
        }
        if (this.srcPath != null && !(file = new File(this.srcPath)).exists()) {
            throw new CosXmlClientException("upload file does not exist");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "PUT";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public void setSrcPath(String srcPath, long fileOffset, long contentLength) {
        this.srcPath = srcPath;
        this.fileOffset = fileOffset;
        this.fileContentLength = contentLength;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setInputStream(InputStream inputStream, long fileLength) {
        this.inputStream = inputStream;
        this.fileLength = fileLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getFileLength() {
        if (this.inputStream != null) {
            return this.fileLength;
        }
        if (this.data != null) {
            return this.data.length;
        }
        if (this.srcPath != null) {
            if (this.fileOffset != -1L) {
                return this.fileContentLength - this.fileOffset;
            }
            return new File(this.srcPath).length();
        }
        return -1L;
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }
}

