/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.object;

import com.tencent.cos.xml.common.COSACL;
import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.object.AppendObjectResult;
import com.tencent.cos.xml.model.tag.ACLAccounts;
import com.tencent.qcloud.core.network.QCloudProgressListener;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import com.tencent.qcloud.core.network.request.serializer.RequestBodySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestByteArraySerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestFormDataSerializer;
import com.tencent.qcloud.core.network.request.serializer.RequestStreamBodySerializer;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;

public final class AppendObjectRequest
extends CosXmlRequest {
    private long position = 0L;
    private String cosPath;
    private String srcPath;
    private byte[] data;
    private InputStream inputStream;
    private long fileLength;
    private QCloudProgressListener progressListener;

    public AppendObjectRequest(String bucket, String cosPath, String srcPath, long position) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.srcPath = srcPath;
        this.position = position;
        this.contentType = "multipart/form-data";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    public AppendObjectRequest(String bucket, String cosPath, byte[] data, long position) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.data = data;
        this.position = position;
        this.contentType = "multipart/form-data";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    public AppendObjectRequest(String bucket, String cosPath, InputStream inputStream, long sendLength, long position) {
        this.bucket = bucket;
        this.cosPath = cosPath;
        this.inputStream = inputStream;
        this.fileLength = sendLength;
        this.position = position;
        this.contentType = "multipart/form-data";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_LOW;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.srcPath != null) {
            RequestFormDataSerializer requestFormDataSerializer = new RequestFormDataSerializer();
            requestFormDataSerializer.setProgressListener(this.progressListener);
            requestFormDataSerializer.uploadFile(this.srcPath, "file");
            this.requestOriginBuilder.body((RequestBodySerializer)requestFormDataSerializer);
        } else if (this.data != null) {
            RequestByteArraySerializer requestByteArraySerializer = new RequestByteArraySerializer(this.data, "text/plain");
            requestByteArraySerializer.setProgressListener(this.progressListener);
            this.requestOriginBuilder.body((RequestBodySerializer)requestByteArraySerializer);
        } else if (this.inputStream != null) {
            RequestStreamBodySerializer requestStreamBodySerializer = new RequestStreamBodySerializer(this.inputStream, this.fileLength, "text/plain");
            requestStreamBodySerializer.setProgressListener(this.progressListener);
            this.requestOriginBuilder.body((RequestBodySerializer)requestStreamBodySerializer);
        }
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(AppendObjectResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        this.requestQueryParams.put("append", null);
        this.requestQueryParams.put("position", String.valueOf(this.position));
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        File file;
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
        if (this.cosPath == null) {
            throw new CosXmlClientException("cosPath must not be null");
        }
        if (this.srcPath == null && this.data == null && this.inputStream == null) {
            throw new CosXmlClientException("Data Source must not be null");
        }
        if (this.srcPath != null && !(file = new File(this.srcPath)).exists()) {
            throw new CosXmlClientException("upload file does not exist");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "POST";
    }

    @Override
    protected void setRequestPath() {
        if (this.cosPath != null) {
            this.requestPath = !this.cosPath.startsWith("/") ? "/" + this.cosPath : this.cosPath;
        }
    }

    public void setPosition(long position) {
        if (position < 0L) {
            this.position = 0L;
        }
        this.position = position;
    }

    public long getPosition() {
        return this.position;
    }

    public void setCosPath(String cosPath) {
        this.cosPath = cosPath;
    }

    public String getCosPath() {
        return this.cosPath;
    }

    public void setSrcPath(String srcPath) {
        this.srcPath = srcPath;
    }

    public String getSrcPath() {
        return this.srcPath;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setInputStream(InputStream inputStream, long fileLength) {
        this.inputStream = inputStream;
        this.fileLength = fileLength;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public void setProgressListener(QCloudProgressListener progressListener) {
        this.progressListener = progressListener;
    }

    public QCloudProgressListener getProgressListener() {
        return this.progressListener;
    }

    public void setCacheControl(String cacheControl) {
        if (cacheControl == null) {
            return;
        }
        this.requestHeaders.put("Cache-Control", cacheControl);
    }

    public void setContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return;
        }
        this.requestHeaders.put("Content-Disposition", contentDisposition);
    }

    public void setContentEncodeing(String contentEncoding) {
        if (contentEncoding == null) {
            return;
        }
        this.requestHeaders.put("Content-Encoding", contentEncoding);
    }

    public void setExpires(String expires) {
        if (expires == null) {
            return;
        }
        this.requestHeaders.put("Expires", expires);
    }

    public void setXCOSMeta(String key, String value) {
        if (key != null && value != null) {
            this.requestHeaders.put(key, value);
        }
    }

    public void setXCOSACL(String cosacl) {
        if (cosacl != null) {
            this.requestHeaders.put("x-cos-acl", cosacl);
        }
    }

    public void setXCOSACL(COSACL cosacl) {
        if (cosacl != null) {
            this.requestHeaders.put("x-cos-acl", cosacl.getACL());
        }
    }

    public void setXCOSGrantRead(ACLAccounts aclAccounts) {
        if (aclAccounts != null) {
            this.requestHeaders.put("x-cos-grant-read", aclAccounts.aclDesc());
        }
    }

    public void setXCOSGrantWrite(ACLAccounts aclAccounts) {
        if (aclAccounts != null) {
            this.requestHeaders.put("x-cos-grant-write", aclAccounts.aclDesc());
        }
    }

    public void setXCOSReadWrite(ACLAccounts aclAccounts) {
        if (aclAccounts != null) {
            this.requestHeaders.put("x-cos-grant-full-control", aclAccounts.aclDesc());
        }
    }
}

