/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cos.xml.model.bucket;

import com.tencent.cos.xml.exception.CosXmlClientException;
import com.tencent.cos.xml.model.CosXmlRequest;
import com.tencent.cos.xml.model.ResponseXmlS3BodySerializer;
import com.tencent.cos.xml.model.bucket.GetBucketResult;
import com.tencent.qcloud.core.network.QCloudRequestPriority;
import java.util.Iterator;
import java.util.Map;

public final class GetBucketRequest
extends CosXmlRequest {
    private String prefix = null;
    private String delimiter = null;
    private String encodingType;
    private String marker = null;
    private String maxKeys = "1000";

    public GetBucketRequest(String bucket) {
        this.bucket = bucket;
        this.contentType = "application/x-www-form-urlencoded";
        this.requestHeaders.put("Content-Type", this.contentType);
    }

    @Override
    protected void build() throws CosXmlClientException {
        Map.Entry entry;
        Map.Entry object;
        Iterator iterator;
        super.build();
        this.priority = QCloudRequestPriority.Q_CLOUD_REQUEST_PRIORITY_NORMAL;
        this.setRequestMethod();
        this.requestOriginBuilder.method(this.requestMethod);
        this.setRequestPath();
        this.requestOriginBuilder.pathAddRear(this.requestPath);
        this.requestOriginBuilder.hostAddFront(this.bucket);
        this.setRequestQueryParams();
        if (this.requestQueryParams.size() > 0) {
            iterator = this.requestQueryParams.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.query((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.requestHeaders.size() > 0) {
            iterator = this.requestHeaders.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = object = iterator.next();
                this.requestOriginBuilder.header((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.responseBodySerializer = new ResponseXmlS3BodySerializer(GetBucketResult.class);
    }

    @Override
    protected void setRequestQueryParams() {
        if (this.prefix != null) {
            this.requestQueryParams.put("prefix", this.prefix);
        }
        if (this.delimiter != null) {
            this.requestQueryParams.put("delimiter", this.delimiter);
        }
        if (this.encodingType != null) {
            this.requestQueryParams.put("encoding-type", this.encodingType);
        }
        if (this.marker != null) {
            this.requestQueryParams.put("marker", this.marker);
        }
        if (this.maxKeys != null) {
            this.requestQueryParams.put("max-keys", this.maxKeys);
        }
        if (this.prefix != null) {
            this.requestQueryParams.put("prefix", this.prefix);
        }
    }

    @Override
    protected void checkParameters() throws CosXmlClientException {
        if (this.bucket == null) {
            throw new CosXmlClientException("bucket must not be null");
        }
    }

    @Override
    protected void setRequestMethod() {
        this.requestMethod = "GET";
    }

    @Override
    protected void setRequestPath() {
        this.requestPath = "/";
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = String.valueOf(delimiter);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setEncodingType(String encodingType) {
        this.encodingType = encodingType;
    }

    public String getEncodingType() {
        return this.encodingType;
    }

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public void setMaxKeys(long maxKeys) {
        this.maxKeys = String.valueOf(maxKeys);
    }

    public long getMaxKeys() {
        return Long.parseLong(this.maxKeys);
    }
}

