/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rmonitor.looper.provider;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import com.tencent.bugly.proguard.kb;
import com.tencent.bugly.proguard.mx;
import com.tencent.rmonitor.base.thread.suspend.ThreadSuspend;
import com.tencent.rmonitor.common.logger.Logger;
import com.tencent.rmonitor.looper.MonitorInfo;
import com.tencent.rmonitor.looper.listener.IMonitorCallback;
import com.tencent.rmonitor.looper.provider.BaseStackProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u0000 +2\u00020\u00012\u00020\u0002:\u0001+B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J \u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H&J\n\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0004J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rJ#\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!H&\u00a2\u0006\u0002\u0010#J\b\u0010$\u001a\u00020\u000bH\u0016J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010)\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/tencent/rmonitor/looper/provider/MultiStackProvider;", "Lcom/tencent/rmonitor/looper/provider/BaseStackProvider;", "Landroid/os/Handler$Callback;", "()V", "lastStackRequestTime", "", "monitorCallBack", "Lcom/tencent/rmonitor/looper/listener/IMonitorCallback;", "stackThreadHandler", "Landroid/os/Handler;", "beginTrace", "", "monitorInfo", "Lcom/tencent/rmonitor/looper/MonitorInfo;", "dispatchEnd", "endTime", "duration", "dispatchStart", "startTime", "endTrace", "isOverThreshold", "", "getStackThreadHandler", "handleCollectCompleted", "handleCollectStart", "handleMessage", "msg", "Landroid/os/Message;", "init", "callback", "isCurrentMsg", "onTrace", "stackTrace", "", "Ljava/lang/StackTraceElement;", "(Lcom/tencent/rmonitor/looper/MonitorInfo;[Ljava/lang/StackTraceElement;)V", "release", "removeMonitorMessage", "what", "", "sendMonitorMessage", "sendMonitorMessageDelay", "delay", "Companion", "bugly-pro_release"})
public abstract class MultiStackProvider
extends BaseStackProvider
implements Handler.Callback {
    private Handler stackThreadHandler;
    private IMonitorCallback monitorCallBack;
    private long lastStackRequestTime;
    @NotNull
    public static final String TAG = "RMonitor_looper_StackProvider";
    public static final int MSG_COLLECT_START = 1;
    public static final int MSG_COLLECT_COMPLETED = 2;
    public static final long LONG_LAG_LIMIT = 5000L;
    public static final Companion Companion = new Companion(0);

    @Override
    public boolean init(@NotNull IMonitorCallback iMonitorCallback) {
        Intrinsics.checkParameterIsNotNull((Object)iMonitorCallback, (String)"callback");
        this.monitorCallBack = iMonitorCallback;
        boolean bl2 = false;
        try {
            Looper looper = mx.e(this.getLooperThread());
            if (looper != null) {
                Looper looper2 = looper;
                this.stackThreadHandler = new Handler(looper2, (Handler.Callback)this);
                bl2 = true;
            }
        }
        catch (Exception exception) {
            Logger.INSTANCE.e(TAG, "prepare stack provider fail for exception {" + exception + '}');
        }
        return bl2;
    }

    @Override
    public void release() {
        Handler handler = this.stackThreadHandler;
        if (handler != null) {
            handler.removeCallbacksAndMessages(null);
        }
        this.stackThreadHandler = null;
        mx.f(this.getLooperThread());
        this.monitorCallBack = null;
    }

    @Override
    public void dispatchStart(@NotNull MonitorInfo monitorInfo, long l2) {
        Intrinsics.checkParameterIsNotNull((Object)monitorInfo, (String)"monitorInfo");
        this.lastStackRequestTime = monitorInfo.getLastStackRequestTime();
        this.beginTrace(monitorInfo);
        this.sendMonitorMessageDelay(1, monitorInfo, this.getLagParam().CO);
    }

    @Override
    public void dispatchEnd(@NotNull MonitorInfo monitorInfo, long l2, long l3) {
        Intrinsics.checkParameterIsNotNull((Object)monitorInfo, (String)"monitorInfo");
        this.removeMonitorMessage(1, monitorInfo);
        if (l3 >= this.getLagParam().threshold) {
            this.appendData(monitorInfo);
            this.sendMonitorMessage(2, monitorInfo.copy());
        } else {
            this.endTrace(monitorInfo, false);
        }
        this.lastStackRequestTime = 0L;
    }

    public final boolean isCurrentMsg(@NotNull MonitorInfo monitorInfo) {
        Intrinsics.checkParameterIsNotNull((Object)monitorInfo, (String)"monitorInfo");
        return this.lastStackRequestTime != 0L && this.lastStackRequestTime == monitorInfo.getLastStackRequestTime();
    }

    private final void handleCollectStart(MonitorInfo monitorInfo) {
        if (!this.isCurrentMsg(monitorInfo)) {
            Logger.INSTANCE.d(TAG, "handleCollectStart, deal msg not latest msg before trace, latest: " + this.lastStackRequestTime + ", deal: " + monitorInfo.getLastStackRequestTime());
            return;
        }
        this.appendData(monitorInfo);
        long l2 = System.currentTimeMillis() - monitorInfo.getLastStackRequestTime();
        if (l2 > this.getLagParam().CN) {
            MonitorInfo monitorInfo2;
            long l3 = 5000L - l2;
            monitorInfo = monitorInfo2 = monitorInfo.copy();
            long l4 = Math.max(5000L, l2);
            monitorInfo.setDuration(l4);
            monitorInfo2.setDetectedLongLag(true);
            if (l3 <= 0L) {
                this.handleCollectCompleted(monitorInfo2);
                return;
            }
            this.sendMonitorMessageDelay(2, monitorInfo2, l3);
            return;
        }
        Thread thread = this.getLooperThread();
        if (thread != null && thread.isAlive()) {
            try {
                long l5 = 0L;
                if (this.shouldSuspendBeforeGetStack()) {
                    l5 = ThreadSuspend.fT().d(thread);
                }
                StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
                if (l5 != 0L) {
                    ThreadSuspend.fT().u(l5);
                }
                if (this.isCurrentMsg(monitorInfo)) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElementArray, (String)"stackTrace");
                    this.onTrace(monitorInfo, stackTraceElementArray);
                    this.sendMonitorMessageDelay(1, monitorInfo, this.getLagParam().CO);
                    return;
                }
                Logger.INSTANCE.d(TAG, "handleCollectStart, deal msg not latest msg after trace, latest: " + this.lastStackRequestTime + ", deal: " + monitorInfo.getLastStackRequestTime());
                return;
            }
            catch (Throwable throwable) {
                Logger.INSTANCE.e(TAG, "on trace fail for ".concat(String.valueOf(throwable)));
            }
        }
    }

    private final void handleCollectCompleted(MonitorInfo monitorInfo) {
        this.endTrace(monitorInfo, true);
        IMonitorCallback iMonitorCallback = this.monitorCallBack;
        if (iMonitorCallback != null) {
            iMonitorCallback.onAfterStack(monitorInfo);
            return;
        }
    }

    public boolean handleMessage(@NotNull Message message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"msg");
        Object object = message.obj;
        if (!(object instanceof MonitorInfo)) {
            object = null;
        }
        MonitorInfo monitorInfo = (MonitorInfo)object;
        if (monitorInfo == null) {
            return false;
        }
        MonitorInfo monitorInfo2 = monitorInfo;
        switch (message.what) {
            case 1: {
                long l2 = SystemClock.uptimeMillis();
                long l3 = kb.gp();
                this.handleCollectStart(monitorInfo2);
                long l4 = kb.gp() - l3;
                monitorInfo2.addCollectStackMsgSample(l2 - message.getWhen(), l4);
                break;
            }
            case 2: {
                this.handleCollectCompleted(monitorInfo2);
            }
        }
        return true;
    }

    private final void sendMonitorMessage(int n2, MonitorInfo monitorInfo) {
        Message message = Message.obtain();
        Message.obtain().what = n2;
        message.obj = monitorInfo;
        Handler handler = this.stackThreadHandler;
        if (handler != null) {
            handler.sendMessage(message);
            return;
        }
    }

    private final void sendMonitorMessageDelay(int n2, MonitorInfo monitorInfo, long l2) {
        Message message = Message.obtain();
        Message.obtain().what = n2;
        message.obj = monitorInfo;
        Handler handler = this.stackThreadHandler;
        if (handler != null) {
            handler.sendMessageDelayed(message, l2);
            return;
        }
    }

    private final void removeMonitorMessage(int n2, MonitorInfo monitorInfo) {
        Handler handler = this.stackThreadHandler;
        if (handler != null) {
            handler.removeMessages(n2, (Object)monitorInfo);
            return;
        }
    }

    @Nullable
    protected final Handler getStackThreadHandler() {
        return this.stackThreadHandler;
    }

    public abstract void beginTrace(@NotNull MonitorInfo var1);

    public abstract void onTrace(@NotNull MonitorInfo var1, @NotNull StackTraceElement[] var2);

    public abstract void endTrace(@NotNull MonitorInfo var1, boolean var2);

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/tencent/rmonitor/looper/provider/MultiStackProvider$Companion;", "", "()V", "LONG_LAG_LIMIT", "", "MSG_COLLECT_COMPLETED", "", "MSG_COLLECT_START", "TAG", "", "bugly-pro_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(byte by2) {
            this();
        }
    }
}

